module.exports = {
    "desc": 	"oxsnps-soap Plugin",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
	    "level": "INFO",
	    "appenders": [
	        {
	            "type": "console",
	            "layout": {
	                "type": "pattern",
	                "pattern": "[%d] [%p] %c - %m"
	            }
	        }
	    ],
	    "replaceConsole": true
	},
    "routes": [
		{
			"path": 	"/services/soap/version",
			"method": 	"get",
			"service": 	"version"
		},
		{	
			"path": 	"/services/soap/conf",
			"method": 	"get",
			"service": 	"conf" 
		},
		{
			// This path is maintained since it has been used in sanlam for SOAP sync.transformations
			"path": 	"/TransformService",
			"method": 	"post",
			"service": 	"syncTransform"
		},
		{
			"path": 	"/services/soap/transform",
			"method": 	"post",
			"service": 	"syncTransform"
		},		
		{
			"path": 	"/services/soap/asynctransform",
			"method": 	"post",
			"service": 	"asyncTransform"
		},
		{
			"path": 	"/services/soap/status",
			"method": 	"post",
			"service": 	"status"
		}
	]
}
