/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import de.maas.saas.data.Document;
import de.maas.saas.pdf.PDFDocument;
import de.maas.saas.pdf.PDFOutputIntents;
import de.maas.saas.pdf.PDFOutputIntentsException;
import de.maas.saas.pdf.PDFPage;
import de.maas.saas.pdf.PDFXMP;
import de.maas.saas.pdf.PDFXMPException;
import de.maas.saas.pdf.box.PDFPageImageFormat;
import de.maas.saas.pdf.box.PDFPageImpl;
import de.maas.saas.pdf.box.PDFXMPImpl;
import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.utils.DataObjectFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.edit.PDPageContentStream;
import org.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

class PDFDocumentImpl
extends PDFDocument {
    private boolean simpleDocumentFlag = false;
    private Document simpleDocument = null;
    private PDDocumentCatalog documentCatalog = null;

    PDFDocumentImpl() throws IOException {
    }

    PDFDocumentImpl(COSDocument cosDocument) {
        super(cosDocument);
    }

    public PDFPage getPDFPageAt(int index) {
        PDFPage page = (PDFPage)((Object)this.getDocumentCatalog().getAllPages().get(index));
        return page;
    }

    public int getNumberOfPDFPages() {
        return this.getDocumentCatalog().getAllPages().size();
    }

    public Document getSimpleDocument() throws IOException {
        if (!this.simpleDocumentFlag) {
            Document.PageList pageList = DataObjectFactory.getSaasObjectFactory().createDocumentPageList();
            int count = 1;
            for (PDFPage page : this.getDocumentCatalog().getAllPages()) {
                pageList.getPage().add(page.getSimplePage());
                ++count;
            }
            this.simpleDocument = new Document();
            this.simpleDocument.setPageList(pageList);
            this.simpleDocument.setId(this.generateKey());
            this.simpleDocumentFlag = true;
        }
        return this.simpleDocument;
    }

    /*
     * Exception decompiling
     */
    public boolean addTiffImage(InputStream tiffInputStream) throws IOException, TiffReaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJPGImage(InputStream jpgInputStream) throws IOException, TiffReaderException {
        PDFPageImpl page = new PDFPageImpl(this.getNumberOfPDFPages() + 1);
        PDJpeg ximage = new PDJpeg((PDDocument)this, jpgInputStream);
        PDFPageImageFormat format = PDFPageImageFormat.newPDFPageImageFormat(0, 0, 4, (PDXObjectImage)ximage);
        page.setMediaBox(new PDRectangle((float)format.getWidth(), (float)format.getHeight()));
        PDPageContentStream stream = null;
        try {
            stream = new PDPageContentStream((PDDocument)this, (PDPage)page);
            stream.drawImage((PDXObjectImage)ximage, (float)format.getX(), (float)format.getY(), (float)format.getWidth(), (float)format.getHeight());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        this.addPage(page);
        return true;
    }

    protected final String generateKey() {
        long lid = (long)(Math.random() * 9.223372036854776E18);
        String result = lid + "" + System.currentTimeMillis();
        return result;
    }

    public String getXMPMetaDataAsString() throws IOException {
        int i;
        PDDocumentCatalog docCatalog = this.getDocumentCatalog();
        PDMetadata pdMeta = docCatalog.getMetadata();
        if (pdMeta == null) {
            return null;
        }
        InputStream xmlIS = pdMeta.createInputStream();
        ByteArrayOutputStream bis = new ByteArrayOutputStream();
        do {
            i = xmlIS.read();
            bis.write(i);
        } while (i >= 0);
        return new String(bis.toByteArray());
    }

    public PDFXMP getPDFXMP() throws PDFXMPException {
        PDDocumentCatalog docCatalog = this.getDocumentCatalog();
        PDMetadata pdMeta = docCatalog.getMetadata();
        if (pdMeta != null) {
            return new PDFXMPImpl(pdMeta);
        }
        return null;
    }

    public void setPDFXMP(PDFXMP pdfXMP) throws PDFXMPException {
        ((PDFXMPImpl)pdfXMP).saveToPDDocument(this);
        PDDocumentInformation pdDocumentInformation = this.getDocumentInformation();
        pdDocumentInformation.setTitle(pdfXMP.getTitle());
        pdDocumentInformation.setAuthor(pdfXMP.getAuthor());
        pdDocumentInformation.setCreator(pdfXMP.getCreatorTool());
        pdDocumentInformation.setKeywords(pdfXMP.getKeywords());
        pdDocumentInformation.setProducer(pdfXMP.getProducer());
        pdDocumentInformation.setSubject(pdfXMP.getSubject());
        Date cd = pdfXMP.getCreateDate();
        if (cd != null) {
            Calendar createDate = Calendar.getInstance();
            createDate.setTime(cd);
            pdDocumentInformation.setCreationDate(createDate);
        }
    }

    public void setOutputIntents(PDFOutputIntents outputIntents) throws PDFOutputIntentsException {
        try {
            COSName OUTPUTINTENTS = COSName.getPDFName((String)"OutputIntents");
            COSDictionary outputIntentDict = new COSDictionary();
            outputIntentDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"OutputIntent"));
            outputIntentDict.setItem(COSName.getPDFName((String)"S"), (COSBase)COSName.getPDFName((String)outputIntents.getS()));
            outputIntentDict.setString(COSName.getPDFName((String)"OutputConditionIdentifier"), outputIntents.getOutputConditionIdentifier());
            PDStream stream = new PDStream((PDDocument)this);
            COSStream dic = stream.getStream();
            dic.setInt("N", 3);
            dic.setItem(COSName.FILTER, (COSBase)COSName.FLATE_DECODE);
            byte[] destOutputProfile = outputIntents.getDestOutputProfile();
            if (destOutputProfile != null) {
                OutputStream os = dic.createUnfilteredStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(destOutputProfile);
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = bais.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                os.close();
                outputIntentDict.setItem(COSName.getPDFName((String)"DestOutputProfile"), (COSBase)dic);
            }
            destOutputProfile = null;
            COSDictionary cosDictionary = this.getDocumentCatalog().getCOSDictionary();
            COSArray outputIntentsArray = new COSArray();
            outputIntentsArray.add((COSBase)outputIntentDict);
            cosDictionary.setItem(OUTPUTINTENTS, (COSBase)outputIntentsArray);
        }
        catch (IOException e) {
            throw new PDFOutputIntentsException(e);
        }
    }

    public PDFXMP createPDFACompliantPDFXMP() throws PDFXMPException {
        return PDFXMPImpl.createBasePDFXMPCompliantWithPDFA();
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.getDocument().getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = infoDic == null ? new PDFDocumentCatalog(this) : new PDFDocumentCatalog(this, infoDic);
        }
        return this.documentCatalog;
    }

    private static class PDFPageNode
    extends PDPageNode {
        public PDFPageNode() {
        }

        public PDFPageNode(COSDictionary pages) {
            super(pages);
        }

        public List getKids() {
            ArrayList actuals = new ArrayList();
            COSArray kids = PDFPageNode.getAllKids(actuals, this.getDictionary(), false);
            return new COSArrayList(actuals, kids);
        }

        public void getAllKids(List result) {
            PDFPageNode.getAllKids(result, this.getDictionary(), true);
        }

        private static COSArray getAllKids(List result, COSDictionary page, boolean recurse) {
            COSArray kids = (COSArray)page.getDictionaryObject(COSName.KIDS);
            for (int i = 0; i < kids.size(); ++i) {
                COSBase obj = kids.getObject(i);
                if (!(obj instanceof COSDictionary)) continue;
                COSDictionary kid = (COSDictionary)obj;
                if (COSName.PAGE.equals((Object)kid.getDictionaryObject(COSName.TYPE))) {
                    result.add(PDFPageImpl.createPDFPage(i, kid));
                    continue;
                }
                if (recurse) {
                    PDFPageNode.getAllKids(result, kid, recurse);
                    continue;
                }
                result.add(new PDPageNode(kid));
            }
            return kids;
        }
    }

    private class PDFDocumentCatalog
    extends PDDocumentCatalog {
        public PDFDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
            super(doc, rootDictionary);
        }

        public PDFDocumentCatalog(PDDocument doc) {
            super(doc);
        }

        public PDPageNode getPages() {
            return new PDFPageNode((COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.PAGES));
        }
    }
}

