/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import com.sun.media.jai.codecimpl.TIFFImage;
import com.sun.media.jai.codecimpl.TIFFImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import sun.awt.image.BytePackedRaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tiff2JpgConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ByteArrayOutputStream> getJpeg(byte[] tiffImage) throws IOException {
        SeekableStream jaiStream = null;
        ArrayList<ByteArrayOutputStream> resultImageList = new ArrayList<ByteArrayOutputStream>();
        ByteArrayInputStream sourceImage = new ByteArrayInputStream(tiffImage);
        try {
            jaiStream = SeekableStream.wrapInputStream((InputStream)sourceImage, (boolean)true);
            TIFFImageDecoder imageDecoder = new TIFFImageDecoder(jaiStream, (ImageDecodeParam)new TIFFDecodeParam());
            for (int i = 0; i < imageDecoder.getNumPages(); ++i) {
                TIFFImage imagetmp = (TIFFImage)imageDecoder.decodeAsRenderedImage(i);
                ColorModel cm = imagetmp.getColorModel();
                Raster rasterImage = imagetmp.getData();
                WritableRaster rasterImageCopy = null;
                if (rasterImage instanceof WritableRaster || rasterImage instanceof BytePackedRaster) {
                    rasterImageCopy = (WritableRaster)rasterImage;
                    rasterImageCopy = imagetmp.copyData(rasterImageCopy);
                }
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                for (String name : imagetmp.getPropertyNames()) {
                    properties.put(name, imagetmp.getProperty(name));
                }
                ByteArrayOutputStream baostmp = new ByteArrayOutputStream();
                JPEGEncodeParam mainParam = null;
                JPEGImageEncoder encoder = new JPEGImageEncoder((OutputStream)baostmp, mainParam);
                BufferedImage decodedImage = new BufferedImage(cm, rasterImageCopy, true, properties);
                decodedImage.setData(rasterImage);
                mainParam = new JPEGEncodeParam();
                encoder.setParam((ImageEncodeParam)mainParam);
                encoder.encode((RenderedImage)decodedImage);
                baostmp.flush();
                resultImageList.add(baostmp);
            }
            ArrayList<ByteArrayOutputStream> arrayList = resultImageList;
            return arrayList;
        }
        finally {
            if (jaiStream != null) {
                jaiStream.close();
            }
        }
    }
}

