/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.reader.IFDEntryValue;
import de.maas.saas.tiff.util.StreamUtil;

class IFDEntry {
    int id;
    int type;
    int count;
    IFDEntryValue value;
    int currentOffset = 0;
    private boolean initFlag = false;
    private boolean resultValueFlag = false;

    IFDEntry(int id, byte[] value, boolean islittleendian) {
        this.id = id;
        this.value = new IFDEntryValue(value, islittleendian);
    }

    IFDEntry(int id, byte[] value, boolean islittleendian, int result) {
        this(id, value, islittleendian);
        this.value.resultValue = result;
        this.resultValueFlag = true;
    }

    protected void init() {
        if (!this.initFlag) {
            try {
                this.reset();
                this.skeepBytes(2);
                this.type = this.read2bytes();
                this.count = this.read4bytes();
                int numberOfBytes = this.getNumberOfBytes();
                if (!this.resultValueFlag) {
                    switch (numberOfBytes) {
                        case 1: {
                            this.value.resultValue = this.read1byte();
                            break;
                        }
                        case 2: {
                            this.value.resultValue = this.read2bytes();
                            break;
                        }
                        case 4: {
                            this.value.resultValue = this.read4bytes();
                        }
                    }
                    this.resultValueFlag = true;
                }
                if (!this.value.offsetSetFlag) {
                    this.value.setIsOffset(this.count > 1);
                }
                this.initFlag = true;
            }
            catch (Throwable e) {
                this.initFlag = false;
            }
        }
    }

    int getCount() {
        this.init();
        return this.count;
    }

    boolean isOffset() {
        this.init();
        return this.value.isOffset();
    }

    int[] getValue() {
        if (this.value.byteResultArrayValue.size() == 0) {
            return null;
        }
        if (this.value.resultArrayValueFlag) {
            return this.value.resultArrayValue;
        }
        int count = this.getCount();
        this.value.resultArrayValue = new int[count];
        int numberOfBytes = this.getNumberOfBytes();
        block5: for (int i = 0; i < count; ++i) {
            switch (numberOfBytes) {
                case 1: {
                    this.value.resultArrayValue[i] = StreamUtil.read1byte(this.value.byteResultArrayValue.get(i));
                    continue block5;
                }
                case 2: {
                    this.value.resultArrayValue[i] = StreamUtil.read2bytes(this.value.byteResultArrayValue.get(i), this.value.isLittleEndian());
                    continue block5;
                }
                case 4: {
                    this.value.resultArrayValue[i] = StreamUtil.read4bytes(this.value.byteResultArrayValue.get(i), this.value.isLittleEndian());
                }
            }
        }
        this.value.resultArrayValueFlag = true;
        return this.value.resultArrayValue;
    }

    int getValueOrOffset() {
        this.init();
        return this.value.resultValue;
    }

    int getNumberOfBytes() {
        Type tmp = Type.getType(this.type);
        if (tmp != null) {
            return tmp.numberOfBytes;
        }
        return 4;
    }

    private int read4bytes() {
        int i1 = 0xFF & this.value.byteResultValue[this.currentOffset++];
        int i2 = 0xFF & this.value.byteResultValue[this.currentOffset++];
        int i3 = 0xFF & this.value.byteResultValue[this.currentOffset++];
        int i4 = 0xFF & this.value.byteResultValue[this.currentOffset++];
        int result = this.value.isLittleEndian() ? i1 + (i2 << 8) + (i3 << 16) + (i4 << 24) : i4 + (i3 << 8) + (i2 << 16) + (i1 << 24);
        return result;
    }

    private int read2bytes() {
        int i1 = 0xFF & this.value.byteResultValue[this.currentOffset++];
        int i2 = 0xFF & this.value.byteResultValue[this.currentOffset++];
        int result = this.value.isLittleEndian() ? i1 + (i2 << 8) : (i1 << 8) + i2;
        return result;
    }

    private int read1byte() {
        int result = 0xFF & this.value.byteResultValue[this.currentOffset++];
        return result;
    }

    private void skeepBytes(int skeepValue) {
        this.currentOffset += skeepValue;
    }

    private void reset() {
        this.currentOffset = 0;
    }

    void changeValue(int newValue, int index) {
        if (this.value.byteResultArrayValue.size() <= index) {
            throw new IndexOutOfBoundsException("Can't change value in IFDEntry object at: " + index + " where size of array is: " + this.value.byteResultArrayValue.size());
        }
        byte[] bValue = this.value.byteResultArrayValue.get(index);
        int numberOfBytes = this.getNumberOfBytes();
        bValue = StreamUtil.changeValue(bValue, newValue, numberOfBytes, this.value.isLittleEndian());
        this.value.byteResultArrayValue.set(index, bValue);
    }

    void changeValue(int newValue) {
        int length = this.value.byteResultValue.length;
        int numberOfBytes = this.getNumberOfBytes();
        switch (numberOfBytes) {
            case 2: {
                byte i2;
                byte i1;
                if (this.value.isLittleEndian()) {
                    i1 = (byte)newValue;
                    i2 = (byte)(newValue >> 8);
                } else {
                    i1 = (byte)(newValue >> 8);
                    i2 = (byte)newValue;
                }
                this.value.byteResultValue[length - 4] = i1;
                this.value.byteResultValue[length - 3] = i2;
                break;
            }
            case 4: {
                byte i4;
                byte i3;
                byte i2;
                byte i1;
                if (this.value.isLittleEndian()) {
                    i1 = (byte)newValue;
                    i2 = (byte)(newValue >> 8);
                    i3 = (byte)(newValue >> 16);
                    i4 = (byte)(newValue >> 24);
                } else {
                    i1 = (byte)(newValue >> 24);
                    i2 = (byte)(newValue >> 16);
                    i3 = (byte)(newValue >> 8);
                    i4 = (byte)newValue;
                }
                this.value.byteResultValue[length - 4] = i1;
                this.value.byteResultValue[length - 3] = i2;
                this.value.byteResultValue[length - 2] = i3;
                this.value.byteResultValue[length - 1] = i4;
            }
        }
    }

    public String toString() {
        if (!this.initFlag) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nid:").append(this.id).append("\n");
        buffer.append("type:").append(this.type).append("\n");
        buffer.append("count:").append(this.count).append("\n");
        buffer.append("value:").append(this.value.resultValue).append("\n");
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.value.byteResultValue = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        BYTE(1, 1),
        ASCII(2, 1),
        SHORT(3, 2),
        LONG(4, 4),
        RATIONAL(5, 4),
        SBYTE(6, 1),
        UNDEFINE(7, 1),
        SSHORT(8, 2),
        SLONG(9, 4),
        SRATIONAL(10, 4),
        FLOAT(11, 4);

        int numberOfBytes;
        int id;

        public static Type getType(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }

        private Type(int id, int numberOfBytes) {
            this.id = id;
            this.numberOfBytes = numberOfBytes;
        }
    }
}

