/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.TiffImage;
import de.maas.saas.tiff.reader.IFD;
import de.maas.saas.tiff.reader.IFDEntry;
import de.maas.saas.tiff.reader.IFDName;
import de.maas.saas.tiff.reader.TiffImageImpl;
import java.io.IOException;
import org.pdfbox.cos.COSDictionary;

public final class TiffReaderUtil {
    public static COSDictionary createCOSDictionary(TiffImage tiffImage) throws IOException {
        TiffImageImpl imageImpl = null;
        if (tiffImage == null || !(tiffImage instanceof TiffImageImpl)) {
            throw new IllegalArgumentException("param0 is not correct argument");
        }
        imageImpl = (TiffImageImpl)tiffImage;
        IFD ifd = imageImpl.ifd;
        IFDEntry columns = ifd.directoryEntries.get((Object)IFDName.ImageWidth);
        IFDEntry rows = ifd.directoryEntries.get((Object)IFDName.ImageLength);
        IFDEntry t4compression = ifd.directoryEntries.get((Object)IFDName.Compression);
        IFDEntry blackIs1 = ifd.directoryEntries.get((Object)IFDName.PhotometricInterpretation);
        IFDEntry t42d = ifd.directoryEntries.get((Object)IFDName.T4Options);
        int k = -1000;
        if (t4compression != null) {
            if (t4compression.getValueOrOffset() == 4) {
                k = -1;
            }
            if (t4compression.getValueOrOffset() == 3) {
                k = 0;
            }
        }
        if (t42d != null && t42d.getValueOrOffset() == 1) {
            k = 50;
        }
        if (k == -1000) {
            throw new IOException("First image in tiff is not CCITT T4 or T6 compressed");
        }
        boolean bi1 = blackIs1.getValueOrOffset() == 1;
        COSDictionary cosDictParms = new COSDictionary();
        cosDictParms.setInt("Columns", columns.getValueOrOffset());
        cosDictParms.setInt("Rows", rows.getValueOrOffset());
        if (bi1) {
            cosDictParms.setBoolean("BlackIs1", true);
        } else {
            cosDictParms.setBoolean("BlackIs1", false);
        }
        cosDictParms.setInt("K", k);
        cosDictParms.setFloat("XRes", imageImpl.getXRes());
        cosDictParms.setFloat("YRes", imageImpl.getYRes());
        return cosDictParms;
    }
}

