/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.config;

import java.net.URL;
import java.util.StringTokenizer;
import org.apache.servicemix.jbi.MissingPropertyException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class TransferProtocolConfig
implements BeanNameAware,
InitializingBean {
    private String beanName = null;
    private String protocol = "ftp";
    private String host = null;
    private String port = "21";
    private String remoteDirectory = null;
    private String tmpRemoteDirectory = null;
    private String user = null;
    private String password = null;
    private String localDirectory = null;
    private String generatedURL = null;
    private String executionClass = null;
    private String scriptPath = null;
    private String ftpURI = null;
    private String defaultDateFormat = null;
    private String serverLanguageCode = null;
    private String recentDateFormat = null;
    private String serviceTimeZoneId = null;
    private String entryParser = null;
    private long timeout = 60000L;
    private Boolean userDirIsRoot = null;
    private Boolean passiveMode = true;
    private long maxTries = 5L;
    private long reconnectDelay = 5000L;
    private boolean useSubdirectories = false;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.protocol != null && this.host != null && this.remoteDirectory != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ftp").append("://");
            if (this.user != null) {
                buffer.append(this.user);
                if (this.password != null) {
                    buffer.append(":").append(this.password);
                }
                buffer.append("@");
            }
            buffer.append(this.host);
            if (this.port != null) {
                buffer.append(":").append(this.port);
            }
            if (!this.remoteDirectory.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(this.remoteDirectory);
            this.generatedURL = buffer.toString();
        } else if (this.ftpURI != null) {
            this.generatedURL = this.ftpURI;
            URL url = new URL(this.generatedURL);
            if (url.getHost() != null) {
                this.host = url.getHost();
            }
            if (url.getFile() != null) {
                this.remoteDirectory = url.getFile();
            }
            if (url.getProtocol() != null && !url.getProtocol().equals("ftp")) {
                this.protocol = "ftpvfs";
            }
            if (url.getUserInfo() != null) {
                String userInfo = url.getUserInfo();
                StringTokenizer tokenizer = new StringTokenizer(userInfo, ":");
                if (tokenizer.hasMoreElements()) {
                    this.user = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreElements()) {
                    this.password = tokenizer.nextToken();
                }
            }
        } else {
            throw new MissingPropertyException("No requiered propery ftpURI");
        }
    }

    public String getFtpURI() {
        return this.ftpURI;
    }

    public void setFtpURI(String ftpURI) {
        this.ftpURI = ftpURI;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getURL() {
        return this.generatedURL;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public String getUser() {
        return this.user;
    }

    public String getTmpRemoteDirectory() {
        return this.tmpRemoteDirectory;
    }

    public void setTmpRemoteDirectory(String tmpRemoteDirectory) {
        this.tmpRemoteDirectory = tmpRemoteDirectory;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public String getExecutionClass() {
        return this.executionClass;
    }

    public void setExecutionClass(String executionClass) {
        this.executionClass = executionClass;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public boolean isUseSubdirectories() {
        return this.useSubdirectories;
    }

    public void setUseSubdirectories(boolean useSubdirectories) {
        this.useSubdirectories = useSubdirectories;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public String getEntryParser() {
        return this.entryParser;
    }

    public void setEntryParser(String entryParser) {
        this.entryParser = entryParser;
    }

    public Boolean getPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(Boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public String getRecentDateFormat() {
        return this.recentDateFormat;
    }

    public void setRecentDateFormat(String recentDateFormat) {
        this.recentDateFormat = recentDateFormat;
    }

    public String getServerLanguageCode() {
        return this.serverLanguageCode;
    }

    public void setServerLanguageCode(String serverLanguageCode) {
        this.serverLanguageCode = serverLanguageCode;
    }

    public String getServiceTimeZoneId() {
        return this.serviceTimeZoneId;
    }

    public void setServiceTimeZoneId(String serviceTimeZoneId) {
        this.serviceTimeZoneId = serviceTimeZoneId;
    }

    public Boolean getUserDirIsRoot() {
        return this.userDirIsRoot;
    }

    public void setUserDirIsRoot(Boolean userDirIsRoot) {
        this.userDirIsRoot = userDirIsRoot;
    }

    public long getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(long maxTries) {
        this.maxTries = maxTries;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }
}

