/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.xml.parsers.impl;

import de.maas.saas.exceptions.XMLParseException;
import de.maas.saas.xml.parsers.ActionListParseable;
import de.maas.saas.xml.parsers.ScenarioParseable;
import de.maas.saas.xml.parsers.impl.ActionListParseableImpl;
import de.maas.saas.xml.parsers.impl.XMLParser;
import de.maas.saas.xml.parsers.impl.XPathExpressionBuilder;
import java.io.InputStream;
import org.w3c.dom.Node;

class ScenarioParseableImpl
extends XMLParser
implements ScenarioParseable {
    private static final String ELEMENT_SCENARIO_LIST = "scenario-list";
    private static final String ELEMENT_SCENARIO = "scenario";
    private static final String ELEMENT_SCENARIO_NAME = "name";
    private static final String ELEMENT_SCENARIO_INDEX_PATH = "index-path";
    private static final String ELEMENT_SCENARIO_TYPE = "type";
    private static final String ELEMENT_SCENARIO_ACTION_LIST = "action-list";
    private ScenarioXPathExpressionBuilder expressionBuilder = new ScenarioXPathExpressionBuilder();

    public ScenarioParseableImpl(InputStream sourceXml) throws XMLParseException {
        super(sourceXml);
    }

    public ActionListParseable getActionListAt(int index) throws XMLParseException {
        Node node = this.getNodeResult(this.expressionBuilder.buildActionListExpression(index));
        if (node == null) {
            return null;
        }
        return new ActionListParseableImpl(node);
    }

    public int getScenarioListSize() throws XMLParseException {
        return this.getIntResult(this.expressionBuilder.buildScenarioListSizeExpression());
    }

    public String getScenarioNameAt(int index) throws XMLParseException {
        return this.getStringResult(this.expressionBuilder.buildScenarioNameExpression(index));
    }

    public String getIndexPathAt(int index) throws XMLParseException {
        return this.getStringResult(this.expressionBuilder.buildIndexPathExpression(index));
    }

    public String getTypeAt(int index) throws XMLParseException {
        return this.getStringResult(this.expressionBuilder.buildScenarioTypeExpression(index));
    }

    private class ScenarioXPathExpressionBuilder {
        private XPathExpressionBuilder builder = new XPathExpressionBuilder();
        private String[] scenario = new String[]{"scenario-list", "scenario"};
        private String[] indexPath = new String[]{"index-path"};
        private String[] scenarioName = new String[]{"name"};
        private String[] scenarioType = new String[]{"type"};
        private String[] actionList = new String[]{"action-list"};

        private ScenarioXPathExpressionBuilder() {
        }

        public String buildScenarioListSizeExpression() {
            return this.builder.buildCountElementExpression(false, this.scenario);
        }

        public String buildIndexPathExpression(int index) {
            return this.builder.buildPositionElementExpression(false, this.scenario, index, this.indexPath);
        }

        public String buildScenarioNameExpression(int index) {
            return this.builder.buildPositionElementExpression(false, this.scenario, index, this.scenarioName);
        }

        public String buildScenarioTypeExpression(int index) {
            return this.builder.buildPositionElementExpression(false, this.scenario, index, this.scenarioType);
        }

        public String buildActionListExpression(int index) {
            return this.builder.buildPositionElementExpression(false, this.scenario, index, this.actionList);
        }
    }
}

