/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.xml.parsers.impl;

import de.maas.saas.exceptions.XMLParseException;
import de.maas.saas.utils.XPathApi;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLParser {
    private Node root = null;
    private DOMBuilderFactory builderFactory = new DOMBuilderFactory();

    public XMLParser(InputStream sourceXml) throws XMLParseException {
        try {
            DocumentBuilder builder = this.builderFactory.getDocumentBuilderInstance();
            this.root = builder.parse(sourceXml);
        }
        catch (SAXException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
    }

    public XMLParser(File fileName) throws XMLParseException {
        try {
            DocumentBuilder builder = this.builderFactory.getDocumentBuilderInstance();
            this.root = builder.parse(fileName);
        }
        catch (SAXException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
    }

    public XMLParser(Node root) {
        this.root = root;
    }

    private String executeStringExpression(String expression) throws XPathException {
        return XPathApi.selectString(this.root, expression, null);
    }

    private Node executeNodeExpresion(String expression) throws XPathException {
        return (Node)XPathApi.selectSingleNode(this.root, expression, null);
    }

    protected String getStringResult(String expression) throws XMLParseException {
        try {
            String result = this.executeStringExpression(expression);
            if (result == null || result.length() == 0) {
                return null;
            }
            return result;
        }
        catch (XPathException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
    }

    protected int getIntResult(String expression) throws XMLParseException {
        try {
            String result = this.executeStringExpression(expression);
            if (result == null || result.length() == 0) {
                return 0;
            }
            return Integer.parseInt(result);
        }
        catch (XPathException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
    }

    protected Node getNodeResult(String expression) throws XMLParseException {
        try {
            return this.executeNodeExpresion(expression);
        }
        catch (XPathException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
    }

    private class DOMBuilderFactory {
        private DocumentBuilder builder = null;

        private DOMBuilderFactory() {
        }

        public DocumentBuilder getDocumentBuilderInstance() throws XMLParseException {
            if (this.builder != null) {
                return this.builder;
            }
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            try {
                this.builder = builderFactory.newDocumentBuilder();
                return this.builder;
            }
            catch (ParserConfigurationException e) {
                throw new XMLParseException(e.getMessage(), e);
            }
        }
    }
}

