/*
 * Decompiled with CFR 0.152.
 */
package de.maas.office2any;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import de.maas.office2any.Config;
import de.maas.office2any.MSOfficeTransformerWrapperException;
import de.maas.oxseed.office2any.DcomMSOfficeFactory;
import de.maas.oxseed.office2any.MSOffice2007Shared;
import de.maas.oxseed.office2any.MSOffice2007Transformer;
import de.maas.oxseed.office2any.exceptions.MSOffice2007TransformerException;
import de.maas.oxseed.office2any.managers.DcomProcessManagerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.log4j.Logger;
import org.jinterop.dcom.common.JISystem;

public class MSOfficeTransformerWrapper {
    private static String VERSION = "2.0.0.1";
    private static Logger logger = Logger.getLogger(MSOfficeTransformerWrapper.class);
    private Config config = null;
    private boolean bInitialized = false;
    private boolean bOldKilled = false;
    private MSOffice2007Transformer office2007Transformer;
    private static boolean bLogDebugEnabledThe = logger.isDebugEnabled();

    public synchronized void start(String sConfigFilenamePar) throws MSOfficeTransformerWrapperException, MSOffice2007TransformerException {
        if (this.bInitialized) {
            return;
        }
        logger.info((Object)"Starting MSOffice Transformer Wrapper.");
        try {
            this.config = this.parseConfiguration(sConfigFilenamePar);
            this.validateConfiguration(this.config);
            this.initTransformer();
        }
        catch (Exception ePar) {
            ByteArrayOutputStream osErrTmp = new ByteArrayOutputStream();
            ePar.printStackTrace(new PrintStream(osErrTmp));
            logger.error((Object)("Exception occurred while initializing MSOfficeTransformerWrapper. " + ePar.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            throw new MSOfficeTransformerWrapperException("Exception occurred while initializing MSOfficeTransformerWrapper. " + ePar.getMessage(), ePar);
        }
        this.bInitialized = true;
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String jvmName = runtimeBean.getName();
        logger.info((Object)("MSOffice Transformer Wrapper started. JVM Process id:" + Long.valueOf(jvmName.split("@")[0]) + ", Config:" + this.config.toString()));
    }

    public String getVersion() {
        Gson gson = new Gson();
        String sRetTmp = gson.toJson((Object)VERSION);
        return sRetTmp;
    }

    public String process(String sInputPar) throws MSOfficeTransformerWrapperException {
        long timeBeginTmp;
        byte[] byBufferTmp = null;
        Gson gsonTmp = null;
        JsonParser jsonParserTmp = null;
        byte[] byRetTmp = null;
        String sSourceUserPwdTmp = null;
        String sSourceOwnerPwdTmp = null;
        String sInputTypeTmp = null;
        String sOutputTypeTmp = null;
        try {
            String sCrashTmp;
            if (sInputPar == null) {
                throw new MSOfficeTransformerWrapperException("Input JSON String parameter passed to office converter process method is null");
            }
            if (sInputPar.length() <= 0) {
                throw new MSOfficeTransformerWrapperException("Input JSON String parameter passed to office converter process method is empty");
            }
            if (bLogDebugEnabledThe) {
                logger.debug((Object)("Started processing Office2Any request. Input JSON String:" + sInputPar));
            } else {
                logger.info((Object)"Started processing Office2Any request. ");
            }
            timeBeginTmp = System.currentTimeMillis();
            jsonParserTmp = new JsonParser();
            JsonElement jsonElementTmp = jsonParserTmp.parse(sInputPar);
            if (jsonElementTmp == null) {
                throw new MSOfficeTransformerWrapperException("Input JSON String parameter passed to office converter process method is not a JSON string");
            }
            if (!jsonElementTmp.isJsonObject()) {
                throw new MSOfficeTransformerWrapperException("Input JSON String parameter passed to office converter process method is not a JSON object");
            }
            JsonObject jsonArgsTmp = jsonElementTmp.getAsJsonObject();
            if (jsonArgsTmp == null) {
                throw new MSOfficeTransformerWrapperException("Error on parsing JSON Input parameter passed to office converter process method");
            }
            jsonElementTmp = jsonArgsTmp.get("inputBuffer");
            if (jsonElementTmp == null) {
                throw new MSOfficeTransformerWrapperException("JSON Input string passed to office converter process method, does not contain \"inputBuffer \" parameter.");
            }
            if (!jsonElementTmp.isJsonArray()) {
                throw new MSOfficeTransformerWrapperException("\"inputBuffer \" parameter in JSON Input string passed to office converter process method, is not an array.");
            }
            gsonTmp = new Gson();
            JsonArray arrayTmp = jsonElementTmp.getAsJsonArray();
            byBufferTmp = (byte[])gsonTmp.fromJson((JsonElement)arrayTmp, byte[].class);
            jsonElementTmp = jsonArgsTmp.get("sourceUserPWD");
            if (jsonElementTmp != null) {
                sSourceUserPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("sourceOwnerPWD")) != null) {
                sSourceOwnerPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("inputType")) != null) {
                sInputTypeTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("outputType")) != null) {
                sOutputTypeTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("crash")) != null && (sCrashTmp = jsonElementTmp.getAsString()) != null && (sCrashTmp.equalsIgnoreCase("on") || sCrashTmp.equalsIgnoreCase("yes"))) {
                logger.info((Object)"Office2Any service crashed intentionally for testing crash case scenario.");
                System.exit(-1);
            }
            byRetTmp = this.process(byBufferTmp, sSourceUserPwdTmp, sSourceOwnerPwdTmp, sInputTypeTmp, sOutputTypeTmp);
        }
        catch (Exception ePar) {
            ByteArrayOutputStream osErrTmp = null;
            osErrTmp = new ByteArrayOutputStream();
            ePar.printStackTrace(new PrintStream(osErrTmp));
            logger.error((Object)("Exception occurred on converting office document " + (sInputTypeTmp != null ? " of " + sInputTypeTmp + " type " : "") + (sOutputTypeTmp != null ? " to " + sOutputTypeTmp + "." : "") + (byBufferTmp == null ? "" : " Input Buffer Length: " + byBufferTmp.length + ",") + " " + ePar.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            throw new MSOfficeTransformerWrapperException("Exception occurred on converting office document " + (sInputTypeTmp != null ? " of " + sInputTypeTmp + " type" : "") + (sOutputTypeTmp != null ? " to " + sOutputTypeTmp + "." : "") + (byBufferTmp == null ? "" : " Input Buffer Length: " + byBufferTmp.length + ",") + " " + ePar.getMessage(), ePar);
        }
        String sRetTmp = gsonTmp.toJson((Object)byRetTmp);
        long timeEndTmp = System.currentTimeMillis();
        logger.info((Object)("Finished processing Office2Any request. Input Buffer Length:" + (byBufferTmp == null ? 0 : byBufferTmp.length) + ", InputType:" + (sInputTypeTmp == null ? "" : sInputTypeTmp) + ", Output Buffer Length:" + (byRetTmp == null ? 0 : byRetTmp.length) + ", OutputType:" + (sOutputTypeTmp == null ? "" : sOutputTypeTmp) + ", TimeTaken: " + (timeEndTmp - timeBeginTmp) / 1000L + " sec(s)."));
        return sRetTmp;
    }

    public byte[] process(byte[] byArrInputDataPar, String sUserPwdPar, String sOwnerPwdPar, String sInputTypePar, String sOutputTypePar) throws MSOfficeTransformerWrapperException {
        if (byArrInputDataPar == null || byArrInputDataPar.length <= 0) {
            throw new MSOfficeTransformerWrapperException("Parameter Input Byte Array is null or empty.");
        }
        ByteArrayInputStream baisTmp = new ByteArrayInputStream(byArrInputDataPar);
        byte[] byArrOutDataTmp = this.process(baisTmp, sUserPwdPar, sOwnerPwdPar, sInputTypePar, sOutputTypePar);
        return byArrOutDataTmp;
    }

    public byte[] process(InputStream isSourcePar, String sUserPwdPar, String sOwnerPwdPar, String sInputTypePar, String sOutputTypePar) throws MSOfficeTransformerWrapperException {
        InputStream inputStreamTmp = null;
        byte[] byArrConvertedTmp = null;
        int iInputLenTmp = 0;
        try {
            if (!this.bInitialized) {
                throw new MSOfficeTransformerWrapperException("MSOfifceTransformerWrapper not initialized.");
            }
            if (isSourcePar == null || isSourcePar.available() <= 0) {
                throw new MSOfficeTransformerWrapperException("Parameter InputStream is null or stream data size is zero.");
            }
            if (sInputTypePar == null || sInputTypePar.length() <= 0) {
                throw new MSOfficeTransformerWrapperException("Parameter InputType is null or empty.");
            }
            if (sOutputTypePar == null || sOutputTypePar.length() <= 0) {
                throw new MSOfficeTransformerWrapperException("Parameter OutputType is null or empty.");
            }
            if (!(sOutputTypePar.equalsIgnoreCase("pdf") || sOutputTypePar.equalsIgnoreCase("tif") || sOutputTypePar.equalsIgnoreCase("tiff"))) {
                throw new MSOfficeTransformerWrapperException("Invalid value for OutputType parameter. OutputType can be pdf or tif or tiff. Given Value:" + sOutputTypePar);
            }
            iInputLenTmp = isSourcePar.available();
            String sSourceTmp = sInputTypePar;
            if (sSourceTmp.equalsIgnoreCase("word")) {
                sSourceTmp = "doc";
            } else if (sSourceTmp.equalsIgnoreCase("excel")) {
                sSourceTmp = "xls";
            } else if (sSourceTmp.equalsIgnoreCase("excel2007")) {
                sSourceTmp = "xlsx";
            } else if (sSourceTmp.equalsIgnoreCase("htm") || sSourceTmp.equalsIgnoreCase("html")) {
                sSourceTmp = "html";
            }
            String sPwdTmp = null;
            sPwdTmp = sUserPwdPar != null ? sUserPwdPar : sOwnerPwdPar;
            logger.info((Object)("Office2Any request parameters: InputDataLen:" + iInputLenTmp + ", IntputType:" + sInputTypePar + ", InputPassword:" + sPwdTmp + ", OutputType:" + sOutputTypePar));
            inputStreamTmp = new BufferedInputStream(isSourcePar);
            Properties propertiesTmp = this.config.getDcomProperties();
            int iRequestTimeoutTmp = Integer.parseInt(propertiesTmp.getProperty("timeout"));
            if (sSourceTmp.equalsIgnoreCase("doc") || sSourceTmp.equalsIgnoreCase("rtf") || sSourceTmp.equalsIgnoreCase("docx") || sSourceTmp.equalsIgnoreCase("html")) {
                byArrConvertedTmp = this.office2007Transformer.transform(inputStreamTmp, MSOffice2007Shared.getContentTypeByExtension((String)sSourceTmp), MSOffice2007Shared.getOutMimeTypeByExtension((String)sOutputTypePar), "APPLICATION_AUTO", 1L, (long)iRequestTimeoutTmp, sPwdTmp);
            } else if (sSourceTmp.equalsIgnoreCase("htmlt")) {
                byArrConvertedTmp = this.office2007Transformer.transform(inputStreamTmp, 4352L, MSOffice2007Shared.getOutMimeTypeByExtension((String)sOutputTypePar), "APPLICATION_AUTO", 1L, (long)iRequestTimeoutTmp, sPwdTmp);
            } else if (sSourceTmp.equalsIgnoreCase("xls") || sSourceTmp.equalsIgnoreCase("xlsx")) {
                byArrConvertedTmp = this.office2007Transformer.transform(inputStreamTmp, MSOffice2007Shared.getContentTypeByExtension((String)sSourceTmp), MSOffice2007Shared.getOutMimeTypeByExtension((String)sOutputTypePar), "APPLICATION_AUTO", 1L, (long)iRequestTimeoutTmp, sPwdTmp);
            } else if (sSourceTmp.equalsIgnoreCase("htmlz")) {
                byArrConvertedTmp = this.office2007Transformer.transform(inputStreamTmp, 65792L, MSOffice2007Shared.getOutMimeTypeByExtension((String)sOutputTypePar), "APPLICATION_AUTO", 1L, (long)iRequestTimeoutTmp, sPwdTmp);
            } else {
                throw new MSOfficeTransformerWrapperException("Invalid input type:" + sSourceTmp);
            }
            if (byArrConvertedTmp == null || byArrConvertedTmp.length <= 0) {
                throw new MSOfficeTransformerWrapperException("Output document from MSOffice converter is null or empty");
            }
            if (sOutputTypePar.equals("pdf") && (this.config.getPdfProducer() != null || this.config.getPdfCreator() != null)) {
                if (bLogDebugEnabledThe) {
                    logger.debug((Object)"Started setting PDF properties(Producer, Creator) in output pdf document ...");
                }
                PdfReader tmpDoc = new PdfReader(byArrConvertedTmp, null);
                ByteArrayOutputStream encOut = new ByteArrayOutputStream();
                PdfStamper stamper = new PdfStamper(tmpDoc, (OutputStream)encOut);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("Producer", this.config.getPdfProducer());
                info.put("Creator", this.config.getPdfCreator());
                stamper.setMoreInfo(info);
                stamper.close();
                byArrConvertedTmp = encOut.toByteArray();
                if (bLogDebugEnabledThe) {
                    logger.debug((Object)"Finished setting PDF properties(Producer, Creator) in output pdf document.");
                }
            }
        }
        catch (Exception ePar2) {
            ByteArrayOutputStream osErrTmp = new ByteArrayOutputStream();
            ePar2.printStackTrace(new PrintStream(osErrTmp));
            logger.error((Object)("Exception occurred on transforming office document.InputDataLen:" + iInputLenTmp + ", IntputType:" + sInputTypePar + ", OpenPassword:" + sUserPwdPar + ", OutputType:" + sOutputTypePar + ". " + ePar2.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            throw new MSOfficeTransformerWrapperException("Exception occurred on transforming office document.InputDataLen:" + iInputLenTmp + ", IntputType:" + sInputTypePar + ", OpenPassword:" + sUserPwdPar + ", OutputType:" + sOutputTypePar + ". " + ePar2.getMessage(), ePar2);
        }
        finally {
            try {
                if (inputStreamTmp != null) {
                    inputStreamTmp.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error occurred while closing Buffered Input Stream created for passed input streamed parameter. " + e.getMessage()), (Throwable)e);
            }
        }
        return byArrConvertedTmp;
    }

    public synchronized void stop() throws MSOfficeTransformerWrapperException {
        if (!this.bInitialized) {
            return;
        }
        try {
            if (this.office2007Transformer != null) {
                this.office2007Transformer.close();
                this.office2007Transformer = null;
            }
        }
        catch (Exception ePar1) {
            ByteArrayOutputStream osErrTmp = new ByteArrayOutputStream();
            ePar1.printStackTrace(new PrintStream(osErrTmp));
            logger.error((Object)("Exception occurred on stopping MSOfficeTransformerWrapper. " + ePar1.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            throw new MSOfficeTransformerWrapperException("Exception occurred on stopping MSOfficeTransformerWrapper.  " + ePar1.getMessage(), ePar1);
        }
        this.bInitialized = false;
        logger.info((Object)"MSOffice Transformer Wrapper Stopped.");
    }

    private void initTransformer() throws MSOffice2007TransformerException {
        this.killOldApps();
        this.office2007Transformer = DcomMSOfficeFactory.createDcomMSOffice2007TransformerImpl((Properties)this.config.getDcomProperties());
    }

    private void killOldApps() throws MSOffice2007TransformerException {
        JISystem.getLogger().setLevel(Level.OFF);
        if (this.config.isKillWordsExcelsAtStartup() && !this.bOldKilled) {
            Properties propTmp = this.config.getDcomProperties();
            try {
                logger.info((Object)"Killing word and excel tasks");
                List<String> applicationsTmp = Arrays.asList("WINWORD.EXE", "EXCEL.EXE");
                DcomProcessManagerImpl processManagerTmp = new DcomProcessManagerImpl(propTmp.getProperty("dcomHost"), propTmp.getProperty("dcomDomain"), propTmp.getProperty("dcomUser"), propTmp.getProperty("dcomPassword"));
                processManagerTmp.killApplications(applicationsTmp);
                processManagerTmp.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new MSOffice2007TransformerException("Office applications could not be killed successfully. " + e.getMessage());
            }
            this.bOldKilled = true;
        }
    }

    private Config parseConfiguration(String sConfigPar) throws MSOfficeTransformerWrapperException {
        Config configTmp = null;
        Map mapJSONTmp = null;
        FileReader readerTmp = null;
        String sConfigFilenameTmp = "";
        try {
            if (sConfigPar == null) {
                throw new MSOfficeTransformerWrapperException("Configuration parameter passed as JSON String to start method is null");
            }
            if (sConfigPar.length() <= 0) {
                throw new MSOfficeTransformerWrapperException("Configuration parameter passed as JSON String to start method is empty");
            }
            Gson gsonTmp = new Gson();
            mapJSONTmp = (Map)gsonTmp.fromJson(sConfigPar, Map.class);
            sConfigFilenameTmp = (String)mapJSONTmp.get("confFile");
            readerTmp = new FileReader(sConfigFilenameTmp);
            BufferedReader bufreaderTmp = new BufferedReader(readerTmp);
            mapJSONTmp = (Map)gsonTmp.fromJson((Reader)bufreaderTmp, Map.class);
            String sKeyTmp = null;
            Object objValueTmp = null;
            Map.Entry entryTmp = null;
            Iterator iterTmp = mapJSONTmp.entrySet().iterator();
            configTmp = new Config();
            configTmp.setFilename(sConfigFilenameTmp);
            while (iterTmp.hasNext()) {
                entryTmp = iterTmp.next();
                sKeyTmp = (String)entryTmp.getKey();
                objValueTmp = entryTmp.getValue();
                if (sKeyTmp.equalsIgnoreCase("PDFCreatorApplication") && objValueTmp instanceof String) {
                    configTmp.setPdfCreator(objValueTmp);
                    continue;
                }
                if (sKeyTmp.equalsIgnoreCase("PDFProducer") && objValueTmp instanceof String) {
                    configTmp.setPdfProducer(objValueTmp);
                    continue;
                }
                if (sKeyTmp.equalsIgnoreCase("DCOM") && objValueTmp instanceof Map) {
                    Map mapDCOMTmp = objValueTmp;
                    Properties propertiesTmp = new Properties();
                    propertiesTmp.putAll((Map<?, ?>)mapDCOMTmp);
                    configTmp.setDcomProperties(propertiesTmp);
                    continue;
                }
                logger.warn((Object)("Invalid key or invalid value for key. Key: " + sKeyTmp));
            }
            if (configTmp.getDcomProperties() == null) {
                throw new MSOfficeTransformerWrapperException("DCOM propertie not found in configuration file. Filename:" + sConfigFilenameTmp);
            }
            return configTmp;
        }
        catch (FileNotFoundException fnfePar) {
            throw new MSOfficeTransformerWrapperException("FileNotFoundException. Filename:" + sConfigFilenameTmp + ", " + fnfePar.getMessage());
        }
        catch (IOException ioePar) {
            throw new MSOfficeTransformerWrapperException("IOException. Filename:" + sConfigFilenameTmp + ", " + ioePar.getMessage());
        }
        catch (Exception ioePar) {
            throw new MSOfficeTransformerWrapperException("Filename:" + sConfigFilenameTmp + ", " + ioePar.getMessage());
        }
    }

    private void validateConfiguration(Config configPar) throws MSOfficeTransformerWrapperException {
        if (configPar == null) {
            throw new MSOfficeTransformerWrapperException("MSOfficeTransformerWrapper configuration object is null");
        }
        Properties propertiesTmp = configPar.getDcomProperties();
        if (propertiesTmp == null) {
            throw new MSOfficeTransformerWrapperException("DCOM properties not found in configuration file. Filename:" + configPar.getFilename());
        }
        int iTmp = 0;
        if (propertiesTmp.containsKey("timeout")) {
            try {
                iTmp = Integer.parseInt(propertiesTmp.getProperty("timeout"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"DCOM:{ timeout } is not integer. Using default value of 50000");
            }
        } else {
            logger.debug((Object)"DCOM:{ timeout } is not set. Using default value of 50000");
        }
        if (iTmp <= 0) {
            propertiesTmp.setProperty("timeout", "50000");
        }
        iTmp = 0;
        if (propertiesTmp.containsKey("numberWordAppInPool")) {
            try {
                iTmp = Integer.parseInt(propertiesTmp.getProperty("numberWordAppInPool"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"DCOM: {numberWordAppInPool } is not integer. Using default value of 4");
            }
        } else {
            logger.debug((Object)"DCOM: {numberWordAppInPool } is not set. Using default value of 4");
        }
        if (iTmp < 0) {
            propertiesTmp.setProperty("numberWordAppInPool", "4");
        }
        iTmp = 0;
        if (propertiesTmp.containsKey("numberExcelAppInPool")) {
            try {
                iTmp = Integer.parseInt(propertiesTmp.getProperty("numberExcelAppInPool"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"DCOM:{ numberExcelAppInPool } is not integer. Using default value of 4");
            }
        } else {
            logger.debug((Object)"DCOM:{ numberExcelAppInPool } is not set. Using default value of 4");
        }
        if (iTmp < 0) {
            propertiesTmp.setProperty("numberExcelAppInPool", "4");
        }
        iTmp = 0;
        if (propertiesTmp.containsKey("horizontalPrintQuality")) {
            try {
                iTmp = Integer.parseInt(propertiesTmp.getProperty("horizontalPrintQuality"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"DCOM:{ horizontalPrintQuality } is not integer. Using default value of 300");
            }
        } else {
            logger.debug((Object)"DCOM:{ horizontalPrintQuality } is not set. Using default value of 300");
        }
        if (iTmp <= 0) {
            propertiesTmp.setProperty("horizontalPrintQuality", "300");
        }
        iTmp = 0;
        if (propertiesTmp.containsKey("verticalPrintQuality")) {
            try {
                iTmp = Integer.parseInt(propertiesTmp.getProperty("verticalPrintQuality"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"DCOM:{ verticalPrintQuality } is not integer. Using default value of 300");
            }
        } else {
            logger.debug((Object)"DCOM:{ verticalPrintQuality } is not set. Using default value of 300");
        }
        if (iTmp <= 0) {
            propertiesTmp.setProperty("verticalPrintQuality", "300");
        }
        logger.debug((Object)("Config:" + this.config.toString()));
    }
}

