/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any;

import de.maas.oxseed.office2any.DcomConstants;
import de.maas.oxseed.office2any.DcomMSOfficeFactory;
import de.maas.oxseed.office2any.MSOffice2007ApplicationManager;
import de.maas.oxseed.office2any.MSOffice2007TransformerImpl;
import de.maas.oxseed.office2any.bean.RequestInfo;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueueImpl;
import de.maas.oxseed.office2any.exceptions.MSOffice2007TransformerException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class DcomMSOffice2007TransformerImpl
extends MSOffice2007TransformerImpl {
    private static Logger logger = Logger.getLogger(DcomMSOffice2007TransformerImpl.class);
    protected AtomicInteger iterator = new AtomicInteger(0);
    protected String host;
    protected String domain;
    protected String username;
    protected String password;

    public DcomMSOffice2007TransformerImpl(int countWordApp, int countExcelApp, String urlStorage, String host, String domain, String username, String password, double horizontalPrintQuality, double verticalPrintQuality) {
        super(countWordApp, countExcelApp, urlStorage, horizontalPrintQuality, verticalPrintQuality);
        this.host = host;
        this.domain = domain;
        this.username = username;
        this.password = password;
    }

    protected MSOffice2007ApplicationManager createApplicationManagerInstance(String application, int count) throws MSOffice2007TransformerException {
        int capacity = DcomConstants.INPUT_QUEUE_MAX_SIZE;
        BlockingCommandQueueImpl<RequestInfo> queueRequest = new BlockingCommandQueueImpl<RequestInfo>(capacity);
        MSOffice2007ApplicationManager app = DcomMSOfficeFactory.createDcomMSOffice2007ApplicationManager(application, count, queueRequest, this.resultListener, this.urlStorage, this.host, this.domain, this.username, this.password);
        return app;
    }

    protected String generateId() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis()).append('_').append(this.iterator.incrementAndGet());
        return sb.toString();
    }
}

