/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any;

import de.maas.oxseed.office2any.MSOffice2007Converter;
import de.maas.oxseed.office2any.bean.RequestInfo;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueue;
import de.maas.oxseed.office2any.blocking.ResultListener;
import de.maas.oxseed.office2any.exceptions.MSOffice2007ApplicationManagerException;
import de.maas.oxseed.office2any.exceptions.MSOffice2007ConverterException;
import de.maas.oxseed.office2any.exceptions.MSOffice2007TransformerException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MSOffice2007ApplicationManager {
    public static Logger logger = Logger.getLogger(MSOffice2007ApplicationManager.class);
    protected String applicationName;
    protected List<MSOffice2007Converter> converters;
    protected int corePoolSize;
    protected BlockingCommandQueue<RequestInfo> queueRequest;
    protected ResultListener resultListener;
    protected String urlStorage;

    public MSOffice2007ApplicationManager(String applicationName, int corePoolSize, BlockingCommandQueue<RequestInfo> queueRequest, ResultListener resultListener, String urlStorage) {
        this.applicationName = applicationName;
        this.corePoolSize = corePoolSize;
        this.queueRequest = queueRequest;
        this.resultListener = resultListener;
        this.urlStorage = urlStorage;
    }

    public void init() throws MSOffice2007TransformerException {
        this.converters = new ArrayList<MSOffice2007Converter>();
        for (int i = 0; i < this.corePoolSize; ++i) {
            MSOffice2007Converter converter = this.createConverterInstance(this.applicationName + "-" + Integer.toString(i + 1), this.applicationName, this.queueRequest, this.resultListener, this.urlStorage);
            try {
                converter.init();
            }
            catch (MSOffice2007ConverterException e) {
                throw new MSOffice2007TransformerException("Error while create instance of MSOffice2007Converter", (Throwable)((Object)e));
            }
            converter.start();
            this.converters.add(converter);
        }
    }

    public void addTask(RequestInfo requestInfo) {
        this.queueRequest.add(requestInfo);
    }

    public boolean interruptTask(String id) {
        for (MSOffice2007Converter converter : this.converters) {
            if (!converter.interruptTaskIfRunning(id)) continue;
            return true;
        }
        return false;
    }

    public void stopSignal() {
        for (MSOffice2007Converter converter : this.converters) {
            converter.stopSignal();
        }
    }

    public void stop() {
        for (MSOffice2007Converter converter : this.converters) {
            try {
                converter.stop();
            }
            catch (MSOffice2007ConverterException mSOffice2007ConverterException) {}
        }
    }

    public void releaseResources() throws MSOffice2007ApplicationManagerException {
        for (MSOffice2007Converter converter : this.converters) {
            try {
                converter.releaseResources();
            }
            catch (MSOffice2007ConverterException e) {
                throw new MSOffice2007ApplicationManagerException((Throwable)((Object)e));
            }
        }
    }

    protected abstract MSOffice2007Converter createConverterInstance(String var1, String var2, BlockingCommandQueue<RequestInfo> var3, ResultListener var4, String var5);
}

