/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any;

import com.oxseed.common.utils.FileUtil;
import com.oxseed.common.utils.StreamUtil;
import com.oxseed.common.utils.ZipUtil;
import de.maas.oxseed.office2any.DcomConstants;
import de.maas.oxseed.office2any.MSOffice2007Shared;
import de.maas.oxseed.office2any.bean.ProcessInfo;
import de.maas.oxseed.office2any.bean.RequestInfo;
import de.maas.oxseed.office2any.bean.ResultInfo;
import de.maas.oxseed.office2any.bean.ResultInfoImpl;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueue;
import de.maas.oxseed.office2any.blocking.ResultListener;
import de.maas.oxseed.office2any.exceptions.MSOffice2007ConverterException;
import de.maas.oxseed.office2any.exceptions.MSOffice2007RuntimeException;
import de.maas.oxseed.office2any.exceptions.MSOffice2007UnsupportedFormatException;
import de.maas.oxseed.office2any.exceptions.MSOfficeManagerException;
import de.maas.oxseed.office2any.exceptions.ProcessManagerException;
import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.managers.MSOfficeManager;
import de.maas.oxseed.office2any.managers.ProcessManager;
import de.maas.oxseed.office2any.storage.Storage;
import de.maas.oxseed.office2any.storage.StorageFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MSOffice2007Converter {
    public static final Logger logger = Logger.getLogger(MSOffice2007Converter.class);
    public static final int STATE_NOT_INITED = 0;
    public static final int STATE_INITED_NOT_STARTED = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_ERROR = -1;
    public static final int STATE_ERROR_NOT_STOPPED = -2;
    private static final int DCOM_EXCEPTION_TYPE_INTERNAL_ERROR = -2147352577;
    private static final int DCOM_EXCEPTION_FROM_SERVER = -2147352567;
    private static final int DCOM_EXCEPTION_UNKNOWN = 1;
    private static final double EPS = 1.0E-10;
    protected String application;
    protected BlockingCommandQueue<RequestInfo> queueRequest;
    protected ResultListener resultListener;
    protected String urlStorage;
    protected AtomicInteger workerState = new AtomicInteger(0);
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected String id;
    protected MSOfficeManager manager;
    protected int PID;
    protected Thread threadMainCycle;
    protected ScheduledThreadPoolExecutor helperExecutor;
    protected Object currentLock = new Object();
    protected Future<ResultInfo> currentFuture;
    protected String currentId;

    public MSOffice2007Converter(String id, String application, BlockingCommandQueue<RequestInfo> queueRequest, ResultListener resultListener, String urlStorage) {
        this.id = id;
        this.application = application;
        this.queueRequest = queueRequest;
        this.resultListener = resultListener;
        this.urlStorage = urlStorage;
        this.startDaemonManager();
    }

    public void init() throws MSOffice2007ConverterException {
        if (this.workerState.get() != 0) {
            logger.warn((Object)("[" + this.id + "]. Before init, state excepted " + MSOffice2007Converter.getStateDescription(0) + " but was" + MSOffice2007Converter.getStateDescription(this.workerState.get())));
            throw new MSOffice2007RuntimeException("Before init, converter should be not inited");
        }
        try {
            try {
                Thread.sleep(DcomConstants.DCOM_SYSTEM_DELAY);
            }
            catch (InterruptedException e) {
                logger.error((Object)("Error while SYSTEM_DELAY " + this), (Throwable)e);
            }
            ProcessManager processManager = this.createProcessManagerInstance();
            List<ProcessInfo> listBefore = processManager.getAllThreads();
            this.manager = this.createMSOfficeManagerInstance(this.application);
            try {
                Thread.sleep(DcomConstants.DCOM_SYSTEM_DELAY);
            }
            catch (InterruptedException e) {
                logger.error((Object)("Error while SYSTEM_DELAY " + this), (Throwable)e);
            }
            List<ProcessInfo> listAfter = processManager.getAllThreads();
            listAfter.removeAll(listBefore);
            logger.debug((Object)("count new Threads = " + listAfter.size()));
            for (ProcessInfo threadInfo : listAfter) {
                logger.debug((Object)("New thread : " + threadInfo.toString()));
                if (!threadInfo.getName().equalsIgnoreCase(this.application)) continue;
                if (this.PID == 0) {
                    this.PID = threadInfo.getPID();
                    continue;
                }
                logger.error((Object)("[" + this.id + "]. Found more than 1 " + this.application));
                throw new MSOffice2007ConverterException("Found more than 1 " + this.application);
            }
            if (this.PID == 0) {
                throw new MSOffice2007ConverterException("Not found new " + this.application);
            }
            logger.debug((Object)("[" + this.id + "]. PID=" + this.PID));
            logger.info((Object)("[" + this.id + "]. PID=" + this.PID + " started. "));
        }
        catch (ProcessManagerException e) {
            throw new MSOffice2007ConverterException((Throwable)((Object)e));
        }
        this.workerState.getAndSet(1);
    }

    protected abstract MSOfficeManager createMSOfficeManagerInstance(String var1) throws MSOffice2007ConverterException;

    protected abstract ProcessManager createProcessManagerInstance() throws MSOffice2007ConverterException;

    protected void cleanAfterError() throws MSOffice2007ConverterException {
        if (this.workerState.get() != -1) {
            logger.warn((Object)("[" + this.id + "]. Before cleanAfterError, excepted state " + MSOffice2007Converter.getStateDescription(-1) + " but was " + MSOffice2007Converter.getStateDescription(this.workerState.get())));
            return;
        }
        try {
            if (this.PID != 0) {
                ProcessManager processManager = this.createProcessManagerInstance();
                processManager.killProcess(this.PID);
                processManager.close();
                this.PID = 0;
            } else {
                logger.error((Object)(this.id + ". Can not kill PID=0!"));
            }
            this.workerState.getAndSet(0);
        }
        catch (ProcessManagerException e) {
            throw new MSOffice2007ConverterException("Error while clean after error", (Throwable)((Object)e));
        }
    }

    protected void restart() throws MSOffice2007ConverterException {
        logger.debug((Object)("[" + this.id + "]. Restarting"));
        if (this.workerState.get() == -1) {
            this.cleanAfterError();
            this.init();
            this.startWorker();
            logger.debug((Object)("[" + this.id + "].Restarted"));
        } else {
            logger.warn((Object)("[" + this.id + "] is not in ERROR state."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean interruptTaskIfRunning(String id) {
        Object object = this.currentLock;
        synchronized (object) {
            if (id != null && id.equals(this.currentId)) {
                this.currentFuture.cancel(true);
                return true;
            }
            return false;
        }
    }

    protected void startDaemonManager() {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        };
        this.helperExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        Runnable runnable = new Runnable(){

            public void run() {
                logger.debug((Object)("[" + MSOffice2007Converter.this.id + "]. !TIMER task."));
                if (!MSOffice2007Converter.this.executorService.isShutdown() && MSOffice2007Converter.this.workerState.get() == -1) {
                    try {
                        MSOffice2007Converter.this.restart();
                    }
                    catch (MSOffice2007ConverterException e) {
                        logger.error((Object)("Fatal exception during restarting converter " + MSOffice2007Converter.this), (Throwable)((Object)e));
                        throw new MSOffice2007RuntimeException("Fatal exception during restarting converter " + MSOffice2007Converter.this, (Throwable)((Object)e));
                    }
                }
            }
        };
        this.helperExecutor.scheduleWithFixedDelay(runnable, 0L, DcomConstants.CONVERTER_DELAY_HELPER, TimeUnit.MILLISECONDS);
    }

    public void start() {
        this.startWorker();
    }

    protected void startWorker() {
        if (this.workerState.get() != 1) {
            logger.warn((Object)("[" + this.id + "]. Before start, state should be STATE_INITED_NOT_STARTED."));
            throw new MSOffice2007RuntimeException("Before start, converter should be inited!");
        }
        this.threadMainCycle = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!MSOffice2007Converter.this.executorService.isShutdown() && MSOffice2007Converter.this.workerState.get() == 2) {
                    try {
                        final RequestInfo requestObject = MSOffice2007Converter.this.queueRequest.take();
                        logger.info((Object)("DCOM instance=" + MSOffice2007Converter.this.id + ", PID=" + MSOffice2007Converter.this.PID + ". Taken requestObject " + requestObject));
                        if (MSOffice2007Converter.this.resultListener.isRequestListened(requestObject.getId())) {
                            Throwable throwable;
                            Callable<ResultInfo> task = new Callable<ResultInfo>(){

                                @Override
                                public ResultInfo call() throws Exception {
                                    return MSOffice2007Converter.this.handleQueueObject(requestObject);
                                }
                            };
                            Object object = MSOffice2007Converter.this.currentLock;
                            synchronized (object) {
                                MSOffice2007Converter.this.currentFuture = MSOffice2007Converter.this.executorService.submit(task);
                                MSOffice2007Converter.this.currentId = requestObject.getId();
                            }
                            ResultInfo resultInfo = null;
                            try {
                                resultInfo = MSOffice2007Converter.this.currentFuture.get(DcomConstants.DCOM_TIMEOUT_WORK_APP, TimeUnit.MILLISECONDS);
                                logger.debug((Object)("[" + MSOffice2007Converter.this.id + "]. get result id=" + resultInfo.getId()));
                                continue;
                            }
                            catch (CancellationException e) {
                                logger.info((Object)("Task id=" + MSOffice2007Converter.this.currentId + " has been cancelled" + ". DCOM instance=" + MSOffice2007Converter.this.id + ", PID=" + MSOffice2007Converter.this.PID + ". "));
                                MSOffice2007Converter.this.workerState.getAndSet(-2);
                                continue;
                            }
                            catch (TimeoutException e) {
                                logger.error((Object)("DCOM server timeout exception occured. DCOM instance=" + MSOffice2007Converter.this.id + ", PID=" + MSOffice2007Converter.this.PID + ". "), (Throwable)e);
                                resultInfo = new ResultInfoImpl();
                                resultInfo.setId(requestObject.getId());
                                for (throwable = e; throwable != null && throwable.getCause() != null; throwable = throwable.getCause()) {
                                }
                                if (throwable != null && throwable.getMessage() != null) {
                                    resultInfo.setErrorMessage(throwable.getMessage());
                                } else {
                                    resultInfo.setErrorMessage("DCOM server timeout occurred. DCOM instance=" + MSOffice2007Converter.this.id + ", PID=" + MSOffice2007Converter.this.PID + " does not respond within specified time");
                                }
                                MSOffice2007Converter.this.currentFuture.cancel(true);
                                MSOffice2007Converter.this.workerState.getAndSet(-2);
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)("Exception while calculation of result. DCOM instance=" + MSOffice2007Converter.this.id + ", PID=" + MSOffice2007Converter.this.PID + ". "), (Throwable)e);
                                resultInfo = new ResultInfoImpl();
                                resultInfo.setId(requestObject.getId());
                                throwable = e;
                                while (throwable.getCause() != null) {
                                    throwable = throwable.getCause();
                                }
                                resultInfo.setErrorMessage(throwable.getMessage());
                                MSOffice2007Converter.this.currentFuture.cancel(true);
                                continue;
                            }
                            finally {
                                if (resultInfo != null) {
                                    MSOffice2007Converter.this.resultListener.addResultToQueue(resultInfo);
                                }
                                Object e = MSOffice2007Converter.this.currentLock;
                                synchronized (e) {
                                    MSOffice2007Converter.this.currentId = null;
                                    MSOffice2007Converter.this.currentFuture = null;
                                    continue;
                                }
                            }
                        }
                        logger.debug((Object)("[" + MSOffice2007Converter.this.id + "]. Processing of request id=" + requestObject.getId() + " is no longer needed. Request is ignored."));
                    }
                    catch (RejectedExecutionException e) {
                        if (MSOffice2007Converter.this.executorService.isShutdown()) continue;
                        logger.error((Object)"task submission rejected", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)("[" + MSOffice2007Converter.this.id + "]. Main cycle (taking object from queue) is interrupted."));
                    }
                }
                logger.debug((Object)("[" + MSOffice2007Converter.this.id + "]. Current state before changing =" + MSOffice2007Converter.this.workerState.get()));
                MSOffice2007Converter.this.workerState.compareAndSet(2, 1);
                MSOffice2007Converter.this.workerState.compareAndSet(-2, -1);
                logger.debug((Object)("[" + MSOffice2007Converter.this.id + "]. State after working thread dead=" + MSOffice2007Converter.this.workerState.get()));
            }
        });
        this.workerState.compareAndSet(1, 2);
        this.threadMainCycle.start();
    }

    public void stopSignal() {
        this.workerState.getAndSet(1);
        this.helperExecutor.shutdown();
        this.executorService.shutdown();
    }

    public void stop() throws MSOffice2007ConverterException {
        this.stopSignal();
        try {
            this.helperExecutor.awaitTermination(DcomConstants.CONVERTER_HELPER_WAIT_AFTER_SHUTDOWN, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error while awaiting termonation helperExecutor", (Throwable)e);
        }
        boolean interruptedTask = this.interruptTaskIfRunning(this.currentId);
        try {
            this.executorService.awaitTermination(DcomConstants.CONVERTER_WAIT_AFTER_SHUTDOWN, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error while awaiting termonation executorService", (Throwable)e);
        }
        if (interruptedTask) {
            this.workerState.getAndSet(-1);
            this.cleanAfterError();
        }
        if (this.threadMainCycle != null) {
            this.threadMainCycle.interrupt();
        } else {
            logger.warn((Object)("[" + this.id + "] threadMainCycle is null."));
        }
        logger.info((Object)("[" + this.id + "] stopped."));
    }

    public void releaseResources() throws MSOffice2007ConverterException {
        logger.debug((Object)("[" + this.id + "] release resources."));
        try {
            if (this.workerState.get() == 1) {
                if (this.manager != null) {
                    this.manager.close();
                } else {
                    logger.warn((Object)("[" + this.id + "] office manager is null."));
                }
                logger.info((Object)("[" + this.id + "] office manager closed."));
                this.workerState.getAndSet(0);
            } else {
                logger.warn((Object)("[" + this.id + "] expected " + MSOffice2007Converter.getStateDescription(1) + " but was " + MSOffice2007Converter.getStateDescription(this.workerState.get())));
            }
        }
        catch (MSOfficeManagerException e) {
            throw new MSOffice2007ConverterException((Throwable)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultInfo handleQueueObject(RequestInfo requestInfo) throws MSOffice2007ConverterException {
        ArrayList<String> listFilesToDeleteOnStorage;
        ResultInfoImpl resultInfo;
        Storage share;
        ByteArrayOutputStream out;
        block33: {
            BufferedInputStream rfis = null;
            out = null;
            String remoteSourceFileName = null;
            String remoteResultFileName = null;
            logger.info((Object)("Processing requestObject " + requestInfo));
            share = null;
            resultInfo = null;
            listFilesToDeleteOnStorage = new ArrayList<String>();
            try {
                long contentType = requestInfo.getContentType();
                long outMimeType = requestInfo.getOutMimeType();
                long convertionOptions = requestInfo.getConvertionOptions();
                boolean zipArchive = (contentType & 0x10000L) != 0L;
                String inExtension = MSOffice2007Shared.getExtensionByContentType((long)contentType);
                String outExtension = MSOffice2007Shared.getExtensionByOutMimeType((long)outMimeType);
                String password = requestInfo.getPassword();
                if (password == null || password.length() < 1) {
                    password = "some_password";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(System.currentTimeMillis()).append('_').append(new Double(Math.random()).hashCode());
                String filenamePrefix = sb.toString();
                share = this.getShareInstance();
                String localStoragePath = share.getLocalStoragePath();
                InputStream is = requestInfo.getSource();
                if (is == null) {
                    throw new MSOffice2007ConverterException("Input stream of source document can not be null!");
                }
                if (!zipArchive) {
                    remoteSourceFileName = filenamePrefix + "." + inExtension;
                    listFilesToDeleteOnStorage.add(remoteSourceFileName);
                    share.sendDataToFile(is, remoteSourceFileName);
                } else {
                    File tempZipFile = File.createTempFile(filenamePrefix, ".zip");
                    StreamUtil.writeToFile((InputStream)is, (File)tempZipFile, (boolean)false);
                    logger.debug((Object)("Temp file " + tempZipFile.getAbsolutePath() + " created."));
                    File destinationDir = new File(tempZipFile.getParentFile(), tempZipFile.getName() + "_unpacked");
                    destinationDir.mkdirs();
                    try {
                        ZipUtil.unpackZipArchive((File)tempZipFile, (File)destinationDir);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while unpacking source file zip-archive", (Throwable)e);
                        throw new MSOffice2007ConverterException("Error while unpacking source file zip-archive", e);
                    }
                    String directoryStorageName = destinationDir.getName() + "_" + System.currentTimeMillis() + "/";
                    share.sendFile(destinationDir, directoryStorageName);
                    listFilesToDeleteOnStorage.add(directoryStorageName);
                    boolean deleted = FileUtil.deleteFile((File)destinationDir, (long)0L);
                    if (!deleted) {
                        throw new MSOffice2007ConverterException("Temp folder " + destinationDir.getAbsolutePath() + " not deleted!");
                    }
                    deleted = FileUtil.deleteFile((File)tempZipFile, (long)0L);
                    if (!deleted) {
                        throw new MSOffice2007ConverterException("Temp zip-file " + tempZipFile.getAbsolutePath() + " not deleted!");
                    }
                    logger.debug((Object)("Temp files deleted of zip-archive deleted: " + tempZipFile.getAbsolutePath() + ", " + destinationDir.getAbsolutePath()));
                    StorageFile directory = share.getStorageFile(directoryStorageName);
                    logger.debug((Object)("Analise of " + directory.getCanonicalPath() + "..."));
                    String[] filesInStorageDirectory = directory.listStorageFileNames();
                    if (filesInStorageDirectory == null) throw new MSOffice2007ConverterException("Zip archive " + tempZipFile.getAbsolutePath() + " does not contain any file. It is used standart java-tool for unpacking.");
                    if (filesInStorageDirectory.length == 0) {
                        throw new MSOffice2007ConverterException("Zip archive " + tempZipFile.getAbsolutePath() + " does not contain any file. It is used standart java-tool for unpacking.");
                    }
                    for (String storageFileName : filesInStorageDirectory) {
                        String fileName2convert = directoryStorageName + storageFileName;
                        StorageFile file2convert = share.getStorageFile(fileName2convert);
                        if (file2convert.isDirectory()) continue;
                        if (remoteSourceFileName != null) throw new MSOffice2007ConverterException("Found more than 1 file in zip archive " + tempZipFile.getAbsolutePath());
                        remoteSourceFileName = fileName2convert;
                    }
                }
                remoteResultFileName = remoteSourceFileName + "." + outExtension;
                listFilesToDeleteOnStorage.add(remoteResultFileName);
                logger.debug((Object)("[" + this.id + "]. File to convert : " + remoteSourceFileName + " is sent."));
                this.manager.openFile(localStoragePath, remoteSourceFileName, password);
                double horizontalPrintQuality = requestInfo.getHorizontalPrintQuality();
                double verticalPrintQuality = requestInfo.getVerticalPrintQuality();
                if (horizontalPrintQuality > 1.0E-10 && verticalPrintQuality > 1.0E-10 && this.manager.supportPrintQuality()) {
                    this.manager.setHorizontalPrintQuality(horizontalPrintQuality);
                    logger.debug((Object)("[" + this.id + "]. horisontalPrintQuality is set to " + horizontalPrintQuality));
                    this.manager.setVerticalPrintQuality(verticalPrintQuality);
                    logger.debug((Object)("[" + this.id + "]. verticalPrintQuality is set to " + verticalPrintQuality));
                }
                this.manager.saveAs(outMimeType, convertionOptions, localStoragePath, remoteResultFileName);
                this.manager.closeOpenedFile();
                rfis = share.retrieveFile(remoteResultFileName, DcomConstants.DCOM_TIMEOUT_PRINT_FILE);
                out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int i = 0;
                while ((i = rfis.read(buffer)) > 0) {
                    out.write(buffer, 0, i);
                }
                out.flush();
                byte[] dataBuffer = out.toByteArray();
                resultInfo = new ResultInfoImpl();
                resultInfo.setId(requestInfo.getId());
                resultInfo.setData(dataBuffer);
                if (rfis == null) break block33;
            }
            catch (StorageException e) {
                try {
                    throw new MSOffice2007ConverterException("Error while conversion", (Throwable)((Object)e));
                    catch (MSOfficeManagerException e2) {
                        int errorType = this.getTypeOfException((Exception)((Object)e2));
                        if (errorType != -2147352567) {
                            logger.error((Object)("[" + this.id + "]. Exception type=" + Integer.toHexString(errorType) + " occured. " + this), (Throwable)((Object)e2));
                            this.workerState.set(-2);
                            throw new MSOffice2007ConverterException("Error while conversion", (Throwable)((Object)e2));
                        }
                        try {
                            this.manager.closeOpenedFile();
                            throw new MSOffice2007ConverterException("Error while conversion", (Throwable)((Object)e2));
                        }
                        catch (MSOfficeManagerException e1) {
                            logger.error((Object)("[" + this.id + "]. Error while trying closeOpenedFile. " + this), (Throwable)((Object)e1));
                            this.workerState.set(-2);
                            logger.error((Object)("[" + this.id + "]. State is set to " + MSOffice2007Converter.getStateDescription(this.workerState.get()) + this), (Throwable)((Object)e1));
                            throw new MSOffice2007ConverterException("Error while conversion", (Throwable)((Object)e2));
                        }
                    }
                    catch (MSOffice2007UnsupportedFormatException e3) {
                        throw new MSOffice2007ConverterException("Error while conversion", e3);
                    }
                    catch (IOException e4) {
                        throw new MSOffice2007ConverterException("Error while conversion", e4);
                    }
                }
                catch (Throwable throwable) {
                    if (rfis != null) {
                        try {
                            rfis.close();
                        }
                        catch (IOException e5) {
                            logger.error((Object)e5.getMessage(), (Throwable)e5);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e6) {
                            logger.error((Object)e6.getMessage(), (Throwable)e6);
                        }
                    }
                    if (listFilesToDeleteOnStorage.isEmpty()) throw throwable;
                    new MSOffice2007ConverterGC(share, listFilesToDeleteOnStorage, DcomConstants.STORAGE_TIMEOUT_DELETE_FILE);
                    throw throwable;
                }
            }
            try {
                rfis.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (listFilesToDeleteOnStorage.isEmpty()) return resultInfo;
        new MSOffice2007ConverterGC(share, listFilesToDeleteOnStorage, DcomConstants.STORAGE_TIMEOUT_DELETE_FILE);
        return resultInfo;
    }

    protected abstract Storage getShareInstance() throws MSOffice2007ConverterException;

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "MSOffice2007Converter ( " + super.toString() + "    " + "application = " + this.application + "    " + "queueRequest = " + this.queueRequest + "    " + "resultListener = " + this.resultListener + "    " + "urlStorage = " + this.urlStorage + "    " + "workerState = " + this.workerState + "    " + "executorService = " + this.executorService + "    " + "id = " + this.id + "    " + "manager = " + this.manager + "    " + "PID = " + this.PID + "    " + "thread = " + this.threadMainCycle + "    " + "helperExecutor = " + this.helperExecutor + "    " + "currentLock = " + this.currentLock + "    " + "currentFuture = " + this.currentFuture + "    " + "currentId = " + this.currentId + "    " + " )";
        return retValue;
    }

    public static String getStateDescription(int state) {
        String answer = null;
        switch (state) {
            case 0: {
                answer = "STATE_NOT_INITED";
                break;
            }
            case 1: {
                answer = "STATE_INITED_NOT_STARTED";
                break;
            }
            case 2: {
                answer = "STATE_STARTED";
                break;
            }
            case -1: {
                answer = "STATE_ERROR";
                break;
            }
            case -2: {
                answer = "STATE_ERROR_NOT_STOPPED";
                break;
            }
            default: {
                answer = "STATE_UNKNOWN";
            }
        }
        return answer;
    }

    protected int getTypeOfException(Exception e) {
        Throwable throwable = e;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String message = throwable.getMessage();
        if (message != null && message.indexOf("[0x8001FFFF]") != -1) {
            return -2147352577;
        }
        if (message != null && message.indexOf("[0x80020009]") != -1) {
            return -2147352567;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MSOffice2007ConverterGC
    extends Thread {
        public static Logger logger = Logger.getLogger(MSOffice2007ConverterGC.class);
        private Storage share;
        private List<String> filesToDelete;
        private long timeoutMillis;

        public MSOffice2007ConverterGC(Storage storage, List<String> filesToDelete, long timeoutMillis) {
            this.share = storage;
            this.filesToDelete = filesToDelete;
            this.timeoutMillis = timeoutMillis;
            this.start();
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            for (String fileToDelete : this.filesToDelete) {
                sb.append(fileToDelete).append(":");
            }
            logger.debug((Object)("Start GC " + sb.toString()));
            for (String fileToDelete : this.filesToDelete) {
                try {
                    if (this.share.fileExists(fileToDelete)) {
                        if (!this.share.deleteFile(fileToDelete, this.timeoutMillis)) {
                            logger.error((Object)(fileToDelete + " not deleted in " + this.timeoutMillis + " ms."));
                            continue;
                        }
                        logger.debug((Object)(fileToDelete + " deleted."));
                        continue;
                    }
                    logger.debug((Object)(fileToDelete + " not exists."));
                }
                catch (StorageException e) {
                    logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                }
            }
            this.share.close();
        }
    }
}

