/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import org.jinterop.dcom.common.JISystem;

final class JIObjectId
implements Serializable {
    private static final long serialVersionUID = -4335536047242439700L;
    private final byte[] oid;
    private int refcountofIPID = 0;
    private long lastPingTime = System.currentTimeMillis();
    final boolean dontping;

    int getIPIDRefCount() {
        return this.refcountofIPID;
    }

    boolean hasExpired() {
        return System.currentTimeMillis() - this.lastPingTime > 480000L;
    }

    void updateLastPingTime() {
        this.lastPingTime = System.currentTimeMillis();
    }

    void setIPIDRefCountTo0() {
        this.refcountofIPID = 0;
    }

    void decrementIPIDRefCountBy1() {
        --this.refcountofIPID;
    }

    void incrementIPIDRefCountBy1() {
        ++this.refcountofIPID;
    }

    JIObjectId(byte[] oid, boolean dontping) {
        this.oid = oid;
        this.dontping = dontping;
        if (dontping && JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("DONT PING is true for OID: " + this.toString());
        }
    }

    byte[] getOID() {
        return this.oid;
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.oid.length) {
            result = 31 * result + this.oid[i];
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JIObjectId)) {
            return false;
        }
        return Arrays.equals(this.oid, ((JIObjectId)obj).getOID());
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])this.oid, (int)0, (int)this.oid.length);
        return "{ IPID ref count is " + this.refcountofIPID + " } and OID in bytes[] " + byteArrayOutputStream.toString() + " , hasExpired " + this.hasExpired() + " } ";
    }
}

