module.exports = {
    "desc": 	"qpdf oxsnps plugin",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
		"level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_OXSNPS_QPDF"] ||
				process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
				"WARN"
	},
    "routes": [
		{
			"path":		"/services/qpdf/version",
			"method":	"get",
			"service":	"version"
		},
		{	
			"path":		"/services/qpdf/conf",
			"method":	"get",
			"service":	"conf"
		},
		{
			"path":		"/services/qpdf/conf",
			"method":	"post",
			"service":	"conf"
		},
		{
			"path":		"/services/qpdf/process",
			"method":	"post",
			"service":	"process"
		},
		{
			"path":		"/services/qpdf/process",
			"method":	"get",
			"service":	"process"
		}
    ],
    "middlewares":[
        {
            "name": "body-parser",
            "handler": "json",
            "routes":[
                {
                    "path": ["/services/qpdf/*"],
                    "parms": {"limit": "1mb"}  
                }
            ]
        }    
    ],
    // V3.0.2
    defaultArgs: process.env.OXSNPS_SERVER_PREFIX + "DEFAULT_QPDF_ARGS"
    // V3.0.2
}
