/*
 * Decompiled with CFR 0.152.
 */
package de.maas.jbi.helper;

import de.maas.jbi.helper.marshallers.FileParser;
import de.maas.jbi.helper.marshallers.FileParserException;
import de.maas.saas.config.FileResolverConfig;
import de.maas.saas.config.InputLocation;
import de.maas.saas.data.Order;
import de.maas.saas.logger.Log;
import de.maas.saas.logger.SaasLogFactory;
import de.maas.saas.utils.NMRXMLSerializer;
import de.maas.saas.utils.PollerUtil;
import de.maas.saas.utils.SimpleHashMap;
import de.maas.saas.utils.XMLSerializerException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.servicemix.components.file.FilePoller;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;

public class FilePollerComponent
extends FilePoller {
    private static final String REPLACEMENT_PATTERN = "@FILENAME@";
    private static final String REPLACEMENT_PATTERN_OID = "@ORDERID@";
    private String fileNamePattern = null;
    private List<File> fileList = new ArrayList<File>();
    private List<File> searchFileList = new ArrayList<File>();
    private List<FileParser> parsersList = new ArrayList<FileParser>();
    private Map<File, String> mandantMappings = new HashMap<File, String>();
    private boolean changingName = false;
    private boolean isParsing = false;
    private String fileUsename = "parsed_@FILENAME@.backup";
    private String statusFilename = "order_status.status";
    private String workingDirectory = null;
    private FileSystemManager fsManager = null;
    private String proccessedMandant = null;
    private FileFilter ff;

    protected final Log getLog() {
        try {
            return (Log)this.logger;
        }
        catch (ClassCastException cce) {
            this.logger = SaasLogFactory.getLog(((Object)((Object)this)).getClass());
            return (Log)this.logger;
        }
    }

    public void init() throws JBIException {
        this.isParsing = true;
        super.init();
        try {
            this.fsManager = VFS.getManager();
        }
        catch (FileSystemException e) {
            throw new JBIException((Throwable)e);
        }
        for (FileParser parser : this.parsersList) {
            parser.setLog(this.getLog());
            parser.setWorkingDirectory(this.workingDirectory);
            parser.setFsManager(this.fsManager);
        }
        this.getLog().info((Object)"\tService initialized");
        this.ff = new MyFileFilter();
        if (this.isAutoCreateDirectory()) {
            for (File file : this.searchFileList) {
                if (file.exists()) continue;
                file.mkdirs();
            }
        }
        this.isParsing = false;
    }

    public final void setWorkingDirectory(String workingDirectoy) {
        this.workingDirectory = workingDirectoy;
    }

    public void setProcessOnlyForMandant(String mandant) {
        this.proccessedMandant = mandant;
    }

    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final String getWorkingDirectory(String mandant) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public final String getWorkingDirectory(String mandant, String orderId) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (orderId != null && orderId.length() > 0) {
            result.append(orderId);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public void setParser(FileParser parser) {
        if (!this.parsersList.contains(parser)) {
            this.parsersList.add(parser);
        }
    }

    public void setFileUsename(String fileUsename) {
        this.fileUsename = fileUsename;
    }

    public void setStatusFilename(String statusFilename) {
        this.statusFilename = statusFilename;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void setFileResolver(FileResolverConfig resolverConfig) {
        List<InputLocation> urlList = resolverConfig.getInputList();
        for (InputLocation il : urlList) {
            String result = il.getURL();
            int firstIndexOfColon = -1;
            firstIndexOfColon = result.indexOf(":");
            if (firstIndexOfColon >= 0 && result.length() > firstIndexOfColon + 1) {
                result = result.substring(firstIndexOfColon + 1);
            }
            if ((firstIndexOfColon = (result = result.replaceAll("[/]{2,}", "/")).indexOf(":")) >= 0 && result.length() > firstIndexOfColon + 1 && result.indexOf("/") == 0) {
                result = result.substring(1);
            }
            File f = new File(result);
            this.searchFileList.add(f);
            this.setFile(f);
            this.mandantMappings.put(f, il.getMandant());
        }
    }

    public void poll() throws Exception {
        if (!this.isParsing) {
            this.isParsing = true;
            this.checkFileList();
            if (this.searchFileList != null && this.searchFileList.size() > 0) {
                if (this.proccessedMandant != null) {
                    Set<File> keys = this.mandantMappings.keySet();
                    for (File file : keys) {
                        String mandant = this.mandantMappings.get(file);
                        if (!mandant.equals(this.proccessedMandant)) continue;
                        this.pollFileOrDirectoryMandant(file, true, mandant);
                    }
                } else {
                    for (File file : this.searchFileList) {
                        this.pollFileOrDirectoryMandant(file, true, this.mandantMappings.get(file));
                    }
                }
            } else {
                super.poll();
            }
            this.isParsing = false;
        }
    }

    protected void pollFileOrDirectoryMandant(File fileOrDirectory, boolean processDir, String mandant) {
        try {
            if (!fileOrDirectory.isDirectory()) {
                if (fileOrDirectory.getName().matches(this.fileNamePattern)) {
                    this.fileList.add(fileOrDirectory);
                    this.getLog().debug((Object)("Parse file " + fileOrDirectory.getName()));
                    this.processFile(fileOrDirectory, null, mandant);
                }
            } else if (processDir) {
                File[] files;
                for (File fileTmp : files = fileOrDirectory.listFiles(this.ff)) {
                    this.pollFileOrDirectoryMandant(fileOrDirectory, fileTmp.getName(), this.isRecursive(), mandant);
                }
            }
        }
        catch (Exception we) {
            this.getLog().error((Object)we.getMessage(), (Throwable)we);
        }
    }

    protected void pollFileOrDirectoryMandant(File parent, String subDir, boolean processDir, String mandant) {
        try {
            File fileOrDirectory = new File(parent, subDir);
            if (!fileOrDirectory.isDirectory()) {
                if (fileOrDirectory.getName().matches(this.fileNamePattern)) {
                    this.fileList.add(fileOrDirectory);
                    this.getLog().debug((Object)("Parse file " + fileOrDirectory.getName()));
                    this.getLog().debug((Object)("subdir name: " + PollerUtil.getParentDir(subDir)));
                    this.processFile(fileOrDirectory, PollerUtil.getParentDir(subDir), mandant);
                }
            } else if (processDir) {
                File[] files;
                for (File fileTmp : files = fileOrDirectory.listFiles(this.ff)) {
                    this.pollFileOrDirectoryMandant(parent, subDir + "/" + fileTmp.getName(), this.isRecursive(), mandant);
                }
            }
        }
        catch (Exception we) {
            this.getLog().error((Object)we.getMessage(), (Throwable)we);
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized Object parseIndexFile(File file, String subDir, String mandant) throws FileParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 28[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createStatusFile(File file, Order order, String orderStatusPath) {
        try {
            File statusFile = new File(file.getParentFile(), this.statusFilename);
            if (!statusFile.exists()) {
                statusFile.createNewFile();
            }
            if ((orderStatusPath = statusFile.getCanonicalPath()) != null) {
                if (order.getProperties() == null) {
                    order.setProperties(new SimpleHashMap());
                }
                order.getProperties().put((Object)"saas.object.status.file.name.path", (Object)orderStatusPath);
            }
        }
        catch (IOException e1) {
            this.getLog().warn((Object)("Could not change crete status file: " + this.statusFilename));
        }
    }

    protected void sendForward(Object object) throws MessagingException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        DeliveryChannel channel = this.getDeliveryChannel();
        int messageSendCount = 10;
        int sleepTime = 20000;
        int count = 0;
        while (!this.isDestinationEndpointAvailable()) {
            try {
                this.getLog().warn((Object)"Service not present - retry (wait for its initalization)");
                Thread.sleep(sleepTime);
                this.getLog().debug((Object)("Check endpoints for:" + (++count + 1) + " time/total:" + messageSendCount));
            }
            catch (InterruptedException e1) {
                throw new MessagingException(e1.getMessage(), (Throwable)e1);
            }
        }
        InOnly inexchange = factory.createInOnlyExchange();
        try {
            NormalizedMessage nmr = inexchange.createMessage();
            NMRXMLSerializer.writeObject((Object)object, (NormalizedMessage)nmr);
            inexchange.setInMessage(nmr);
            channel.send((MessageExchange)inexchange);
            this.getLog().debug((Object)"Send message to destination service.");
        }
        catch (XMLSerializerException e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isDestinationEndpointAvailable() {
        ComponentContext cc = this.getContext();
        if (cc instanceof ComponentContextImpl) {
            ActivationSpec as = ((ComponentContextImpl)cc).getActivationSpec();
            ServiceEndpoint[] ends = cc.getEndpointsForService(as.getDestinationService());
            if (ends == null) {
                return false;
            }
            if (ends.length <= 0) {
                return false;
            }
        }
        return true;
    }

    private void checkFileList() {
        if (this.changingName) {
            return;
        }
        File fileOrDirectory = this.getFile();
        if (fileOrDirectory != null && !fileOrDirectory.isDirectory()) {
            return;
        }
        Iterator<File> it = this.fileList.iterator();
        while (it.hasNext()) {
            File fileTmp = it.next();
            if (fileTmp.exists()) continue;
            it.remove();
        }
    }

    private synchronized boolean changeFileName(File sourceFile, File targetFile) {
        if (sourceFile.exists()) {
            return sourceFile.renameTo(targetFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String changeFileName(String sourceFileName, String prefix, String useName) {
        try {
            for (File f : this.fileList) {
                if (!f.getAbsolutePath().contains(sourceFileName)) continue;
                Class<FilePollerComponent> clazz = FilePollerComponent.class;
                synchronized (FilePollerComponent.class) {
                    this.changingName = true;
                    String newName = f.getParent() + File.separatorChar + prefix + (useName != null ? useName : f.getName());
                    File tmp = new File(newName);
                    if (!f.renameTo(tmp)) {
                        this.getLog().debug((Object)"File has not been renamed.");
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        return null;
                    }
                    this.getLog().debug((Object)("File succesfully renamed to: " + tmp.getName()));
                    this.changingName = false;
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return tmp.getAbsolutePath();
                }
            }
            for (File ftmp : this.searchFileList) {
                File f;
                if (!ftmp.isDirectory() || !(f = new File(ftmp.getAbsolutePath() + File.separatorChar + sourceFileName)).exists()) continue;
                Class<FilePollerComponent> clazz = FilePollerComponent.class;
                synchronized (FilePollerComponent.class) {
                    this.changingName = true;
                    String newName = f.getParent() + File.separatorChar + prefix + (useName != null ? useName : f.getName());
                    if (!f.renameTo(new File(newName))) {
                        this.getLog().debug((Object)"File has not renamed.");
                        // ** MonitorExit[var7_10] (shouldn't be in output)
                        return null;
                    }
                    this.getLog().debug((Object)("File succesfully renamed to: " + f.getName()));
                    this.changingName = false;
                    // ** MonitorExit[var7_10] (shouldn't be in output)
                    return newName;
                }
            }
            this.getLog().warn((Object)("File not found in input directory: " + sourceFileName));
            return null;
        }
        catch (Exception e) {
            this.getLog().warn((Object)("Error appears while changing the name: " + e.getMessage()));
            return null;
        }
    }

    private void processFile(File aFile, String subDir, String mandant) {
        try {
            Object obj = this.parseIndexFile(aFile, subDir, mandant);
            if (obj == null) {
                return;
            }
            this.sendForward(obj);
        }
        catch (Throwable e) {
            this.getLog().error((Object)e.getMessage(), e);
        }
    }

    class MyFileFilter
    implements FileFilter {
        MyFileFilter() {
        }

        public boolean accept(File pathname) {
            FileFilter filter = FilePollerComponent.this.getFilter();
            List fileList = FilePollerComponent.this.fileList;
            if (filter == null) {
                return !fileList.contains(pathname);
            }
            if (filter.accept(pathname)) {
                return !fileList.contains(pathname);
            }
            return false;
        }
    }
}

