/*
 * Decompiled with CFR 0.152.
 */
package de.maas.jbi.helper;

import de.maas.saas.data.Order;
import de.maas.saas.logger.Log;
import de.maas.saas.logger.SaasLogFactory;
import de.maas.saas.utils.ActionUtils;
import de.maas.saas.utils.NMRXMLSerializer;
import de.maas.saas.utils.XMLSerializerException;
import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceComponent
extends ComponentSupport
implements MessageExchangeListener {
    public ServiceComponent() {
    }

    public ServiceComponent(QName name, String nam) {
        super(name, nam);
    }

    public final void onMessageExchange(MessageExchange arg0) throws MessagingException {
        this.messageExchange(arg0);
    }

    protected abstract void messageExchange(MessageExchange var1) throws MessagingException;

    protected final NormalizedMessage getInMessage(MessageExchange exchange) {
        return exchange.getMessage("in");
    }

    protected final NormalizedMessage getOutMessage(MessageExchange exchange) {
        return exchange.getMessage("out");
    }

    protected final Object getInProperty(MessageExchange me, String name) {
        return me.getMessage("in").getProperty(name);
    }

    protected final Object getOutProperty(MessageExchange me, String name) {
        return me.getMessage("out").getProperty(name);
    }

    protected final void sendMessage(Object object) throws IOException, XMLSerializerException, JBIException {
        this.sendMessage(object, null);
    }

    protected final void sendMessage(Object object, Map<String, DataHandler> attachments) throws IOException, XMLSerializerException, JBIException {
        MessageExchangeFactory messageFactory = this.getExchangeFactory();
        InOnly msg = messageFactory.createInOnlyExchange();
        QName destination = null;
        ComponentContext cc = this.getContext();
        if (object instanceof Order && cc instanceof ComponentContextImpl) {
            Order o = (Order)object;
            ActionUtils au = ActionUtils.findFirstAction((Order)o);
            if (au.getFirstAction() != null) {
                String actionName = au.getActionName();
                this.getLog().debug(o, null, null, null, "Sending to next action:" + actionName);
                ServiceEndpoint[] se = cc.getEndpointsForService(new QName("http://www.maas.de/h2w/oxseed", actionName));
                if (se.length > 0) {
                    destination = se[0].getServiceName();
                    msg.setEndpoint(se[0]);
                    this.getLog().debug(o, null, null, null, "Sending to next action, dest:" + destination);
                }
            } else {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info(o, null, null, null, "There are no more actions for that order, finishing");
                }
                return;
            }
        }
        NormalizedMessage inMsg = msg.createMessage();
        NMRXMLSerializer.writeObject((Object)object, (NormalizedMessage)inMsg);
        if (attachments != null) {
            for (String name : attachments.keySet()) {
                inMsg.addAttachment(name, attachments.get(name));
            }
        }
        msg.setInMessage(inMsg);
        int count = 0;
        int messageSendCount = 10;
        int sleepTime = 20000;
        if (destination != null) {
            while (!this.isDestinationEndpointAvailable(destination) && count < messageSendCount) {
                if (destination == null) {
                    this.getLog().warn((Object)"Destination service not present - retry (wait for its initalization)");
                } else {
                    this.getLog().warn((Object)("Service (" + destination.getNamespaceURI() + ":" + destination.getLocalPart() + ") not present - retry (wait for its initalization)"));
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {
                    throw new MessagingException(e1.getMessage(), (Throwable)e1);
                }
                this.logger.debug((Object)("Check endpoints for:" + (++count + 1) + " time/total:" + messageSendCount));
            }
        }
        this.send((MessageExchange)msg);
    }

    private boolean isDestinationEndpointAvailable(QName destination) {
        ComponentContext cc = this.getContext();
        if (cc instanceof ComponentContextImpl) {
            if (destination == null) {
                ActivationSpec as = ((ComponentContextImpl)cc).getActivationSpec();
                QName dest = as.getDestinationService();
            } else {
                QName dest = destination;
            }
            ServiceEndpoint[] ends = cc.getEndpointsForService(destination);
            if (ends == null) {
                return false;
            }
            if (ends.length <= 0) {
                return false;
            }
        }
        return true;
    }

    protected final Log getLog() {
        try {
            return (Log)this.logger;
        }
        catch (ClassCastException cce) {
            this.logger = SaasLogFactory.getLog(((Object)((Object)this)).getClass());
            return (Log)this.logger;
        }
    }

    protected void answer(InOut exchange, Object orderObject, Map<String, DataHandler> attachments) throws MessagingException, XMLSerializerException, IOException {
        NormalizedMessage outMsg = exchange.createMessage();
        NMRXMLSerializer.writeObject((Object)orderObject, (NormalizedMessage)outMsg);
        if (attachments != null) {
            for (String name : attachments.keySet()) {
                outMsg.addAttachment(name, attachments.get(name));
            }
        }
        super.answer((MessageExchange)exchange, outMsg);
    }
}

