/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.saver;

import de.maas.saas.config.OrderSaverConfig;
import de.maas.saas.db.SessionFactory;
import de.maas.saas.saver.DBOrderSaver;
import de.maas.saas.saver.EmailDBOrderSaver;
import de.maas.saas.saver.FileOrderSaver;
import de.maas.saas.saver.NoneOrderSaver;
import de.maas.saas.saver.OrderSaverException;
import de.maas.saas.saver.OrderSaverInterface;
import org.apache.commons.vfs.FileSystemManager;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class OrderSaverFactory
implements BeanNameAware,
InitializingBean {
    private OrderSaverConfig orderSaverConfiguration;
    private SessionFactory sessionFactory;

    public void afterPropertiesSet() throws Exception {
    }

    public void setBeanName(String arg0) {
    }

    public OrderSaverConfig getOrderSaverConfiguration() {
        return this.orderSaverConfiguration;
    }

    public void setOrderSaverConfiguration(OrderSaverConfig orderSaverConfiguration) {
        this.orderSaverConfiguration = orderSaverConfiguration;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public OrderSaverInterface getOrderSaverImpl(FileSystemManager fsm) throws OrderSaverException {
        String type = this.orderSaverConfiguration.getType();
        if (type.equalsIgnoreCase("db")) {
            try {
                DBOrderSaver db = new DBOrderSaver(this.sessionFactory);
                db.setConfig(this.orderSaverConfiguration);
                return db;
            }
            catch (Exception e) {
                throw new OrderSaverException("Can't create instance of DB order saver", e);
            }
        }
        if (type.equalsIgnoreCase("email")) {
            try {
                EmailDBOrderSaver eos = new EmailDBOrderSaver(this.sessionFactory);
                eos.setConfig(this.orderSaverConfiguration);
                return eos;
            }
            catch (Exception e) {
                throw new OrderSaverException("Can't create instance of DB order saver", e);
            }
        }
        if (type.equalsIgnoreCase("file")) {
            FileOrderSaver fos = new FileOrderSaver();
            fos.setUseGZip(false);
            fos.setConfig(this.orderSaverConfiguration);
            fos.setFsManager(fsm);
            return fos;
        }
        if (type.equalsIgnoreCase("file_gzipped")) {
            FileOrderSaver fos = new FileOrderSaver();
            fos.setUseGZip(true);
            fos.setConfig(this.orderSaverConfiguration);
            fos.setFsManager(fsm);
            return fos;
        }
        if (type.equalsIgnoreCase("none")) {
            return new NoneOrderSaver();
        }
        throw new OrderSaverException("Unknown order saver type:" + type);
    }
}

