/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.utils;

import de.maas.saas.data.Order;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SaasUtils {
    private static final SimpleDateFormat XML_SCHEMA_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat XML_SCHEMA_DATE_TIME_FORMAT_OLD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat LPD1_SCHEMA_DATE_TIME_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static final SimpleDateFormat LPD2_SCHEMA_DATE_TIME_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private static final int MAX_STATUS_LENGHT = 10;

    public static synchronized String convertToXMLSchemaDateTime(Date date) {
        String convertedDate = XML_SCHEMA_DATE_TIME_FORMAT_OLD.format(date);
        return convertedDate.substring(0, 22) + ":" + convertedDate.substring(22);
    }

    public static synchronized String convertToXMPSchemaDateTime(Date date) {
        String convertedDate = XML_SCHEMA_DATE_TIME_FORMAT.format(date);
        return convertedDate;
    }

    public static synchronized Date convertXMLSchemaDateTimeToDate(String date) throws ParseException {
        try {
            if (date.length() == 20) {
                return XML_SCHEMA_DATE_TIME_FORMAT.parse(date);
            }
            return XML_SCHEMA_DATE_TIME_FORMAT_OLD.parse(date.substring(0, 22) + date.substring(23));
        }
        catch (Exception e) {
            try {
                return XML_SCHEMA_DATE_TIME_FORMAT_OLD.parse(date);
            }
            catch (Exception ee) {
                try {
                    return LPD1_SCHEMA_DATE_TIME_FORMAT.parse(date);
                }
                catch (Exception e2) {
                    return LPD2_SCHEMA_DATE_TIME_FORMAT.parse(date);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean printStatus(Order order, String status, String statusDescription) {
        FileOutputStream fos = null;
        PrintStream out = null;
        File printFile = null;
        if (order.getProperties() == null) {
            return false;
        }
        String filePath = (String)order.getProperties().get((Object)"saas.object.status.file.name.path");
        if (filePath == null) {
            return false;
        }
        printFile = new File(filePath);
        if (!printFile.exists()) {
            return false;
        }
        try {
            fos = new FileOutputStream(printFile, true);
            out = new PrintStream(fos, true);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
            Date currentDate = new Date(System.currentTimeMillis());
            String currentDateStr = format.format(currentDate);
            if (statusDescription == null) {
                statusDescription = "";
            }
            StringBuffer buf = new StringBuffer().append(status);
            for (int i = buf.length(); i < 10; ++i) {
                buf.append(" ");
            }
            out.println(currentDateStr + " | " + buf + " | " + order.getId() + " | " + statusDescription);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ignored) {}
        }
    }
}

