/*
 * Decompiled with CFR 0.152.
 */
package de.maas.pdfengine;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.maas.pdfengine.InputObject;
import de.maas.pdfengine.PDFConverterWrapperException;
import de.maas.saas.pdf.PDFDocument;
import de.maas.saas.pdf.PDFOutputIntentsException;
import de.maas.saas.pdf.PDFXMP;
import de.maas.saas.pdf.PDFXMPException;
import de.maas.saas.pdf.box.PDFFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFConverterWrapper {
    private static Logger logger = Logger.getLogger(PDFConverterWrapper.class);
    private static boolean bLogDebugEnabledThe = logger.isDebugEnabled();
    private static String VERSION = "2.0.0.1";

    public synchronized void start() throws Exception {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String jvmName = runtimeBean.getName();
        logger.info((Object)("PDFConverterWrapper Started. JVM Process id:" + Long.valueOf(jvmName.split("@")[0])));
    }

    public synchronized void stop() throws Exception {
        logger.info((Object)"PDFConverterWrapper Stopped.");
    }

    public String getVersion() {
        Gson gson = new Gson();
        String sRetTmp = gson.toJson((Object)VERSION);
        return sRetTmp;
    }

    public String mergeAndSecure(String sInputPar) throws PDFConverterWrapperException {
        long timeBeginTmp;
        Gson gsonTmp = null;
        JsonParser jsonParserTmp = null;
        ArrayList<InputObject> arrInputObjectTmp = new ArrayList<InputObject>();
        byte[] byRetTmp = null;
        try {
            if (sInputPar == null) {
                throw new PDFConverterWrapperException("Input parameter passed to mergeAndSecure method is null");
            }
            if (sInputPar.length() <= 0) {
                throw new PDFConverterWrapperException("Input parameter passed to mergeAndSecure method is empty");
            }
            if (bLogDebugEnabledThe) {
                logger.debug((Object)("Started processing Merge PDF request. Input JSON String:" + sInputPar));
            } else {
                logger.info((Object)"Started processing Merge PDF request.");
            }
            timeBeginTmp = System.currentTimeMillis();
            jsonParserTmp = new JsonParser();
            JsonElement jsonElementTmp = jsonParserTmp.parse(sInputPar);
            if (jsonElementTmp == null) {
                throw new PDFConverterWrapperException("Input parameter passed to mergeAndSecure method is not JSON string");
            }
            if (!jsonElementTmp.isJsonObject()) {
                throw new PDFConverterWrapperException("Input parameter passed to mergeAndSecure method is not JSON object");
            }
            JsonObject jsonArgsTmp = jsonElementTmp.getAsJsonObject();
            if (jsonArgsTmp == null) {
                throw new PDFConverterWrapperException("Error on parsing JSON Input parameter passed to mergeAndSecure method");
            }
            InputObject inputObjTmp = null;
            JsonObject jsonObjTmp = null;
            gsonTmp = new Gson();
            String sTargetUserPwdTmp = null;
            String sTargetOwnerPwdTmp = null;
            String sPermFlagsTmp = null;
            String sApplicationTmp = null;
            String sProducerTmp = null;
            JsonArray jsonInputObjsArrTmp = jsonArgsTmp.getAsJsonArray("inputObject");
            if (jsonInputObjsArrTmp == null || jsonInputObjsArrTmp.size() <= 0) {
                throw new PDFConverterWrapperException("inputObject parameter is missing in JSON Input string passed to mergeAndSecure method");
            }
            for (int i = 0; i < jsonInputObjsArrTmp.size(); ++i) {
                jsonObjTmp = jsonInputObjsArrTmp.get(i).getAsJsonObject();
                if (jsonObjTmp == null || (inputObjTmp = (InputObject)gsonTmp.fromJson((JsonElement)jsonObjTmp, InputObject.class)) == null) continue;
                arrInputObjectTmp.add(inputObjTmp);
            }
            jsonElementTmp = jsonArgsTmp.get("targetUserPWD");
            if (jsonElementTmp != null) {
                sTargetUserPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("targetOwnerPWD")) != null) {
                sTargetOwnerPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("permissionFlags")) != null) {
                sPermFlagsTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("pdfProducer")) != null) {
                sProducerTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("pdfApplication")) != null) {
                sApplicationTmp = jsonElementTmp.getAsString();
            }
            byRetTmp = this.mergeAndSecure(arrInputObjectTmp, sTargetUserPwdTmp, sTargetOwnerPwdTmp, sPermFlagsTmp, sProducerTmp, sApplicationTmp);
        }
        catch (Exception ePar) {
            ByteArrayOutputStream osErrTmp = null;
            osErrTmp = new ByteArrayOutputStream();
            ePar.printStackTrace(new PrintStream(osErrTmp));
            logger.error((Object)("Exception occurred on merging PDF files." + (arrInputObjectTmp.size() <= 0 ? "" : "InputObject:[" + arrInputObjectTmp.toString() + "].") + ePar.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            throw new PDFConverterWrapperException("Input Exception occurred on merging PDF files." + (arrInputObjectTmp.size() <= 0 ? "" : "InputObject:[" + arrInputObjectTmp.toString() + "].") + " " + ePar.getMessage(), ePar);
        }
        String sRetTmp = gsonTmp.toJson((Object)byRetTmp);
        long timeEndTmp = System.currentTimeMillis();
        logger.info((Object)("Finished processing Merge PDF request. " + (arrInputObjectTmp.size() <= 0 ? "" : "InputObject:[" + arrInputObjectTmp.toString() + "], ") + " Merged PDF Length:" + (byRetTmp == null ? 0 : byRetTmp.length) + ", TimeTaken: " + (timeEndTmp - timeBeginTmp) / 1000L + " sec(s)."));
        return sRetTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte[] mergeAndSecure(ArrayList<InputObject> arrInputObjectPar, String sTargetUserPwdPar, String sTargetOwnerPwdPar, String sPermissionFlagsPar, String sPDFProducerPar, String sPDFApplicationPar) throws PDFConverterWrapperException, PDFXMPException, PDFOutputIntentsException, IOException, COSVisitorException {
        block41: {
            osErrTmp = null;
            byArrMergedPDFTmp = null;
            pdDocOutTmp = null;
            pdDocTmp = null;
            baosTmp = null;
            sFilenameTmp = null;
            fisTmp = null;
            bisTmp = null;
            sErrMsgTmp = "";
            sourceDocListTmp = new ArrayList<PDFDocument>();
            if (arrInputObjectPar == null) {
                throw new PDFConverterWrapperException("Input Object Array parameter passed to PDFConverterWrapper::mergeAndSecure() method is null");
            }
            if (arrInputObjectPar.size() <= 0) {
                throw new PDFConverterWrapperException("Input Object Array parameter passed to PDFConverterWrapper::mergeAndSecure() method is empty");
            }
            PDFConverterWrapper.logger.info((Object)("Merge PDF request parameters. InputObject:" + arrInputObjectPar.toString() + ", TargetUserPwd:" + sTargetUserPwdPar + ", TargetOwnerPwd:" + sTargetOwnerPwdPar + ", PDFProducer:" + sPDFProducerPar + ", PDFApplication:" + sPDFApplicationPar + ", PermissionFlags:" + sPermissionFlagsPar));
            pdDocOutTmp = PDFFactory.getInstance().newPDFACompliantDocument();
            if (pdDocOutTmp == null) {
                throw new PDFConverterWrapperException("Could not create new PDF document to write output for Merge PDF request");
            }
            this.setMetadata(pdDocOutTmp, sPDFProducerPar, sPDFApplicationPar);
            byArrDecryptedTmp = null;
            pageTmp = null;
            pageListTmp = null;
            fileTmp = null;
            for (InputObject ipObjTmp : arrInputObjectPar) {
                block38: {
                    block39: {
                        pdDocTmp = null;
                        fisTmp = null;
                        bisTmp = null;
                        sFilenameTmp = ipObjTmp.getFilename();
                        if (sFilenameTmp == null) break block39;
                        if (sFilenameTmp.length() > 0) ** break block40
                    }
                    var26_26 = null;
                    if (pdDocTmp == null) break block38;
                    sourceDocListTmp.add(pdDocTmp);
                }
                try {
                    if (fisTmp != null) {
                        sErrMsgTmp = "Exception occurred on closing File Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                        fisTmp.close();
                        fisTmp = null;
                    }
                    if (bisTmp == null) continue;
                    sErrMsgTmp = "Exception occurred on closing Buffered Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                    bisTmp.close();
                    bisTmp = null;
                }
                catch (IOException e) {
                    osErrTmp = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(osErrTmp));
                    PDFConverterWrapper.logger.error((Object)(sErrMsgTmp + "InputObject=:" + arrInputObjectPar.toString() + ". " + e.getMessage() + ", StackTrace:" + osErrTmp.toString()));
                }
                continue;
                {
                    fileTmp = new File(sFilenameTmp);
                    if (!(fileTmp.exists() && fileTmp.isFile() && fileTmp.canRead())) {
                        throw new PDFConverterWrapperException("Input file does not exist or it is not readable. Filename: " + sFilenameTmp);
                    }
                    if (fileTmp.length() < 0L) {
                        throw new PDFConverterWrapperException("Input file size is zero. Filename: " + sFilenameTmp);
                    }
                    if (PDFConverterWrapper.bLogDebugEnabledThe) {
                        PDFConverterWrapper.logger.debug((Object)("Adding pages of input file " + sFilenameTmp));
                    }
                    fisTmp = new FileInputStream(sFilenameTmp);
                    bisTmp = new BufferedInputStream(fisTmp);
                    pdDocTmp = PDFFactory.getInstance().loadPDFDocument((InputStream)bisTmp);
                    if (pdDocTmp == null) {
                        throw new PDFConverterWrapperException("Could not load PDF document. Filename: " + sFilenameTmp);
                    }
                    if (pdDocTmp.isEncrypted()) {
                        pdDocTmp.close();
                        bisTmp.close();
                        fisTmp.close();
                        fisTmp = new FileInputStream(sFilenameTmp);
                        bisTmp = new BufferedInputStream(fisTmp);
                        baosTmp = new ByteArrayOutputStream();
                        b = new byte[16384];
                        len = 0;
                        while ((len = bisTmp.read(b)) > 0) {
                            baosTmp.write(b, 0, len);
                            baosTmp.flush();
                        }
                        byArrDecryptedTmp = this.decrypt_pdfbox(sFilenameTmp, baosTmp.toByteArray(), ipObjTmp.getOwnerPwd(), ipObjTmp.getUserPwd());
                        pdDocTmp = PDFFactory.getInstance().loadPDFDocument((InputStream)new ByteArrayInputStream(byArrDecryptedTmp));
                        if (pdDocTmp == null) {
                            throw new PDFConverterWrapperException("Could not load decrypted PDF document. Filename: " + sFilenameTmp);
                        }
                    }
                    pageListTmp = pdDocTmp.getDocumentCatalog().getAllPages();
                    for (E page : pageListTmp) {
                        if (page == null) continue;
                        pageTmp = (PDPage)page;
                        pdDocOutTmp.addPage(pageTmp);
                    }
                }
                var26_26 = null;
                if (pdDocTmp != null) {
                    sourceDocListTmp.add(pdDocTmp);
                }
                try {
                    if (fisTmp != null) {
                        sErrMsgTmp = "Exception occurred on closing File Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                        fisTmp.close();
                        fisTmp = null;
                    }
                    if (bisTmp == null) continue;
                    sErrMsgTmp = "Exception occurred on closing Buffered Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                    bisTmp.close();
                    bisTmp = null;
                }
                catch (IOException e) {
                    osErrTmp = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(osErrTmp));
                    PDFConverterWrapper.logger.error((Object)(sErrMsgTmp + "InputObject=:" + arrInputObjectPar.toString() + ". " + e.getMessage() + ", StackTrace:" + osErrTmp.toString()));
                }
                continue;
                catch (Throwable var25_28) {
                    var26_26 = null;
                    if (pdDocTmp != null) {
                        sourceDocListTmp.add(pdDocTmp);
                    }
                    try {
                        if (fisTmp != null) {
                            sErrMsgTmp = "Exception occurred on closing File Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                            fisTmp.close();
                            fisTmp = null;
                        }
                        if (bisTmp != null) {
                            sErrMsgTmp = "Exception occurred on closing Buffered Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                            bisTmp.close();
                            bisTmp = null;
                        }
                    }
                    catch (IOException e) {
                        osErrTmp = new ByteArrayOutputStream();
                        e.printStackTrace(new PrintStream(osErrTmp));
                        PDFConverterWrapper.logger.error((Object)(sErrMsgTmp + "InputObject=:" + arrInputObjectPar.toString() + ". " + e.getMessage() + ", StackTrace:" + osErrTmp.toString()));
                    }
                    throw var25_28;
                }
            }
            this.secureDocument(pdDocOutTmp, sTargetUserPwdPar, sTargetOwnerPwdPar, sPermissionFlagsPar);
            baosTmp = new ByteArrayOutputStream();
            pdDocOutTmp.save((OutputStream)baosTmp);
            byArrMergedPDFTmp = baosTmp.toByteArray();
            var29_29 = null;
            try {
                if (fisTmp != null) {
                    sErrMsgTmp = "Exception occurred on closing File Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                    fisTmp.close();
                }
                if (bisTmp != null) {
                    sErrMsgTmp = "Exception occurred on closing Buffered Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                    bisTmp.close();
                }
                if (pdDocOutTmp != null) {
                    sErrMsgTmp = "Exception occurred on closing merged PDF Document handle";
                    pdDocOutTmp.close();
                }
                for (PDFDocument pdSourceDocTmp : sourceDocListTmp) {
                    sErrMsgTmp = "Exception occurred on closing input PDF Document handle";
                    if (pdSourceDocTmp == null) continue;
                    pdSourceDocTmp.close();
                }
            }
            catch (IOException e1) {
                osErrTmp = new ByteArrayOutputStream();
                e1.printStackTrace(new PrintStream(osErrTmp));
                PDFConverterWrapper.logger.warn((Object)(sErrMsgTmp + "InputObject=" + arrInputObjectPar.toString() + ". " + e1.getMessage() + ", StackTrace:" + osErrTmp.toString()));
                {
                }
            }
            break block41;
            catch (Throwable var28_37) {
                var29_30 = null;
                try {
                    if (fisTmp != null) {
                        sErrMsgTmp = "Exception occurred on closing File Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                        fisTmp.close();
                    }
                    if (bisTmp != null) {
                        sErrMsgTmp = "Exception occurred on closing Buffered Input Stream created for input PDF File. Filename: " + sFilenameTmp;
                        bisTmp.close();
                    }
                    if (pdDocOutTmp != null) {
                        sErrMsgTmp = "Exception occurred on closing merged PDF Document handle";
                        pdDocOutTmp.close();
                    }
                    for (PDFDocument pdSourceDocTmp : sourceDocListTmp) {
                        sErrMsgTmp = "Exception occurred on closing input PDF Document handle";
                        if (pdSourceDocTmp == null) continue;
                        pdSourceDocTmp.close();
                    }
                }
                catch (IOException e1) {
                    osErrTmp = new ByteArrayOutputStream();
                    e1.printStackTrace(new PrintStream(osErrTmp));
                    PDFConverterWrapper.logger.warn((Object)(sErrMsgTmp + "InputObject=" + arrInputObjectPar.toString() + ". " + e1.getMessage() + ", StackTrace:" + osErrTmp.toString()));
                }
                throw var28_37;
            }
        }
        return byArrMergedPDFTmp;
    }

    public String secure(String sInputPar) throws PDFConverterWrapperException {
        long timeBeginTmp;
        byte[] byBufferTmp = null;
        Gson gsonTmp = null;
        JsonParser jsonParserTmp = null;
        byte[] byRetTmp = null;
        try {
            if (sInputPar == null) {
                throw new PDFConverterWrapperException("Input parameter passed to secure method is null");
            }
            if (sInputPar.length() <= 0) {
                throw new PDFConverterWrapperException("Input parameter passed to secure method is empty");
            }
            if (bLogDebugEnabledThe) {
                logger.debug((Object)("Started processing Secure PDF request. Input JSON String:" + sInputPar));
            } else {
                logger.info((Object)"Started processing Secure PDF request. ");
            }
            timeBeginTmp = System.currentTimeMillis();
            jsonParserTmp = new JsonParser();
            JsonElement jsonElementTmp = jsonParserTmp.parse(sInputPar);
            if (jsonElementTmp == null) {
                throw new PDFConverterWrapperException("Input parameter passed to secure method is not JSON string");
            }
            if (!jsonElementTmp.isJsonObject()) {
                throw new PDFConverterWrapperException("Input parameter passed to secure method is not JSON object");
            }
            JsonObject jsonArgsTmp = jsonElementTmp.getAsJsonObject();
            if (jsonArgsTmp == null) {
                throw new PDFConverterWrapperException("Error on parsing JSON Input parameter passed to secure method");
            }
            jsonElementTmp = jsonArgsTmp.get("inputBuffer");
            if (jsonElementTmp == null) {
                throw new PDFConverterWrapperException("JSON Input string passed to secure method, does not contain \"inputBuffer \" parameter.");
            }
            if (!jsonElementTmp.isJsonArray()) {
                throw new PDFConverterWrapperException("\"inputBuffer \" parameter in JSON Input string passed to secure method, is not an array.");
            }
            String sSourceUserPwdTmp = null;
            String sSourceOwnerPwdTmp = null;
            String sTargetUserPwdTmp = null;
            String sTargetOwnerPwdTmp = null;
            String sPermFlagsTmp = null;
            String sApplicationTmp = null;
            String sProducerTmp = null;
            gsonTmp = new Gson();
            JsonArray arrayTmp = jsonElementTmp.getAsJsonArray();
            byBufferTmp = (byte[])gsonTmp.fromJson((JsonElement)arrayTmp, byte[].class);
            jsonElementTmp = jsonArgsTmp.get("sourceUserPWD");
            if (jsonElementTmp != null) {
                sSourceUserPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("sourceOwnerPWD")) != null) {
                sSourceOwnerPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("targetUserPWD")) != null) {
                sTargetUserPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("targetOwnerPWD")) != null) {
                sTargetOwnerPwdTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("permissionFlags")) != null) {
                sPermFlagsTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("pdfProducer")) != null) {
                sProducerTmp = jsonElementTmp.getAsString();
            }
            if ((jsonElementTmp = jsonArgsTmp.get("pdfApplication")) != null) {
                sApplicationTmp = jsonElementTmp.getAsString();
            }
            byRetTmp = this.secure(byBufferTmp, sSourceUserPwdTmp, sSourceOwnerPwdTmp, sTargetUserPwdTmp, sTargetOwnerPwdTmp, sPermFlagsTmp, sProducerTmp, sApplicationTmp);
        }
        catch (Exception ePar) {
            ByteArrayOutputStream osErrTmp = null;
            osErrTmp = new ByteArrayOutputStream();
            ePar.printStackTrace(new PrintStream(osErrTmp));
            logger.error((Object)("Exception occurred on Securing Input PDF buffer." + (byBufferTmp == null ? "" : " Input PDF Buffer Length: " + byBufferTmp.length + ",") + " " + ePar.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            throw new PDFConverterWrapperException("Exception occurred on Securing Input PDF buffer. " + (byBufferTmp == null ? "" : " Input PDF Buffer Length: " + byBufferTmp.length + ",") + " " + ePar.getMessage(), ePar);
        }
        String sRetTmp = gsonTmp.toJson((Object)byRetTmp);
        long timeEndTmp = System.currentTimeMillis();
        logger.info((Object)("Finished processing Secure PDF request." + (byBufferTmp == null ? "" : " Input PDF Buffer Length:" + byBufferTmp.length + ",") + " Secured PDF Length:" + (byRetTmp == null ? 0 : byRetTmp.length) + ", TimeTaken: " + (timeEndTmp - timeBeginTmp) / 1000L + " sec(s)."));
        return sRetTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] secure(byte[] byArrInputDataPar, String sSourceUserPwdPar, String sSourceOwnerPwdPar, String sTargetUserPwdPar, String sTargetOwnerPwdPar, String sPermissionFlagsPar, String sPDFProducerPar, String sPDFApplicationPar) throws PDFConverterWrapperException, IOException, COSVisitorException {
        ByteArrayOutputStream osErrTmp = null;
        byte[] byArrSecurePDFTmp = null;
        PDFDocument pdDocOutTmp = null;
        byte[] byArrDecryptedTmp = null;
        try {
            if (byArrInputDataPar == null) {
                throw new PDFConverterWrapperException("Input PDF buffer parameter passed to PDFConverterWrapper::secure() method is null");
            }
            if (byArrInputDataPar.length <= 0) {
                throw new PDFConverterWrapperException("Input PDF  buffer passed to PDFConverterWrapper::mergeAndSecure() method is empty");
            }
            logger.info((Object)("Secure PDF request parameters. Input PDF Buffer Length:" + byArrInputDataPar.length + ", SourceUserPwd:" + sSourceUserPwdPar + ", SourceOwnerPwd:" + sSourceOwnerPwdPar + ", TargetUserPwd:" + sTargetUserPwdPar + ", TargetOwnerPwd:" + sTargetOwnerPwdPar + ", PDFProducer:" + sPDFProducerPar + ", PDFApplication:" + sPDFApplicationPar + ", PermissionFlags:" + sPermissionFlagsPar));
            pdDocOutTmp = PDFFactory.getInstance().loadPDFDocument((InputStream)new ByteArrayInputStream(byArrInputDataPar));
            if (pdDocOutTmp == null) {
                throw new PDFConverterWrapperException("Could not create new PDF document to write output for Secure PDF request");
            }
            if (pdDocOutTmp.isEncrypted()) {
                pdDocOutTmp.close();
                pdDocOutTmp = null;
                byArrDecryptedTmp = this.decrypt_pdfbox("InputBuffer", byArrInputDataPar, sSourceOwnerPwdPar, sSourceUserPwdPar);
                pdDocOutTmp = PDFFactory.getInstance().loadPDFDocument((InputStream)new ByteArrayInputStream(byArrDecryptedTmp));
                if (pdDocOutTmp == null) {
                    throw new PDFConverterWrapperException("Could not load decrypted PDF document.");
                }
            }
            this.setMetadata(pdDocOutTmp, sPDFProducerPar, sPDFApplicationPar);
            this.secureDocument(pdDocOutTmp, sTargetUserPwdPar, sTargetOwnerPwdPar, sPermissionFlagsPar);
            ByteArrayOutputStream baosTmp = new ByteArrayOutputStream();
            pdDocOutTmp.save((OutputStream)baosTmp);
            pdDocOutTmp.close();
            pdDocOutTmp = null;
            byArrSecurePDFTmp = baosTmp.toByteArray();
            Object var15_14 = null;
            if (pdDocOutTmp == null) return byArrSecurePDFTmp;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (pdDocOutTmp == null) throw throwable;
            try {
                pdDocOutTmp.close();
                pdDocOutTmp = null;
                throw throwable;
            }
            catch (IOException e1) {
                osErrTmp = new ByteArrayOutputStream();
                e1.printStackTrace(new PrintStream(osErrTmp));
                logger.warn((Object)("Exception occurred on closing secured PDF Document handle. Input PDF Buffer Length:" + byArrInputDataPar.length + ". " + e1.getMessage() + ", StackTrace:" + osErrTmp.toString()));
            }
            throw throwable;
        }
        try {
            pdDocOutTmp.close();
            pdDocOutTmp = null;
            return byArrSecurePDFTmp;
        }
        catch (IOException e1) {
            osErrTmp = new ByteArrayOutputStream();
            e1.printStackTrace(new PrintStream(osErrTmp));
            logger.warn((Object)("Exception occurred on closing secured PDF Document handle. Input PDF Buffer Length:" + byArrInputDataPar.length + ". " + e1.getMessage() + ", StackTrace:" + osErrTmp.toString()));
        }
        return byArrSecurePDFTmp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decrypt_pdfbox(String sFilenamePar, byte[] byArrDocPar, String sOwnerPassPar, String sUserPassPar) throws IOException, PDFConverterWrapperException {
        ByteArrayOutputStream encOutTmp;
        PDFDocument docDecryptedTmp;
        PDFDocument docTmp;
        block24: {
            byte[] byArray;
            block22: {
                block23: {
                    docTmp = null;
                    docDecryptedTmp = null;
                    encOutTmp = null;
                    String sOwnerPasswordTmp = sOwnerPassPar;
                    String sUserPasswordTmp = sUserPassPar;
                    if (sOwnerPasswordTmp == null) {
                        sOwnerPasswordTmp = "";
                    }
                    if (sUserPasswordTmp == null) {
                        sUserPasswordTmp = "";
                    }
                    try {
                        try {
                            boolean bErrTmp = false;
                            docTmp = PDFFactory.getInstance().loadPDFDocument((InputStream)new ByteArrayInputStream(byArrDocPar));
                            if (docTmp == null) {
                                throw new PDFConverterWrapperException("Could not load PDF document for decrypting. Filename: " + sFilenamePar);
                            }
                            if (!docTmp.isEncrypted()) {
                                byArray = byArrDocPar;
                                Object var16_20 = null;
                                if (docTmp == null) break block22;
                                break block23;
                            }
                            try {
                                if (bLogDebugEnabledThe) {
                                    logger.debug((Object)("Started decrypting file using user password. Filename:" + sFilenamePar + ", UserPassword:" + sUserPasswordTmp));
                                }
                                docTmp.decrypt(sUserPasswordTmp);
                                if (bLogDebugEnabledThe) {
                                    logger.debug((Object)("Finished decrypting file using user password. Filename:" + sFilenamePar + ", UserPassword:" + sUserPasswordTmp));
                                }
                            }
                            catch (Exception e) {
                                bErrTmp = true;
                                logger.error((Object)("Exception occured on decrypting file using user password. Filename:" + sFilenamePar + ", UserPassword:" + sUserPasswordTmp + ", Msg:" + e.getMessage()));
                            }
                            if (bErrTmp) {
                                logger.info((Object)("Started decrypting file using owner password. Filename:" + sFilenamePar + ", OwnerPassword:" + sOwnerPasswordTmp));
                                docTmp.decrypt(sOwnerPasswordTmp);
                                logger.info((Object)("Finished decrypting file using owner password. Filename:" + sFilenamePar + ", OwnerPassword:" + sOwnerPasswordTmp));
                            }
                            docDecryptedTmp = PDFFactory.getInstance().newPDFACompliantDocument();
                            List pageList = docTmp.getDocumentCatalog().getAllPages();
                            PDPage pdPageTmp = null;
                            for (Object page : pageList) {
                                if (page == null) continue;
                                pdPageTmp = (PDPage)page;
                                docDecryptedTmp.addPage(pdPageTmp);
                            }
                            encOutTmp = new ByteArrayOutputStream();
                            docDecryptedTmp.save((OutputStream)encOutTmp);
                            docTmp.close();
                            docDecryptedTmp.close();
                            break block24;
                        }
                        catch (CryptographyException cePar) {
                            throw new PDFConverterWrapperException("Could not decrypt the input pdf file. Filename= " + sFilenamePar + cePar.getMessage());
                        }
                        catch (IOException ioePar) {
                            throw new PDFConverterWrapperException("IOException while decrypting the input pdf file. Filename= " + sFilenamePar + ioePar.getMessage());
                        }
                        catch (InvalidPasswordException ipePar) {
                            throw new PDFConverterWrapperException("Input PDF file decryption failed since user password and owner passwords are invalid. Filename= " + sFilenamePar + "UserPassword= " + sUserPasswordTmp + "OwnerPassword= " + sOwnerPasswordTmp + ipePar.getMessage());
                        }
                        catch (PDFXMPException xmpePar) {
                            throw new PDFConverterWrapperException("Input PDF file decryption failed. Filename= " + sFilenamePar + xmpePar.getMessage());
                        }
                        catch (PDFOutputIntentsException poiePar) {
                            throw new PDFConverterWrapperException("Input PDF file decryption failed. Filename= " + sFilenamePar + poiePar.getMessage());
                        }
                        catch (COSVisitorException cvePar) {
                            throw new PDFConverterWrapperException("Input PDF file decryption failed since PDF contains a invalid PDF Object. Filename= " + sFilenamePar + cvePar.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_22 = null;
                        if (docTmp != null) {
                            docTmp.close();
                        }
                        if (docDecryptedTmp == null) throw throwable;
                        docDecryptedTmp.close();
                        throw throwable;
                    }
                }
                docTmp.close();
            }
            if (docDecryptedTmp == null) return byArray;
            docDecryptedTmp.close();
            return byArray;
        }
        Object var16_21 = null;
        if (docTmp != null) {
            docTmp.close();
        }
        if (docDecryptedTmp != null) {
            docDecryptedTmp.close();
        }
        if (encOutTmp == null) return null;
        byte[] byArray = encOutTmp.toByteArray();
        return byArray;
    }

    private void setMetadata(PDFDocument docPar, String sPDFProducerPar, String sPDFApplicationPar) throws PDFConverterWrapperException {
        try {
            PDFXMP pdfXMPTmp = docPar.getPDFXMP();
            if (pdfXMPTmp != null) {
                pdfXMPTmp.setProducer(sPDFProducerPar);
                pdfXMPTmp.setCreatorTool(sPDFApplicationPar);
                docPar.setPDFXMP(pdfXMPTmp);
            }
        }
        catch (PDFXMPException ePar) {
            throw new PDFConverterWrapperException("Could not set PDF meta data to the newly created output PDF document. " + ePar.getMessage());
        }
    }

    private void secureDocument(PDFDocument pdDocPar, String sTargetUserPwdPar, String sTargetOwnerPwdPar, String sPermissionFlagsPar) throws PDFConverterWrapperException {
        try {
            String sOwnerPwdTmp = sTargetOwnerPwdPar;
            String sUserPwdTmp = sTargetUserPwdPar;
            if (sUserPwdTmp == null) {
                sUserPwdTmp = "";
            }
            if (sOwnerPwdTmp == null) {
                sOwnerPwdTmp = "";
            }
            if (sOwnerPwdTmp.length() != 0 || sUserPwdTmp.length() != 0) {
                AccessPermission apTmp = this.getAccessPermission(sPermissionFlagsPar);
                StandardProtectionPolicy sppTmp = new StandardProtectionPolicy(sOwnerPwdTmp, sUserPwdTmp, apTmp);
                sppTmp.setEncryptionKeyLength(128);
                pdDocPar.protect((ProtectionPolicy)sppTmp);
            }
        }
        catch (BadSecurityHandlerException ePar) {
            throw new PDFConverterWrapperException("Could not encrypt the merged PDF document. " + ePar.getMessage());
        }
    }

    private void setDisabled(AccessPermission apPar) {
        apPar.setCanAssembleDocument(false);
        apPar.setCanExtractContent(false);
        apPar.setCanExtractForAccessibility(false);
        apPar.setCanFillInForm(false);
        apPar.setCanModify(false);
        apPar.setCanModifyAnnotations(false);
        apPar.setCanPrint(false);
    }

    private AccessPermission getAccessPermission(String sPermissionFlagsPar) throws PDFConverterWrapperException {
        AccessPermission apTmp = new AccessPermission();
        this.setDisabled(apTmp);
        if (sPermissionFlagsPar == null || sPermissionFlagsPar.length() <= 0) {
            return apTmp;
        }
        int iCodeTmp = 0;
        String sFlagsTmp = null;
        StringTokenizer tokenizerTmp = new StringTokenizer(sPermissionFlagsPar, "|");
        while (tokenizerTmp.hasMoreElements()) {
            sFlagsTmp = tokenizerTmp.nextToken();
            if (sFlagsTmp == null || sFlagsTmp.length() <= 0) continue;
            try {
                iCodeTmp = Integer.parseInt(sFlagsTmp);
            }
            catch (NumberFormatException ePar) {
                throw new PDFConverterWrapperException("Output Flags(Access Permission flags) contain invalid(non numerical) value. Output Flags: " + sPermissionFlagsPar);
            }
            switch (iCodeTmp) {
                case 7: {
                    apTmp.setCanAssembleDocument(true);
                    break;
                }
                case 3: {
                    apTmp.setCanExtractContent(true);
                    break;
                }
                case 6: {
                    apTmp.setCanExtractForAccessibility(true);
                    break;
                }
                case 5: {
                    apTmp.setCanFillInForm(true);
                    break;
                }
                case 2: {
                    apTmp.setCanModify(true);
                    break;
                }
                case 4: {
                    apTmp.setCanModifyAnnotations(true);
                    break;
                }
                case 8: {
                    apTmp.setCanPrint(true);
                    break;
                }
                case 1: {
                    apTmp.setCanPrintDegraded(true);
                    break;
                }
                case 0: {
                    this.setDisabled(apTmp);
                    return apTmp;
                }
            }
        }
        return apTmp;
    }
}

