/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.blocking;

import de.maas.oxseed.office2any.blocking.BlockingObject;
import de.maas.oxseed.office2any.exceptions.MSOffice2007RuntimeException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingObjectImpl<T>
implements BlockingObject<T> {
    private String id;
    BlockingQueue<T> blockingQueue = new ArrayBlockingQueue<T>(1);

    @Override
    public T getResult(long timeout) throws InterruptedException {
        return this.blockingQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setResult(T object) {
        try {
            this.blockingQueue.add(object);
        }
        catch (IllegalStateException e) {
            throw new MSOffice2007RuntimeException((Throwable)e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

