/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.managers;

import de.maas.oxseed.office2any.DcomConstants;
import de.maas.oxseed.office2any.bean.ProcessInfo;
import de.maas.oxseed.office2any.exceptions.ProcessManagerException;
import de.maas.oxseed.office2any.managers.ProcessManager;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.IJIEnumVariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DcomProcessManagerImpl
implements ProcessManager {
    public static Logger logger = Logger.getLogger(DcomProcessManagerImpl.class);
    private String pattern = "dd.MM.yyyy HH:mm:ss";
    private String patternRead = "yyyyMMddHHmmss";
    private SimpleDateFormat formatOut = new SimpleDateFormat(this.pattern);
    private SimpleDateFormat formatRead = new SimpleDateFormat(this.patternRead);
    private JIComServer comStub = null;
    private IJIComObject comObject = null;
    private IJIDispatch dispatch = null;
    private String address = null;
    protected JISession session = null;
    private IJIDispatch wbemServices_dispatch = null;
    private boolean isNotificatorDaemonRunning = false;
    private Thread daemon = null;

    public DcomProcessManagerImpl(String host, String domain, String username, String password) throws ProcessManagerException {
        try {
            this.address = host;
            JISystem.setAutoRegisteration((boolean)true);
            this.session = JISession.createSession((String)domain, (String)username, (String)password);
            this.comStub = new JIComServer(JIProgId.valueOf((String)"WbemScripting.SWbemLocator"), this.address, this.session);
            try {
                Thread.sleep(DcomConstants.DCOM_SYSTEM_DELAY);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage());
            }
            IJIComObject unknown = this.comStub.createInstance();
            this.comObject = unknown.queryInterface("76A6415B-CB41-11d1-8B02-00600806D9B6");
            this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)this.comObject.queryInterface("00020400-0000-0000-c000-000000000046"));
            System.gc();
            JIVariant[] results = this.dispatch.callMethodA("ConnectServer", new Object[]{new JIString(this.address), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()});
            this.wbemServices_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        }
        catch (JIException e) {
            throw new ProcessManagerException(e);
        }
        catch (UnknownHostException e) {
            throw new ProcessManagerException(e);
        }
    }

    @Override
    public List<ProcessInfo> getAllThreads() throws ProcessManagerException {
        try {
            ArrayList<ProcessInfo> list = new ArrayList<ProcessInfo>();
            JIVariant[] results = this.wbemServices_dispatch.callMethodA("InstancesOf", new Object[]{new JIString("Win32_Process"), new Integer(0), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
            IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
            JIVariant Count = wbemObjectSet_dispatch.get("Count");
            int countProcesses = Count.getObjectAsInt();
            for (int i = 0; i < countProcesses; ++i) {
                Object[] values = enumVARIANT.next(1);
                JIArray array = (JIArray)values[0];
                Object[] arrayObj = (Object[])array.getArrayInstance();
                for (int j = 0; j < arrayObj.length; ++j) {
                    IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[j]).getObjectAsComObject());
                    variant = wbemObject_dispatch.get("Name");
                    String name = variant.getObjectAsString().getString();
                    variant = wbemObject_dispatch.get("ProcessId");
                    int PID = variant.getObjectAsInt();
                    ProcessInfo info = new ProcessInfo();
                    info.setPID(PID);
                    info.setName(name);
                    list.add(info);
                }
            }
            return list;
        }
        catch (JIException e) {
            throw new ProcessManagerException(e);
        }
    }

    @Override
    public void killApplications(List<String> applications) throws ProcessManagerException {
        try {
            JIVariant[] results = this.wbemServices_dispatch.callMethodA("InstancesOf", new Object[]{new JIString("Win32_Process"), new Integer(0), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
            IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
            JIVariant Count = wbemObjectSet_dispatch.get("Count");
            int countProcesses = Count.getObjectAsInt();
            int processesToTerminate = 0;
            int succesfulTerminated = 0;
            for (int i = 0; i < countProcesses; ++i) {
                Object[] values = enumVARIANT.next(1);
                JIArray array = (JIArray)values[0];
                Object[] arrayObj = (Object[])array.getArrayInstance();
                for (int j = 0; j < arrayObj.length; ++j) {
                    IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[j]).getObjectAsComObject());
                    JIVariant variant2 = wbemObject_dispatch.get("Name");
                    String name = variant2.getObjectAsString().getString();
                    if (!applications.contains(name.toUpperCase())) continue;
                    ++processesToTerminate;
                    variant2 = wbemObject_dispatch.get("ProcessId");
                    int PID = variant2.getObjectAsInt();
                    logger.debug((Object)("Call terminate : " + name + " PID=" + PID));
                    variant2 = wbemObject_dispatch.callMethodA("Terminate");
                    int result = variant2.getObjectAsInt();
                    String st = null;
                    switch (result) {
                        case 0: {
                            st = "Successful Completion";
                            ++succesfulTerminated;
                            break;
                        }
                        case 2: {
                            st = "Access Denied";
                            break;
                        }
                        case 3: {
                            st = "Insufficient Privilege";
                            break;
                        }
                        case 8: {
                            st = "Unknown Failure";
                            break;
                        }
                        case 9: {
                            st = "Path Not Found";
                            break;
                        }
                        case 21: {
                            st = "Invalid Parameter";
                            break;
                        }
                        default: {
                            st = "Unknown Result";
                        }
                    }
                    logger.info((Object)("Terminate " + name + " PID=" + PID + " : " + st));
                }
            }
            logger.info((Object)("Processes/To Terminate/Successful : " + countProcesses + "/" + processesToTerminate + "/" + succesfulTerminated));
        }
        catch (JIException e) {
            throw new ProcessManagerException(e);
        }
    }

    @Override
    public int killProcess(int PID2kill) throws ProcessManagerException {
        try {
            JIVariant[] results = this.wbemServices_dispatch.callMethodA("InstancesOf", new Object[]{new JIString("Win32_Process"), new Integer(0), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            JIVariant variant = wbemObjectSet_dispatch.get("_NewEnum");
            IJIComObject object2 = JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
            JIVariant Count = wbemObjectSet_dispatch.get("Count");
            int countProcesses = Count.getObjectAsInt();
            for (int i = 0; i < countProcesses; ++i) {
                Object[] values = enumVARIANT.next(1);
                JIArray array = (JIArray)values[0];
                Object[] arrayObj = (Object[])array.getArrayInstance();
                for (int j = 0; j < arrayObj.length; ++j) {
                    IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[j]).getObjectAsComObject());
                    JIVariant variant2 = wbemObject_dispatch.get("Name");
                    String name = variant2.getObjectAsString().getString();
                    variant2 = wbemObject_dispatch.get("ProcessId");
                    int PID = variant2.getObjectAsInt();
                    if (PID != PID2kill) continue;
                    logger.debug((Object)("Call terminate PID = " + PID));
                    variant2 = wbemObject_dispatch.callMethodA("Terminate");
                    int result = variant2.getObjectAsInt();
                    String st = null;
                    switch (result) {
                        case 0: {
                            st = "Successful Completion";
                            break;
                        }
                        case 2: {
                            st = "Access Denied";
                            break;
                        }
                        case 3: {
                            st = "Insufficient Privilege";
                            break;
                        }
                        case 8: {
                            st = "Unknown Failure";
                            break;
                        }
                        case 9: {
                            st = "Path Not Found";
                            break;
                        }
                        case 21: {
                            st = "Invalid Parameter";
                            break;
                        }
                        default: {
                            st = "Unknown Result";
                        }
                    }
                    if (result == 0) {
                        logger.info((Object)("Terminate PID=" + PID + ". Name = " + name + " : " + st));
                    } else {
                        logger.error((Object)("Terminate PID=" + PID + ". Name = " + name + " : " + st));
                    }
                    return result;
                }
            }
            logger.error((Object)("Process PID = " + PID2kill + " not found"));
            return 0;
        }
        catch (JIException e) {
            throw new ProcessManagerException(e);
        }
    }

    public void createNotificatorDaemon() throws ProcessManagerException {
        if (this.isNotificatorDaemonRunning) {
            return;
        }
        this.daemon = new Thread(new Runnable(){

            public void run() {
                boolean isRun = false;
                JIVariant[] results = null;
                IJIDispatch wbemEventSource_dispatch = null;
                try {
                    results = DcomProcessManagerImpl.this.wbemServices_dispatch.callMethodA("ExecNotificationQuery", new Object[]{new JIString("SELECT * FROM __InstanceCreationEvent WITHIN 10 WHERE TargetInstance ISA 'Win32_NTLogEvent' AND TargetInstance.Logfile = 'System'"), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
                    wbemEventSource_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
                    isRun = true;
                }
                catch (JIException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                JIVariant variant = null;
                Object st = null;
                block13: while (isRun && !Thread.interrupted()) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        variant = wbemEventSource_dispatch.callMethodA("NextEvent");
                        sb.append("SystemEvent. ");
                        IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
                        variant = wbemObject_dispatch.get("TargetInstance");
                        IJIDispatch dispatch33 = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
                        variant = dispatch33.get("EventType");
                        byte t = variant.getObjectAsUnsigned().getValue().byteValue();
                        String tString = DcomProcessManagerImpl.getEventTypeDescription(t);
                        sb.append("EventType : ").append(tString);
                        variant = dispatch33.get("TimeGenerated");
                        try {
                            String s1 = variant.getObjectAsString().getString().substring(0, 14);
                            Date date = DcomProcessManagerImpl.this.formatRead.parse(s1);
                            sb.append(". TimeGenerated : ").append(DcomProcessManagerImpl.this.formatOut.format(date));
                        }
                        catch (ParseException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        variant = dispatch33.get("SourceName");
                        sb.append(". SourceName : ").append(variant.getObjectAsString().getString());
                        variant = dispatch33.get("User");
                        try {
                            String stemp = ". User : " + variant.getObjectAsString().getString();
                            sb.append(stemp);
                        }
                        catch (IllegalStateException e) {
                            sb.append(". User : no data");
                        }
                        variant = dispatch33.get("ComputerName");
                        sb.append(". ComputerName : ").append(variant.getObjectAsString().getString());
                        variant = dispatch33.get("Message");
                        String mes = variant.getObjectAsString().getString();
                        if (mes.charAt(mes.length() - 1) == '\n') {
                            mes = mes.substring(0, mes.length() - 2);
                        }
                        sb.append(". Message : ").append(mes);
                        String s = sb.toString();
                        switch (t) {
                            case 1: {
                                logger.error((Object)s);
                                continue block13;
                            }
                            case 2: {
                                logger.warn((Object)s);
                                continue block13;
                            }
                            case 3: {
                                logger.info((Object)s);
                                continue block13;
                            }
                        }
                        logger.debug((Object)s);
                    }
                    catch (JIException e) {
                        if (e.getMessage().indexOf("[0x8001FFFF]") >= 0) continue;
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        this.daemon.setDaemon(true);
        this.daemon.setName(this.daemon.getName() + "(NotificatorDaemon)");
        this.daemon.start();
        this.isNotificatorDaemonRunning = true;
        System.out.println("Daemon started");
    }

    protected static String getEventTypeDescription(byte t) {
        String tString = null;
        switch (t) {
            case 1: {
                tString = "Error";
                break;
            }
            case 2: {
                tString = "Warning";
                break;
            }
            case 3: {
                tString = "Information";
                break;
            }
            case 4: {
                tString = "Security Audit Success";
                break;
            }
            case 5: {
                tString = "Security Audit Failure";
            }
        }
        return tString;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.formatOut.applyPattern(pattern);
    }

    @Override
    public void close() throws ProcessManagerException {
        try {
            if (this.isNotificatorDaemonRunning) {
                this.daemon.interrupt();
            }
            this.comObject.release();
            this.dispatch.release();
            JISession.destroySession((JISession)this.session);
        }
        catch (JIException e) {
            throw new ProcessManagerException(e);
        }
    }
}

