/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.managers;

import de.maas.oxseed.office2any.DcomConstants;
import de.maas.oxseed.office2any.exceptions.MSOfficeManagerException;
import de.maas.oxseed.office2any.managers.MSOfficeDcomManager;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MSExcelDcomManager
extends MSOfficeDcomManager {
    public static Logger logger = Logger.getLogger(MSExcelDcomManager.class);
    private double horisontalPrintQuality;
    private double verticalPrintQuality;
    private boolean qualityChanged = false;

    public MSExcelDcomManager(String host, String domain, String username, String password) throws MSOfficeManagerException {
        try {
            this.session = JISession.createSession((String)domain, (String)username, (String)password);
            this.comStub = new JIComServer(JIProgId.valueOf((String)"Excel.Application"), host, this.session);
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
        catch (UnknownHostException e) {
            throw new MSOfficeManagerException(e);
        }
        this.start();
    }

    protected void start() throws MSOfficeManagerException {
        try {
            try {
                Thread.sleep(DcomConstants.DCOM_SYSTEM_DELAY);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.unknown = this.comStub.createInstance();
            this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)this.unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
            int dispId = this.dispatch.getIDsOfNames("DisplayAlerts");
            JIVariant variant = new JIVariant((Object)Boolean.FALSE);
            this.dispatch.put(dispId, variant);
            logger.debug((Object)"XLS : Application started.");
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void openFile(String fileName, String password) throws MSOfficeManagerException {
        try {
            logger.debug((Object)("XLS : CALL open file : " + fileName + "."));
            JIVariant variant = this.dispatch.get("Workbooks");
            IJIDispatch documents = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            JIString filePath = new JIString(fileName);
            JIString variantPassword = new JIString(password);
            JIVariant[] variant2 = documents.callMethodA("open", new Object[]{filePath.VariantByRef, JIVariant.OPTIONAL_PARAM(), new JIVariant((Object)Boolean.TRUE), JIVariant.OPTIONAL_PARAM(), variantPassword, JIVariant.OPTIONAL_PARAM(), new JIVariant((Object)Boolean.TRUE), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            this.document = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant2[0].getObjectAsComObject());
            if (this.document != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("XLS: File " + fileName + " opened."));
                }
                this.fileName = fileName;
            } else {
                logger.error((Object)("XLS: File " + fileName + " not opened."));
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    protected void autoboxDataInWidth() throws MSOfficeManagerException {
        try {
            logger.debug((Object)"XLS: CALL SetAutoBox.");
            if (this.fileName == null || this.fileName == "") {
                logger.warn((Object)"XLS: No one opened document");
                return;
            }
            if (this.document == null) {
                logger.warn((Object)("XLS: No one assigned document to " + this.fileName));
                return;
            }
            JIVariant variant = this.document.get("Worksheets");
            IJIDispatch worksheets = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            variant = worksheets.get("Count");
            long count = variant.getObjectAsInt();
            int i = 1;
            while ((long)i <= count) {
                JIVariant[] variant1 = worksheets.get("Item", new Object[]{new Integer(i)});
                IJIDispatch worksheet = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant1[0].getObjectAsComObject());
                variant = worksheet.get("PageSetup");
                IJIDispatch pageSetup = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
                pageSetup.put("Zoom", new Object[]{new JIVariant(false)});
                pageSetup.put("FitToPagesTall", new Object[]{new JIVariant(false)});
                pageSetup.put("FitToPagesWide", new Object[]{new Integer(1)});
                ++i;
            }
            logger.debug((Object)("XLS: AutoBox done for file " + this.fileName));
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void setLandscape(boolean landscape) throws MSOfficeManagerException {
        try {
            logger.debug((Object)("XLS: CALL SetLandscape=" + landscape + "."));
            if (this.fileName == null || this.fileName == "") {
                logger.warn((Object)"XLS: No one opened document");
                return;
            }
            if (this.document == null) {
                logger.warn((Object)("XLS: No one assigned document to " + this.fileName));
                return;
            }
            int var = 1;
            if (landscape) {
                var = 2;
            }
            JIVariant variant = this.document.get("Worksheets");
            IJIDispatch worksheets = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            variant = worksheets.get("Count");
            long count = variant.getObjectAsInt();
            int i = 1;
            while ((long)i <= count) {
                JIVariant[] variant1 = worksheets.get("Item", new Object[]{new Integer(i)});
                IJIDispatch worksheet = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant1[0].getObjectAsComObject());
                variant = worksheet.get("PageSetup");
                IJIDispatch pageSetup = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
                pageSetup.put("Orientation", new Object[]{new Integer(var)});
                ++i;
            }
            logger.debug((Object)("XLS: SetLandscape=" + landscape + " done for file " + this.fileName));
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    protected void saveAsPdf(String outputFileName) throws MSOfficeManagerException {
        try {
            Long time = System.currentTimeMillis();
            logger.debug((Object)("XLS: CALL save " + outputFileName + "."));
            JIString fileSave = new JIString(outputFileName);
            JIVariant[] variant3 = this.document.callMethodA("SaveAs", new Object[]{fileSave.VariantByRef, new Integer(57), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            Long time2 = System.currentTimeMillis();
            logger.debug((Object)("XLS: File " + outputFileName + " saved. Time (ms)=" + (time2 - time)));
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    protected void saveAsTif(String outputFileName) throws MSOfficeManagerException {
        try {
            Long time = System.currentTimeMillis();
            logger.debug((Object)("XLS: CALL save " + outputFileName + "."));
            JIVariant variant = this.document.get("Worksheets");
            IJIDispatch worksheets = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            if (this.qualityChanged) {
                variant = worksheets.get("Count");
                long count = variant.getObjectAsInt();
                int i = 1;
                while ((long)i <= count) {
                    JIVariant[] variant1 = worksheets.get("Item", new Object[]{new Integer(i)});
                    IJIDispatch worksheet = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant1[0].getObjectAsComObject());
                    variant = worksheet.get("PageSetup");
                    IJIDispatch pageSetup = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
                    variant = pageSetup.get("CenterFooter");
                    String centerFooter = variant.getObjectAsString().getString();
                    pageSetup.put("PrintQuality", new Object[]{new Double(this.horisontalPrintQuality), new Double(this.verticalPrintQuality)});
                    pageSetup.put("CenterFooter", new Object[]{new JIString(centerFooter)});
                    ++i;
                }
                logger.debug((Object)("XLS: File " + outputFileName + " : PrintQuality changed to " + this.horisontalPrintQuality + "x" + this.verticalPrintQuality + "."));
                this.resetPrintQuality();
            }
            JIString fileSave = new JIString(outputFileName);
            JIVariant[] variant3 = this.document.callMethodA("PrintOut", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), fileSave.VariantByRef, JIVariant.OPTIONAL_PARAM()});
            Long time2 = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("XLS: File " + outputFileName + " saved. Time (ms)=" + (time2 - time)));
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void close() throws MSOfficeManagerException {
        try {
            logger.debug((Object)"CALL Quit Excel");
            JIVariant variant3 = this.dispatch.callMethodA("Quit");
            JISession.destroySession((JISession)this.session);
            logger.debug((Object)"Session destroyed.");
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void closeOpenedFile() throws MSOfficeManagerException {
        try {
            logger.debug((Object)("XLS: CALL Close Document Excel " + this.fileName));
            if (this.document != null) {
                JIVariant[] variant3 = this.document.callMethodA("Close", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
                logger.debug((Object)("XLS: Document " + this.fileName + " closed."));
                this.document = null;
                this.fileName = null;
            } else {
                logger.debug((Object)("XLS: closeOpenedFile() : Document " + this.fileName + " not opened."));
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public double getHorisontalPrintQuality() {
        return this.horisontalPrintQuality;
    }

    public double getVerticalPrintQuality() {
        return this.verticalPrintQuality;
    }

    public void setHorizontalPrintQuality(double horisontalPrintQuality) {
        this.horisontalPrintQuality = horisontalPrintQuality;
        this.qualityChanged = true;
    }

    public void setVerticalPrintQuality(double verticalPrintQuality) {
        this.verticalPrintQuality = verticalPrintQuality;
        this.qualityChanged = true;
    }

    public boolean supportPrintQuality() {
        return true;
    }

    protected void resetPrintQuality() {
        this.setHorizontalPrintQuality(0.0);
        this.setVerticalPrintQuality(0.0);
        this.qualityChanged = false;
    }
}

