/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.storage;

import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.storage.StorageFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

public class SambaStorageFile
implements StorageFile {
    private SmbFile file;

    public SambaStorageFile(String url) throws StorageException {
        try {
            this.file = new SmbFile(url);
        }
        catch (MalformedURLException e) {
            throw new StorageException(e);
        }
    }

    public void delete() throws StorageException {
        try {
            this.file.delete();
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
    }

    public boolean exists() throws StorageException {
        try {
            return this.file.exists();
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
    }

    public boolean canRead() throws StorageException {
        try {
            return this.file.canRead();
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
    }

    public InputStream getInputStream() throws StorageException {
        try {
            return new SmbFileInputStream(this.file);
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
        catch (MalformedURLException e) {
            throw new StorageException(e);
        }
        catch (UnknownHostException e) {
            throw new StorageException(e);
        }
    }

    public OutputStream getOutputStream() throws StorageException {
        try {
            return new SmbFileOutputStream(this.file);
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
        catch (MalformedURLException e) {
            throw new StorageException(e);
        }
        catch (UnknownHostException e) {
            throw new StorageException(e);
        }
    }

    public String getCanonicalPath() throws StorageException {
        return this.file.getCanonicalPath();
    }

    public boolean isDirectory() throws StorageException {
        try {
            return this.file.isDirectory();
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
    }

    public String[] listStorageFileNames() throws StorageException {
        try {
            return this.file.list();
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
    }

    public void mkDirs() throws StorageException {
        try {
            this.file.mkdirs();
        }
        catch (SmbException e) {
            throw new StorageException(e);
        }
    }
}

