/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.storage;

import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.storage.FileStorage;
import de.maas.oxseed.office2any.storage.SambaStorage;
import de.maas.oxseed.office2any.storage.Storage;
import java.net.MalformedURLException;
import java.net.URL;

public class StorageFactory {
    public static Storage getInstance(String urlShareString, String defaultUser, String defaultPassword, String domain) throws StorageException {
        try {
            Storage share = null;
            URL urlShare = new URL(null, urlShareString, SambaStorage.SMB_HANDLER);
            if ("smb".equalsIgnoreCase(urlShare.getProtocol())) {
                share = SambaStorage.getInstance(urlShareString, defaultUser, defaultPassword, domain);
            } else if ("file".equalsIgnoreCase(urlShare.getProtocol())) {
                share = FileStorage.getInstance(urlShareString);
            } else {
                throw new StorageException("Protocol " + urlShare.getProtocol() + " is unsupported. Supported protocols are: smb:// and file://.");
            }
            return share;
        }
        catch (MalformedURLException e) {
            throw new StorageException(e);
        }
    }
}

