/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf;

import de.maas.saas.Tiff2PdfVersion;
import de.maas.saas.data.Document;
import de.maas.saas.pdf.PDFAttachment;
import de.maas.saas.pdf.PDFException;
import de.maas.saas.pdf.PDFOutputIntents;
import de.maas.saas.pdf.PDFOutputIntentsException;
import de.maas.saas.pdf.PDFPage;
import de.maas.saas.pdf.PDFXMP;
import de.maas.saas.pdf.PDFXMPException;
import de.maas.saas.pdf.box.PDFAttachmentImpl;
import de.maas.saas.pdf.box.PDFFactory;
import de.maas.saas.tiff.TiffReaderException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.io.RandomAccess;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDFDocument
extends PDDocument {
    protected PDFDocument() throws IOException {
    }

    protected PDFDocument(COSDocument arg0) {
        super(arg0);
    }

    public abstract int getNumberOfPDFPages();

    public abstract PDFPage getPDFPageAt(int var1);

    public abstract Document getSimpleDocument() throws IOException;

    public abstract boolean addTiffImage(InputStream var1) throws IOException, TiffReaderException;

    public abstract boolean addJPGImage(InputStream var1) throws IOException, TiffReaderException;

    public abstract PDFXMP getPDFXMP() throws PDFXMPException;

    public abstract PDFXMP createPDFACompliantPDFXMP() throws PDFXMPException;

    public abstract void setPDFXMP(PDFXMP var1) throws PDFXMPException;

    public abstract void setOutputIntents(PDFOutputIntents var1) throws PDFOutputIntentsException;

    public static PDFDocument load(URL url) throws IOException {
        return PDFDocument.load(url.openStream());
    }

    public static PDFDocument load(URL url, RandomAccess scratchFile) throws IOException {
        return PDFDocument.load(url.openStream(), scratchFile);
    }

    public static PDFDocument load(String filename) throws IOException {
        return PDFDocument.load(new FileInputStream(filename));
    }

    public static PDFDocument load(String filename, RandomAccess scratchFile) throws IOException {
        return PDFDocument.load(new FileInputStream(filename), scratchFile);
    }

    public static PDFDocument load(File file) throws IOException {
        return PDFDocument.load(new FileInputStream(file));
    }

    public static PDFDocument load(File file, RandomAccess scratchFile) throws IOException {
        return PDFDocument.load(new FileInputStream(file));
    }

    public static PDFDocument load(InputStream input) throws IOException {
        return PDFDocument.load(input, null);
    }

    public static PDFDocument load(InputStream input, RandomAccess scratchFile) throws IOException {
        PDFParser parser = new PDFParser((InputStream)new BufferedInputStream(input), scratchFile);
        parser.parse();
        return PDFFactory.getInstance().getPDFDocument(parser.getDocument());
    }

    public String getAuthor() {
        return this.getDocumentInformation().getAuthor();
    }

    public String getKeywords() {
        return this.getDocumentInformation().getKeywords();
    }

    public Calendar getModificationDate() throws IOException {
        return this.getDocumentInformation().getModificationDate();
    }

    public String getSubject() {
        return this.getDocumentInformation().getSubject();
    }

    public String getTitle() {
        return this.getDocumentInformation().getTitle();
    }

    public String getTrapped() {
        return this.getDocumentInformation().getTrapped();
    }

    public void setAuthor(String author) {
        this.getDocumentInformation().setAuthor(author);
    }

    public void setKeywords(String keywords) {
        this.getDocumentInformation().setKeywords(keywords);
    }

    public void setModificationDate(Calendar date) {
        this.getDocumentInformation().setModificationDate(date);
    }

    public void setSubject(String subject) {
        this.getDocumentInformation().setSubject(subject);
    }

    public void setTitle(String title) {
        this.getDocumentInformation().setTitle(title);
    }

    public void setTrapped(String value) {
        this.getDocumentInformation().setTrapped(value);
    }

    public void save(OutputStream output) throws IOException, COSVisitorException {
        PDDocumentInformation info = this.getDocumentInformation();
        if (info.getAuthor() == null) {
            info.setAuthor("Oxseed");
        }
        if (info.getProducer() == null) {
            info.setProducer("Oxseed");
        }
        if (info.getCreator() == null) {
            info.setCreator(Tiff2PdfVersion.getVersion());
        }
        if (info.getCreationDate() == null) {
            info.setCreationDate(Calendar.getInstance(Locale.getDefault()));
        }
        super.save(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String fileName) throws IOException, COSVisitorException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(fileName);
            bos = new BufferedOutputStream(fos);
            this.save(bos);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void addAttachment(PDFAttachment att) throws PDFException {
        try {
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            fs.setFile(att.getFileName());
            InputStream is = att.getInputStream();
            PDEmbeddedFile ef = new PDEmbeddedFile((PDDocument)this, is);
            ef.setSubtype(att.getType());
            ef.setSize(att.getSize());
            ef.setCreationDate((Calendar)new GregorianCalendar());
            fs.setEmbeddedFile(ef);
            PDDocumentNameDictionary dict = this.getDocumentCatalog().getNames();
            if (dict == null) {
                HashMap<String, PDComplexFileSpecification> map = new HashMap<String, PDComplexFileSpecification>();
                map.put(att.getDescription(), fs);
                PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
                efTree.setNames(map);
                dict = new PDDocumentNameDictionary(this.getDocumentCatalog());
                dict.setEmbeddedFiles(efTree);
                this.getDocumentCatalog().setNames(dict);
            } else {
                PDEmbeddedFilesNameTreeNode efTree = dict.getEmbeddedFiles();
                HashMap<String, PDComplexFileSpecification> map = new HashMap<String, PDComplexFileSpecification>();
                map.putAll(efTree.getNames());
                map.put(att.getDescription(), fs);
                efTree.setNames(map);
            }
        }
        catch (IOException io) {
            throw new PDFException(io);
        }
    }

    public List<PDFAttachment> getAttachments() throws PDFException {
        ArrayList<PDFAttachment> l = null;
        try {
            PDDocumentNameDictionary dict = this.getDocumentCatalog().getNames();
            if (dict == null) {
                return null;
            }
            l = new ArrayList<PDFAttachment>();
            PDEmbeddedFilesNameTreeNode tree = dict.getEmbeddedFiles();
            Map m = tree.getNames();
            if (m == null || m.isEmpty()) {
                return l;
            }
            for (String key : m.keySet()) {
                PDComplexFileSpecification pc = (PDComplexFileSpecification)m.get(key);
                l.add(new PDFAttachmentImpl(key, pc));
            }
        }
        catch (Exception e) {
            throw new PDFException(e);
        }
        return l;
    }
}

