/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import de.maas.saas.pdf.PDFOutputIntents;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PDFOutputIntentsFactory {
    public static PDFOutputIntentsFactory getInstance() {
        return new PDFOutputIntentsFactory();
    }

    private PDFOutputIntentsFactory() {
    }

    public PDFOutputIntents createPDACompliantIO() {
        PDFOutputIntentsImpl pdfAImpl = new PDFOutputIntentsImpl();
        pdfAImpl.setOutputConditionIdentifier("sRGB IEC61966-2-1 noBPC");
        pdfAImpl.setS("GTS_PDFA1");
        pdfAImpl.setDestOutputProfile(PDFOutputIntentsFactory.getSRGBProfile());
        return pdfAImpl;
    }

    public static byte[] getSRGBProfile() {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream sRGBProfileIS = PDFOutputIntentsFactory.class.getResourceAsStream("sRGB_IEC61966-2-1_noBPC.icc");
            byte[] buffer = new byte[1024];
            while ((len = sRGBProfileIS.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected class PDFOutputIntentsImpl
    implements PDFOutputIntents {
        private byte[] destOutputProfile;
        private String s;
        private String outputConditionIdentifier;
        private String outputCondition;
        private String registryName;
        private String info;

        protected PDFOutputIntentsImpl() {
        }

        public void setDestOutputProfile(byte[] destOutputProfile) {
            this.destOutputProfile = destOutputProfile;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public void setOutputCondition(String outputCondition) {
            this.outputCondition = outputCondition;
        }

        public void setOutputConditionIdentifier(String outputConditionIdentifier) {
            this.outputConditionIdentifier = outputConditionIdentifier;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public byte[] getDestOutputProfile() {
            return this.destOutputProfile;
        }

        public String getInfo() {
            return this.info;
        }

        public String getOutputCondition() {
            return this.outputCondition;
        }

        public String getOutputConditionIdentifier() {
            return this.outputConditionIdentifier;
        }

        public String getRegistryName() {
            return this.registryName;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }
}

