/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.converter;

import de.maas.saas.Tiff2PdfVersion;
import de.maas.saas.pdf.PDFDocument;
import de.maas.saas.pdf.box.PDFFactory;
import de.maas.saas.pdf.converter.Tiff2PdfException;
import de.maas.saas.tiff.TiffReaderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.pdfbox.exceptions.COSVisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tiff2Pdf {
    private static Tiff2Pdf tiff2Pdf = null;

    public static Tiff2Pdf getSingletonInstance() {
        if (tiff2Pdf == null) {
            tiff2Pdf = new Tiff2Pdf();
        }
        return tiff2Pdf;
    }

    private Tiff2Pdf() {
        System.out.println(Tiff2PdfVersion.getVersion());
    }

    public void tiff2pdf(List<InputStream> tiffStreamList, ByteArrayOutputStream pdfOutput) throws Tiff2PdfException {
        PDFDocument pdfDocument = null;
        try {
            pdfDocument = PDFFactory.getInstance().newDocument();
            int count = 1;
            for (InputStream bais : tiffStreamList) {
                System.out.println("Add tiff..." + count);
                pdfDocument.addTiffImage(bais);
                ++count;
            }
            pdfDocument.save(pdfOutput);
            System.out.println("PDFDocument saved");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Tiff2PdfException("Error in creating pdf document", e.getCause());
        }
        catch (COSVisitorException e) {
            e.printStackTrace();
            throw new Tiff2PdfException("Error in spliting multipages", e.getCause());
        }
        catch (TiffReaderException e) {
            e.printStackTrace();
            throw new Tiff2PdfException("Error in spliting multipages", e.getCause());
        }
        finally {
            try {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

