/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.converter;

import de.maas.saas.tiff.TiffImage;
import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.TiffReaderUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class Tiff2PdfUtil {
    private Tiff2PdfUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDStream getTiffPDStream(TiffImage tiffImage, PDDocument doc) throws IOException, TiffReaderException {
        PDStream stream = new PDStream(doc);
        COSStream dic = stream.getStream();
        COSDictionary decodeParms = TiffReaderUtil.createCOSDictionary(tiffImage);
        OutputStream os = null;
        try {
            os = dic.createFilteredStream();
            PrintStream ps = new PrintStream(os, true, "utf-8");
            byte[] stripBytes = tiffImage.getImageData();
            ps.write(stripBytes);
            ps.flush();
            ps.close();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
        dic.setItem(COSName.FILTER, (COSBase)COSName.CCITTFAX_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"XObject"));
        dic.setItem("DecodeParms", (COSBase)decodeParms);
        return stream;
    }

    public static PDXObjectImage createPDCCITTImage(PDStream stream, TiffImage tiffImage) throws IOException {
        COSDictionary decodeParms = TiffReaderUtil.createCOSDictionary(tiffImage);
        PDCcitt ccitt = new PDCcitt(stream);
        ccitt.setBitsPerComponent(1);
        ccitt.setColorSpace((PDColorSpace)new PDDeviceGray());
        ccitt.setWidth(decodeParms.getInt("Columns"));
        ccitt.setHeight(decodeParms.getInt("Rows"));
        return ccitt;
    }
}

