/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.text;

import de.maas.saas.data.Segment;
import de.maas.saas.data.Segmentation;
import de.maas.saas.pdf.PDFText;
import de.maas.saas.pdf.PDFWord;
import de.maas.saas.utils.DataObjectFactory;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PDFTextImpl
implements PDFText {
    protected final List<PDFWord> wordList = new ArrayList<PDFWord>();
    private boolean simpleSegmentationFlag = false;
    private boolean boundsFlag = false;
    private Segmentation simpleSegmentation = null;
    private Rectangle bounds = null;
    private StringBuffer text = new StringBuffer();

    PDFTextImpl() {
    }

    public void addPDFWord(PDFWord word) {
        this.wordList.add(word);
        this.text.append(word.getText());
        if (this.simpleSegmentationFlag || this.boundsFlag) {
            this.simpleSegmentationFlag = false;
            this.simpleSegmentation = null;
            this.boundsFlag = false;
            this.bounds = null;
        }
    }

    @Override
    public List<PDFWord> getPDFWordList() {
        return this.wordList;
    }

    @Override
    public int getNumbersOfPDFWords() {
        return this.wordList.size();
    }

    @Override
    public PDFWord getPDFWordAt(int index) {
        return this.wordList.get(index);
    }

    @Override
    public Segmentation getSimpleSegmentation() throws IOException {
        if (!this.simpleSegmentationFlag) {
            this.recalculate();
            this.simpleSegmentation = new Segmentation();
            Segmentation.SegmentList segmentList = DataObjectFactory.getSaasObjectFactory().createSegmentationSegmentList();
            Segment segment = new Segment();
            segment.setSegmentID(0);
            segment.setVerified(this.getText());
            segment.setX(this.bounds.x);
            segment.setY(this.bounds.y);
            segment.setW(this.bounds.width);
            segment.setH(this.bounds.height);
            segmentList.getSegment().add(segment);
            this.simpleSegmentation.setSegmentList(segmentList);
            this.simpleSegmentationFlag = true;
        }
        return this.simpleSegmentation;
    }

    @Override
    public Rectangle getBounds() {
        this.recalculate();
        return this.bounds;
    }

    @Override
    public String getText() {
        return this.text.toString();
    }

    private void recalculate() {
        if (!this.boundsFlag) {
            for (PDFWord word : this.wordList) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle(word.getBounds());
                    continue;
                }
                this.bounds = this.bounds.union(word.getBounds());
            }
            if (this.bounds == null) {
                this.bounds = new Rectangle();
                PDRectangle rect = PDPage.PAGE_SIZE_LETTER;
                this.bounds.x = (int)rect.getLowerLeftX();
                this.bounds.y = (int)rect.getUpperRightY();
                this.bounds.width = Math.abs((int)(rect.getLowerLeftX() - rect.getUpperRightX()));
                this.bounds.height = Math.abs((int)(rect.getLowerLeftY() - rect.getUpperRightY()));
            }
            this.boundsFlag = true;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (PDFWord word : this.wordList) {
            buffer.append(word).append("\n");
        }
        return buffer.toString();
    }
}

