/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.text;

import de.maas.saas.pdf.PDFText;
import de.maas.saas.pdf.text.TextExtractor;
import java.io.IOException;
import java.util.Properties;
import org.pdfbox.pdmodel.PDPage;

public class TextExtractorFactory {
    private static TextExtractorFactory instance = null;
    private TextExtractor textExtractor = null;

    public static TextExtractorFactory getSingletonInstance() throws IOException {
        return instance == null ? (instance = new TextExtractorFactory()) : instance;
    }

    private TextExtractorFactory() throws IOException {
        Properties properties = new Properties();
        properties.load(TextExtractor.class.getResourceAsStream("operators.properties"));
        this.textExtractor = new TextExtractor(properties);
    }

    public PDFText getPDFText(PDPage page) throws IOException {
        this.textExtractor.clearCurrentPDFWordList();
        this.textExtractor.processStream(page, page.findResources(), page.getContents().getStream());
        return this.textExtractor.getCurrentWordList();
    }
}

