/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.text;

import de.maas.saas.pdf.encoding.GermanPolishEncodingFactory;
import de.maas.saas.pdf.text.TextExtractor;
import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.text.PDTextState;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.operator.OperatorProcessor;

public class TextGlyphOperation
extends OperatorProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PDFOperator operator, List arguments) throws IOException {
        COSArray array = (COSArray)arguments.get(0);
        float adjustment = 0.0f;
        TextExtractor context = (TextExtractor)this.context;
        context.beginTextGlyph();
        try {
            for (int i = 0; i < array.size(); ++i) {
                COSBase next = array.get(i);
                if (next instanceof COSNumber) {
                    adjustment = ((COSNumber)next).floatValue();
                    Matrix adjMatrix = new Matrix();
                    PDTextState textState = context.getGraphicsState().getTextState();
                    PDFont font = textState.getFont();
                    Encoding encoding = font.getEncoding();
                    font.setEncoding(GermanPolishEncodingFactory.getEncoding(encoding));
                    adjustment = -adjustment / 1000.0f * textState.getFontSize() * (textState.getHorizontalScalingPercent() / 100.0f);
                    adjMatrix.setValue(2, 0, adjustment);
                    context.setTextMatrix(adjMatrix.multiply(context.getTextMatrix()));
                    context.setCurrentAdjustment(adjustment);
                    continue;
                }
                if (next instanceof COSString) {
                    byte[] wordByte = ((COSString)next).getBytes();
                    context.showString(wordByte);
                    continue;
                }
                throw new IOException("Unknown type in array for TJ operation:" + next);
            }
        }
        finally {
            context.endTextGlyph();
        }
    }
}

