/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.IFD;
import de.maas.saas.tiff.reader.TiffHeader;
import de.maas.saas.tiff.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class TiffStream {
    byte[] bufferImageData = null;
    int currentOffset = 0;
    int previousOffset = 0;
    TiffHeader tiffHeader = null;
    IFD firstIFD = null;

    public TiffStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[8192];
        int len = 0;
        while ((len = is.read(b)) > 0) {
            baos.write(b, 0, len);
            baos.flush();
        }
        this.bufferImageData = baos.toByteArray();
        baos.close();
    }

    public TiffStream(byte[] source) {
        this.bufferImageData = source;
    }

    public void clear() {
        this.bufferImageData = null;
        this.currentOffset = 0;
        this.firstIFD = null;
        this.tiffHeader = null;
        System.gc();
    }

    public boolean read() throws TiffReaderException, IOException {
        if (this.tiffHeader != null) {
            return true;
        }
        this.tiffHeader = new TiffHeader();
        this.tiffHeader.readFully(this);
        this.firstIFD = new IFD(this.tiffHeader.littleEndian);
        return this.firstIFD.readFully(this.tiffHeader.firstifdoffset, this);
    }

    public IFD getFirstIFD() {
        return this.firstIFD;
    }

    int read4bytes() {
        this.previousOffset = this.currentOffset;
        int i1 = 0xFF & this.bufferImageData[this.currentOffset++];
        int i2 = 0xFF & this.bufferImageData[this.currentOffset++];
        int i3 = 0xFF & this.bufferImageData[this.currentOffset++];
        int i4 = 0xFF & this.bufferImageData[this.currentOffset++];
        int result = this.tiffHeader.littleEndian ? i1 + (i2 << 8) + (i3 << 16) + (i4 << 24) : i4 + (i3 << 8) + (i2 << 16) + (i1 << 24);
        return result;
    }

    int read2bytes() {
        this.previousOffset = this.currentOffset;
        int i1 = 0xFF & this.bufferImageData[this.currentOffset++];
        int i2 = 0xFF & this.bufferImageData[this.currentOffset++];
        int result = this.tiffHeader.littleEndian ? i1 + (i2 << 8) : (i1 << 8) + i2;
        return result;
    }

    void skeepBytes(int skeepValue) {
        this.currentOffset += skeepValue;
    }

    void gotoOffset(int newOffset) {
        this.currentOffset = newOffset;
    }

    byte[] getAllBytes() {
        return this.bufferImageData;
    }

    byte[] getBytes(int start, int end) {
        return StreamUtil.getBytes(this.bufferImageData, start, end);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.bufferImageData = null;
        this.tiffHeader = null;
        this.firstIFD = null;
    }
}

