/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.encoding;

import de.maas.saas.pdf.encoding.GermanCharacter;
import de.maas.saas.pdf.encoding.PolishCharacter;
import org.pdfbox.cos.COSName;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.encoding.StandardEncoding;
import org.pdfbox.encoding.WinAnsiEncoding;

public class GermanPolishEncodingFactory {
    public static Encoding getEncoding(Encoding encoding) {
        if (encoding == null) {
            return null;
        }
        if (encoding instanceof StandardEncoding || encoding instanceof WinAnsiEncoding) {
            return GermanPolishEncodingFactory.getGermanEncoding();
        }
        return encoding;
    }

    public static Encoding getGermanEncoding() {
        return new GermanEncoding();
    }

    public static Encoding getPolishEncoding() {
        return new PolishEncoding();
    }

    static class GermanEncoding
    extends StandardEncoding {
        public GermanEncoding() {
            for (GermanCharacter character : GermanCharacter.values()) {
                this.addCharacterEncoding(character.getIntCode(), COSName.getPDFName((String)(character.getCharacter() + "")));
            }
        }
    }

    static class PolishEncoding
    extends StandardEncoding {
        public PolishEncoding() {
            for (PolishCharacter character : PolishCharacter.values()) {
                this.addCharacterEncoding(character.getIntCode(), COSName.getPDFName((String)(character.getCharacter() + "")));
            }
        }
    }

    static class GermanPolishStandardEncoding
    extends StandardEncoding {
        public GermanPolishStandardEncoding() {
            for (PolishCharacter polishCharacter : PolishCharacter.values()) {
                this.addCharacterEncoding(polishCharacter.getIntCode(), COSName.getPDFName((String)(polishCharacter.getCharacter() + "")));
            }
            for (Enum enum_ : GermanCharacter.values()) {
                this.addCharacterEncoding(enum_.getIntCode(), COSName.getPDFName((String)(enum_.getCharacter() + "")));
            }
        }
    }

    static class GermanPolishWinAnsiEncoding
    extends WinAnsiEncoding {
        public GermanPolishWinAnsiEncoding() {
            for (PolishCharacter polishCharacter : PolishCharacter.values()) {
                this.addCharacterEncoding(polishCharacter.getIntCode(), COSName.getPDFName((String)(polishCharacter.getCharacter() + "")));
            }
            for (Enum enum_ : GermanCharacter.values()) {
                this.addCharacterEncoding(enum_.getIntCode(), COSName.getPDFName((String)(enum_.getCharacter() + "")));
            }
        }
    }
}

