/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.text;

import de.maas.saas.pdf.PDFText;
import de.maas.saas.pdf.PDFWord;
import de.maas.saas.pdf.text.PDFTextImpl;
import de.maas.saas.pdf.text.PDFWordImpl;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.TextPosition;

class TextExtractor
extends PDFStreamEngine {
    final String GERMAN_ENCODING = "german";
    final String HEBREW_ENCODING = "hebrew";
    final String UTF_8_ENCODING = "UTF-8";
    final String UTF_16_ENCODING = "UTF-16";
    final String GREEK_ENCODING = "greek8";
    final String EUROPE_ENCODING = "europe";
    final String WINDOWS_ENCODING = "windows-1258";
    final String ISO_2_ENCODING = "iso-8859-2";
    private List<PDFWord> currentWordList = new ArrayList<PDFWord>();
    private List<PDFWordImpl> glyphWordList = new ArrayList<PDFWordImpl>();
    private boolean glyphWordListFlag = false;
    private TextSpacing spacing = new TextSpacing();

    public void setCurrentAdjustment(float value) {
    }

    public void setWordSpacing(float value) {
        this.spacing.setEnable(true);
        this.spacing.setWordSpacing(value);
    }

    public void setCharSpacing(float value) {
        this.spacing.setCharSpacing(value);
    }

    public void realizeSpacing() {
        this.spacing.release();
    }

    public TextExtractor(Properties properties) throws IOException {
        super(properties);
    }

    public void beginTextGlyph() {
        if (this.glyphWordListFlag) {
            throw new RuntimeException("Show text glyph is allready started.");
        }
        this.glyphWordListFlag = true;
    }

    public void endTextGlyph() {
        if (!this.glyphWordListFlag) {
            throw new RuntimeException("Text glyph has not been started.");
        }
        this.glyphWordListFlag = false;
        Rectangle bounds = null;
        StringBuffer text = new StringBuffer();
        PDFont font = null;
        float fontSize = 0.0f;
        for (PDFWordImpl word : this.glyphWordList) {
            text.append(word.getWordWithSpacing());
            if (bounds == null) {
                bounds = word.getBounds();
                font = word.getFont();
                fontSize = word.getFontSize();
                continue;
            }
            bounds = bounds.union(word.getBounds());
        }
        PDFWordImpl word = new PDFWordImpl();
        word.setBounds(bounds);
        word.setFont(font);
        word.setFontSize(fontSize);
        word.setText(text.toString());
        this.currentWordList.add(word);
        this.glyphWordList.clear();
    }

    public void clearCurrentPDFWordList() {
        this.currentWordList.clear();
        this.spacing.release();
    }

    protected void showCharacter(TextPosition text) {
        PDFWordImpl word = new PDFWordImpl();
        PDFont font = text.getFont();
        word.setFont(font);
        word.setFontSize(text.getFontSize());
        float fx = text.getX();
        float fy = text.getY();
        float fwidth = text.getWidth();
        float fheight = text.getFontSize();
        float nx = (float)Math.floor(fx);
        float ny = (float)Math.floor(fy);
        float rx = fx - nx;
        float ry = fy - ny;
        fwidth += rx;
        fwidth = Math.round(fwidth + 0.5f);
        fheight += ry;
        fheight = Math.round(fheight + 0.5f);
        Rectangle bounds = new Rectangle((int)nx, (int)ny, (int)fwidth, (int)fheight);
        word.setBounds(bounds);
        if (this.spacing.useSpace(text)) {
            word.setWordSpace();
        }
        String str = text.getCharacter();
        word.setText(str.toString());
        if (this.glyphWordListFlag) {
            this.glyphWordList.add(word);
        } else {
            this.currentWordList.add(word);
        }
    }

    public PDFText getCurrentWordList() {
        PDFTextImpl wordList = new PDFTextImpl();
        for (PDFWord word : this.currentWordList) {
            wordList.addPDFWord(word);
        }
        return wordList;
    }

    private class TextSpacing {
        private boolean enable = false;
        private boolean useCharSpacing = false;
        private boolean useWordSpacing = false;
        private float charSpacing = 0.0f;
        private float wordSpacing = 0.0f;
        private TextPosition lastTextPosition = null;

        private TextSpacing() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean useSpace(TextPosition currentText) {
            if (this.lastTextPosition == null) {
                this.lastTextPosition = currentText;
                return false;
            }
            try {
                float fx = currentText.getX();
                float fy = currentText.getY();
                float fendx = currentText.getWidth() + fx;
                float fendy = currentText.getHeight() + fy;
                float endPosOfLastText = this.lastTextPosition.getX() + this.lastTextPosition.getWidth();
                float yPosOfLastText = this.lastTextPosition.getY() + this.lastTextPosition.getHeight();
                if (this.enable) {
                    float variation = fx - endPosOfLastText;
                    if (variation <= 0.0f && (fy > yPosOfLastText || this.lastTextPosition.getY() > fendy)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.useWordSpacing) {
                        boolean bl = this.wordSpacing <= variation;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                float lastWOS = this.lastTextPosition.getWidthOfSpace();
                float currentWOS = currentText.getWidthOfSpace();
                if (currentWOS != lastWOS) {
                    boolean bl = true;
                    return bl;
                }
                float variation = fx - endPosOfLastText;
                if (fy > yPosOfLastText || fendx < this.lastTextPosition.getX() || variation > 0.0f && (variation * 2.0f > currentWOS || currentWOS - variation < 1.0f)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lastTextPosition = currentText;
            }
        }

        public float getCharSpacing() {
            return this.charSpacing;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public boolean isUseCharSpacing() {
            return this.useCharSpacing;
        }

        public boolean isUseWordSpacing() {
            return this.useWordSpacing;
        }

        public float getWordSpacing() {
            return this.wordSpacing;
        }

        public void setCharSpacing(float charSpacing) {
            this.charSpacing = charSpacing;
            this.useCharSpacing = true;
        }

        public void setWordSpacing(float wordSpacing) {
            this.wordSpacing = wordSpacing;
            this.useWordSpacing = true;
            if (this.wordSpacing < 1.0f) {
                this.setEnable(false);
                this.releaseWordSpacing();
            }
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void release() {
            this.setEnable(false);
            this.lastTextPosition = null;
            this.releaseCharSpacing();
            this.releaseWordSpacing();
        }

        public void releaseCharSpacing() {
            this.useCharSpacing = false;
        }

        public void releaseWordSpacing() {
            this.useWordSpacing = false;
        }
    }
}

