/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.IFDEntry;
import de.maas.saas.tiff.reader.StripByteData;
import de.maas.saas.tiff.util.StreamUtil;
import java.io.IOException;

class StripBytesReverse {
    private static final int B0 = 0;
    private static final int B1 = 1;
    private static final int B2 = 2;
    private static final int B3 = 3;
    private static final int B4 = 4;
    private static final int B5 = 5;
    private static final int B6 = 6;
    private static final int B7 = 7;
    private static StripBytesReverse instance = null;

    public static StripBytesReverse getSingletonInstance() {
        if (instance == null) {
            instance = new StripBytesReverse();
        }
        return instance;
    }

    private StripBytesReverse() {
    }

    public byte[] getTiffImageData(StripByteData imageData, IFDEntry fillOrder) throws IOException, TiffReaderException {
        if (imageData == null) {
            throw new NullPointerException("No data to process - no image data");
        }
        return this.getImageData(imageData, fillOrder);
    }

    protected byte[] getImageData(StripByteData imageData, IFDEntry fillOrder) throws TiffReaderException {
        byte[] stripData = imageData.getStripsData();
        byte[] tileData = imageData.getTileData();
        IFDEntry stripByteCountsEntry = imageData.getStripByteCounts();
        IFDEntry tileByteCountsEntry = imageData.getTileByteCounts();
        if (stripByteCountsEntry != null && stripData != null) {
            int[] stripByteIs = stripByteCountsEntry.getValue();
            if (stripByteIs.length > 1) {
                throw new TiffReaderException("To much data in strip");
            }
            if (fillOrder == null || fillOrder.getValueOrOffset() == 1) {
                return stripData;
            }
            return this.getRevertBytes(StreamUtil.getBytes(stripData, 0, stripByteIs[0]));
        }
        if (tileByteCountsEntry != null && tileData != null) {
            int[] tileByteIs = tileByteCountsEntry.getValue();
            if (tileByteIs.length > 1) {
                throw new TiffReaderException("To much data in tile");
            }
            if (fillOrder == null || fillOrder.getValueOrOffset() == 1) {
                return tileData;
            }
            return this.getRevertBytes(StreamUtil.getBytes(tileData, 0, tileByteIs[0]));
        }
        throw new TiffReaderException("No data inside tiff image");
    }

    private byte[] getRevertBytes(byte[] imageData) {
        int length = imageData.length;
        byte[] resultImageData = new byte[length];
        for (int i = 0; i < length; ++i) {
            resultImageData[i] = this.getRevertByte(imageData[i]);
        }
        return resultImageData;
    }

    private byte getRevertByte(byte value) {
        byte i1 = (byte)(value >> 0 & 1);
        byte i2 = (byte)(value >> 1 & 1);
        byte i3 = (byte)(value >> 2 & 1);
        byte i4 = (byte)(value >> 3 & 1);
        byte i5 = (byte)(value >> 4 & 1);
        byte i6 = (byte)(value >> 5 & 1);
        byte i7 = (byte)(value >> 6 & 1);
        byte i8 = (byte)(value >> 7 & 1);
        byte result = 0;
        result = (byte)(result | i1 << 7);
        result = (byte)(result | i2 << 6);
        result = (byte)(result | i3 << 5);
        result = (byte)(result | i4 << 4);
        result = (byte)(result | i5 << 3);
        result = (byte)(result | i6 << 2);
        result = (byte)(result | i7 << 1);
        result = (byte)(result | i8 << 0);
        return result;
    }
}

