/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.TiffStream;

class TiffHeader
implements Cloneable {
    final short TIF_SIG_BE = (short)19789;
    final short TIF_SIG_LE = (short)18761;
    final short TIF_VERSION = (short)42;
    private static final int LITTLE_ENDIAN = 73;
    boolean littleEndian;
    int firstifdoffset;
    byte[] headerByte;

    TiffHeader() {
    }

    void readFully(TiffStream tiffStream) throws TiffReaderException {
        this.littleEndian = (tiffStream.bufferImageData[tiffStream.currentOffset] & 0xFF) == 73;
        int tiffsignature = tiffStream.read2bytes();
        int tiffversion = tiffStream.read2bytes();
        this.firstifdoffset = tiffStream.read4bytes();
        if (tiffsignature != 19789 && tiffsignature != 18761 || tiffversion != 42 || this.firstifdoffset < 8) {
            throw new TiffReaderException("Given file is not a tiff file");
        }
        this.headerByte = tiffStream.getBytes(0, tiffStream.currentOffset);
    }

    void changeFirstifdOffset(int newIfdOffset) {
        byte i4;
        byte i3;
        byte i2;
        byte i1;
        if (this.littleEndian) {
            i1 = (byte)newIfdOffset;
            i2 = (byte)(newIfdOffset >> 8);
            i3 = (byte)(newIfdOffset >> 16);
            i4 = (byte)(newIfdOffset >> 24);
        } else {
            i1 = (byte)(newIfdOffset >> 24);
            i2 = (byte)(newIfdOffset >> 16);
            i3 = (byte)(newIfdOffset >> 8);
            i4 = (byte)newIfdOffset;
        }
        this.headerByte[4] = i1;
        this.headerByte[5] = i2;
        this.headerByte[6] = i3;
        this.headerByte[7] = i4;
        this.firstifdoffset = newIfdOffset;
    }

    public Object clone() throws CloneNotSupportedException {
        TiffHeader tiffHeader = new TiffHeader();
        tiffHeader.firstifdoffset = this.firstifdoffset;
        tiffHeader.littleEndian = this.littleEndian;
        tiffHeader.headerByte = new byte[this.headerByte.length];
        System.arraycopy(this.headerByte, 0, tiffHeader.headerByte, 0, this.headerByte.length);
        return tiffHeader;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.headerByte = null;
    }
}

