/*
 * Decompiled with CFR 0.152.
 */
package de.maas.jbi.helper;

import de.maas.jbi.helper.ServiceComponent;
import de.maas.jbi.helper.ServiceFatalException;
import de.maas.saas.archiver.ArchiveResolver;
import de.maas.saas.archiver.ArchiveResolverFactory;
import de.maas.saas.data.Action;
import de.maas.saas.data.Order;
import de.maas.saas.utils.ActionStatus;
import de.maas.saas.utils.ActionUtils;
import de.maas.saas.utils.NMRXMLSerializer;
import de.maas.saas.utils.SaasUtils;
import de.maas.saas.utils.XMLSerializerException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActionEndpointComponent
extends ServiceComponent {
    private static FileSystemManager fsManager;
    private String workingDirectory;
    private boolean cancelOnPreviousErrors = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws JBIException {
        Class<FileSystemManager> clazz = FileSystemManager.class;
        synchronized (FileSystemManager.class) {
            if (fsManager == null) {
                try {
                    fsManager = VFS.getManager();
                }
                catch (Exception exc) {
                    throw new JBIException(exc.getMessage(), (Throwable)exc);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            super.init();
            return;
        }
    }

    @Override
    protected final void messageExchange(MessageExchange exchange) throws MessagingException {
        try {
            NormalizedMessage nmrMessage = null;
            if (exchange.getStatus().equals(ExchangeStatus.ACTIVE)) {
                if (exchange.getRole().equals(MessageExchange.Role.PROVIDER)) {
                    nmrMessage = this.getInMessage(exchange);
                } else if (exchange.getRole().equals(MessageExchange.Role.CONSUMER)) {
                    nmrMessage = this.getOutMessage(exchange);
                }
                HashMap<String, DataHandler> attachments = null;
                if (nmrMessage.getAttachmentNames().size() > 0) {
                    attachments = new HashMap<String, DataHandler>(nmrMessage.getAttachmentNames().size());
                    for (Object attName : nmrMessage.getAttachmentNames()) {
                        attachments.put((String)attName, nmrMessage.getAttachment((String)attName));
                    }
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("Message is processing:" + exchange.getExchangeId()));
                }
                this.processRequest(nmrMessage, attachments);
                this.done(exchange);
            }
        }
        catch (Exception fa) {
            this.getLog().error((Object)this, (Throwable)fa);
            throw new MessagingException((Throwable)fa);
        }
    }

    private void processRequest(NormalizedMessage nmr, Map<String, DataHandler> attachments) throws IOException, XMLSerializerException {
        block13: {
            Object dataObject = NMRXMLSerializer.readObject(Order.class, (NormalizedMessage)nmr);
            if (dataObject instanceof Order) {
                String actionName;
                Order o = (Order)dataObject;
                ActionUtils au = ActionUtils.findFirstAction((Order)o);
                String string = actionName = au.getFirstAction() == null ? "null" : au.getFirstAction().getName();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug(o, au.getFoundProcess(), au.getFoundDocument(), null, "First action:" + actionName);
                }
                try {
                    if (!au.getFirstAction().getName().equals(this.getEndpoint())) {
                        this.getLog().error(o, au.getFoundProcess(), au.getFoundDocument(), null, "Action is invalid for this service (action:" + au.getFirstAction().getName() + "<>" + this.getEndpoint() + ")");
                        if (this.getLog().isDebugEnabled()) {
                            for (Action a : au.getFoundDocument().getActionList().getAction()) {
                                this.getLog().debug(o, au.getFoundProcess(), au.getFoundDocument(), null, a.toString());
                            }
                        }
                        break block13;
                    }
                    if (this.isCancelOnPreviousErrors() && ActionUtils.hasErrors((ActionUtils)au)) {
                        this.getLog().warn(au.getParentOrder(), au.getParentProcess(), au.getFoundDocument(), null, "Action cancelled due to previous errors");
                        Action a = au.getFirstAction();
                        this.errorAction(a, "Action cancelled due to previous errors");
                        this.sendMessage(o, null);
                        return;
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug(o, null, null, null, "Process request");
                    }
                    try {
                        if (attachments != null) {
                            this.processOrder(o, au, attachments);
                            break block13;
                        }
                        this.processOrder(o, au);
                    }
                    catch (Exception sfe) {
                        this.errorAction(au.getFirstAction(), "error:" + sfe.getMessage());
                        this.getLog().error(o, null, null, null, "error:" + sfe.getMessage(), (Throwable)sfe);
                        this.sendMessage(o, null);
                    }
                }
                catch (Exception e) {
                    SaasUtils.printStatus(o, "Error", e.getMessage());
                    this.getLog().error(o, null, null, null, e.getMessage());
                    if (ActionUtils.isActive((Action)au.getFirstAction())) {
                        this.errorAction(au.getFirstAction(), e.getMessage());
                    }
                    if (!ActionUtils.isDone((Action)au.getFirstAction())) break block13;
                    this.getLog().warn(o, null, null, null, "Fatal exception: changing status of action from done to error");
                    this.errorAction(au.getFirstAction(), e.getMessage());
                }
            }
        }
    }

    protected abstract void processOrder(Order var1, ActionUtils var2) throws ServiceFatalException;

    protected void processOrder(Order order, ActionUtils au, Map<String, DataHandler> attachments) throws ServiceFatalException {
        attachments.clear();
        this.getLog().warn(order, null, null, null, "Order contains attachments - using default processOrderImplementation");
        this.processOrder(order, au);
    }

    protected final Action updateAction(Action a, String status, String description) {
        a.setStatus(ActionStatus.fromValue((String)status).value());
        a.setStatusDescription(description);
        a.setUpdateBy(this.getEndpoint() + ":" + this.getName());
        a.setUpdateDate(DateFormat.getDateTimeInstance().format(new Date()));
        return a;
    }

    protected final Action doneAction(Action a, String description) {
        return this.updateAction(a, ActionStatus.Done.value(), description);
    }

    protected final Action doneAction(Action a) {
        return this.updateAction(a, ActionStatus.Done.value(), "");
    }

    protected final Action errorAction(Action a, String description) {
        return this.updateAction(a, ActionStatus.Error.value(), description);
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected final byte[] readFile(InputStream is) throws IOException {
        byte[] b = new byte[65535];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (is.available() > 0) {
            int read = is.read(b);
            baos.write(b, 0, read);
        }
        is.close();
        b = baos.toByteArray();
        baos.close();
        return b;
    }

    public ArchiveResolver getArchiveConfigurationHandler(String mandant) {
        return ArchiveResolverFactory.getResolver(mandant);
    }

    public final String getWorkingDirectory(String mandant) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public final String getWorkingDirectory(String mandant, String orderId) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (orderId != null && orderId.length() > 0) {
            result.append(orderId);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public final void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public static FileSystemManager getFsManager() {
        return fsManager;
    }

    public static void setFsManager(FileSystemManager fsManager) {
        ActionEndpointComponent.fsManager = fsManager;
    }

    public boolean isCancelOnPreviousErrors() {
        return this.cancelOnPreviousErrors;
    }

    public void setCancelOnPreviousErrors(boolean cancelOnPreviousErrors) {
        this.cancelOnPreviousErrors = cancelOnPreviousErrors;
    }
}

