/*
 * Decompiled with CFR 0.152.
 */
package de.maas.jbi.helper;

import de.maas.jbi.helper.ServiceComponent;
import de.maas.jbi.helper.ServiceFatalException;
import de.maas.saas.archiver.ArchiveResolver;
import de.maas.saas.archiver.ArchiveResolverFactory;
import de.maas.saas.data.Action;
import de.maas.saas.data.Document;
import de.maas.saas.data.Order;
import de.maas.saas.utils.ActionStatus;
import de.maas.saas.utils.ActionUtils;
import de.maas.saas.utils.NMRXMLSerializer;
import de.maas.saas.utils.SaasUtils;
import de.maas.saas.utils.XMLSerializerException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActionServiceComponent
extends ServiceComponent {
    private static FileSystemManager fsManager;
    private String workingDirectory;
    private boolean cancelOnPreviousErrors = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws JBIException {
        Class<FileSystemManager> clazz = FileSystemManager.class;
        synchronized (FileSystemManager.class) {
            if (fsManager == null) {
                try {
                    fsManager = VFS.getManager();
                }
                catch (Exception exc) {
                    throw new JBIException(exc.getMessage(), (Throwable)exc);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            super.init();
            return;
        }
    }

    @Override
    protected final void messageExchange(MessageExchange exchange) throws MessagingException {
        block18: {
            boolean inOut = false;
            try {
                NormalizedMessage nmrMessage = null;
                if (exchange instanceof InOut) {
                    inOut = true;
                }
                if (!exchange.getStatus().equals(ExchangeStatus.ACTIVE)) break block18;
                if (exchange.getRole().equals(MessageExchange.Role.PROVIDER)) {
                    nmrMessage = this.getInMessage(exchange);
                } else if (exchange.getRole().equals(MessageExchange.Role.CONSUMER)) {
                    nmrMessage = this.getOutMessage(exchange);
                }
                try {
                    HashMap<String, DataHandler> attachments = null;
                    if (nmrMessage.getAttachmentNames().size() > 0) {
                        attachments = new HashMap<String, DataHandler>(nmrMessage.getAttachmentNames().size());
                        for (Object attName : nmrMessage.getAttachmentNames()) {
                            attachments.put((String)attName, nmrMessage.getAttachment((String)attName));
                        }
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Message is processing:" + exchange.getExchangeId()));
                    }
                    Object object = this.processRequest(nmrMessage, attachments);
                    if (inOut) {
                        this.answer((InOut)exchange, object, attachments);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"Message response sent");
                        }
                    } else {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"Message is sending to destination");
                        }
                        this.sendMessage(object, attachments);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"Message is sent");
                        }
                        this.done(exchange);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"Message is done");
                        }
                    }
                }
                catch (IOException e) {
                    this.getLog().error((Object)this, (Throwable)e);
                }
                catch (XMLSerializerException e) {
                    this.getLog().error((Object)this, (Throwable)e);
                }
            }
            catch (Exception fa) {
                this.getLog().error((Object)this, (Throwable)fa);
                throw new MessagingException((Throwable)fa);
            }
        }
    }

    private Object processRequest(NormalizedMessage nmr, Map<String, DataHandler> attachments) throws IOException, XMLSerializerException {
        Object dataObject = NMRXMLSerializer.readObject(Order.class, (NormalizedMessage)nmr);
        if (dataObject instanceof Order) {
            Order o;
            block14: {
                String actionName;
                o = (Order)dataObject;
                ActionUtils au = ActionUtils.findFirstAction((Order)o);
                String string = actionName = au.getFirstAction() == null ? "null" : au.getFirstAction().getName();
                if (this.isCancelOnPreviousErrors() && ActionUtils.hasErrors((ActionUtils)au)) {
                    this.getLog().warn(au.getParentOrder(), au.getParentProcess(), au.getFoundDocument(), null, "Action cancelled due to previous errors");
                    Action a = au.getFirstAction();
                    this.errorAction(a, "Action cancelled due to previous errors");
                    return o;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug(o, au.getFoundProcess(), au.getFoundDocument(), null, "First action:" + actionName);
                }
                try {
                    if (!au.getFirstAction().getName().equals(this.getEndpoint())) {
                        this.getLog().error(o, au.getFoundProcess(), au.getFoundDocument(), null, "Action is invalid for this service (action:" + au.getFirstAction().getName() + "<>" + this.getEndpoint() + ")");
                        if (this.getLog().isDebugEnabled() && au.getFoundDocument() != null) {
                            for (Action a : au.getFoundDocument().getActionList().getAction()) {
                                this.getLog().debug(o, au.getFoundProcess(), au.getFoundDocument(), null, a.toString());
                            }
                        }
                    } else {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug(o, null, null, null, "Process request");
                        }
                        if (attachments != null) {
                            this.processOrder(o, au, attachments);
                        } else {
                            this.processOrder(o, au);
                        }
                        if (ActionUtils.isActive((Action)au.getFirstAction())) {
                            this.doneAction(au.getFirstAction());
                        }
                    }
                }
                catch (Exception e) {
                    SaasUtils.printStatus(o, "Error", e.getMessage());
                    this.getLog().error(o, null, null, null, e.getMessage(), (Throwable)e);
                    if (ActionUtils.isActive((Action)au.getFirstAction())) {
                        this.errorAction(au.getFirstAction(), "Exception:" + e.getClass() + ", message:" + e.getMessage());
                    }
                    if (!ActionUtils.isDone((Action)au.getFirstAction())) break block14;
                    this.getLog().warn(o, null, null, null, "Fatal exception: changing status of action from done to error");
                    this.errorAction(au.getFirstAction(), "Exception:" + e.getClass() + ", message:" + e.getMessage());
                }
            }
            return o;
        }
        this.getLog().warn((Object)("Received message is not an order instance:" + (dataObject == null ? "null" : dataObject.getClass())));
        return dataObject;
    }

    protected abstract void processOrder(Order var1, ActionUtils var2) throws ServiceFatalException;

    protected final Action updateAction(Action a, String status, String description) {
        a.setStatus(ActionStatus.fromValue((String)status).value());
        a.setStatusDescription(description);
        a.setUpdateBy(this.getEndpoint() + ":" + this.getName());
        a.setUpdateDate(DateFormat.getDateTimeInstance().format(new Date()));
        return a;
    }

    protected final Action doneAction(Action a, String description) {
        return this.updateAction(a, ActionStatus.Done.value(), description);
    }

    protected final Action doneAction(Action a) {
        return this.updateAction(a, ActionStatus.Done.value(), "");
    }

    protected final Action errorAction(Action a, String description) {
        return this.updateAction(a, ActionStatus.Error.value(), description);
    }

    protected void processOrder(Order order, ActionUtils au, Map<String, DataHandler> attachments) throws ServiceFatalException {
        attachments.clear();
        this.getLog().warn(order, null, null, null, "Order contains attachments - using default processOrderImplementation");
        this.processOrder(order, au);
    }

    public final String getWorkingDirectory(String mandant) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public final String getWorkingDirectory(String mandant, String orderId) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (orderId != null && orderId.length() > 0) {
            result.append(orderId);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public final void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public List<URL> getDocumentFilesURLs(Order o, Document d) {
        List l;
        String mandant = o.getMandant();
        ArrayList<URL> al = new ArrayList<URL>();
        if (d.getTempFileNameList() != null && (l = d.getTempFileNameList().getTempFileName()) != null && l.size() > 0) {
            for (String name : l) {
                try {
                    al.add(new File(name).toURL());
                }
                catch (Exception e) {
                    this.getLog().error(o, null, d, null, e.getMessage(), (Throwable)e);
                }
            }
            return al;
        }
        if (d.getInputFileNameList() != null && d.getInputFileNameList().getInputFileName().size() > 0) {
            for (String s : d.getInputFileNameList().getInputFileName()) {
                try {
                    al.add(new URL(s));
                }
                catch (Exception e) {
                    this.getLog().error(o, null, d, null, e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            URL tmp = this.getArchiveConfigurationHandler(mandant).getArchiveURILocationAsURI(d.getId(), mandant).toURL();
            al.add(tmp);
        }
        catch (Exception e) {
            try {
                URL tmp = this.getArchiveConfigurationHandler(mandant).getArchiveURLLocation(d.getId(), mandant);
                al.add(tmp);
            }
            catch (Exception e1) {
                this.getLog().error(o, null, d, null, e.getMessage(), (Throwable)e);
                this.getLog().error(o, null, d, null, e1.getMessage(), (Throwable)e1);
            }
        }
        return al;
    }

    public static FileSystemManager getFsManager() {
        return fsManager;
    }

    public ArchiveResolver getArchiveConfigurationHandler(String mandant) {
        return ArchiveResolverFactory.getResolver(mandant);
    }

    protected final byte[] readFile(InputStream is) throws IOException {
        byte[] b = new byte[65535];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (is.available() > 0) {
            int read = is.read(b);
            baos.write(b, 0, read);
        }
        is.close();
        b = baos.toByteArray();
        baos.close();
        return b;
    }

    public boolean isCancelOnPreviousErrors() {
        return this.cancelOnPreviousErrors;
    }

    public void setCancelOnPreviousErrors(boolean cancelOnPreviousErrors) {
        this.cancelOnPreviousErrors = cancelOnPreviousErrors;
    }
}

