/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.access;

import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PDFDocumentPermission {
    DISSABLE_ALL(0, "Dissables all permissions"),
    CAN_PRINT_DEGRADED(1, "Allow Low resolution printing"),
    CAN_MODIFY(2, "Allow Changing the document"),
    CAN_EXTRACT(3, "Allow Content copying or extraction"),
    CAN_MODIFY_ANNOTATIONS(4, "Allow Authoring comments and form fields"),
    CAN_FILL_IN_FORM(5, "Allow Form field fill-in or signing"),
    CAN_EXTRACT_FOR_ACCESSIBILITY(6, "Allow Content accessibility"),
    CAN_ASSEMBLE_DOCUMENT(7, "Allow Document assembly"),
    CAN_PRINT(8, "Allow High Quality Printing");

    private static Hashtable<Integer, PDFDocumentPermission> permissionMap;
    private int permissionCode;
    private String permissionDescription;

    private PDFDocumentPermission(int permissionCode, String permissionDescription) {
        this.permissionCode = permissionCode;
        this.permissionDescription = permissionDescription;
    }

    public int getPermissionCode() {
        return this.permissionCode;
    }

    public String getPermissionDescription() {
        return this.permissionDescription;
    }

    public static PDFDocumentPermission getPDFDocumentPermission4code(int code) {
        return permissionMap.get(code);
    }

    static {
        permissionMap = new Hashtable();
        for (PDFDocumentPermission perm : PDFDocumentPermission.values()) {
            permissionMap.put(perm.getPermissionCode(), perm);
        }
    }
}

