/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.archiver;

import de.maas.saas.archiver.ArchiveResolver;
import de.maas.saas.config.ArchiveConfig;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ArchiveResolverFactory {
    private static final String ARCHIVE_CONFIG_FILE = "archive_resolver.xml";
    private static ArchiveConfig archiveConfig;

    private static void loadArchiveResolver() {
        XmlBeanFactory bf = new XmlBeanFactory((Resource)new ClassPathResource(ARCHIVE_CONFIG_FILE));
        archiveConfig = (ArchiveConfig)bf.getBean("archive-config");
        if (archiveConfig == null) {
            throw new NullPointerException("ArchiveConfig file resource not found in classpath:archive_resolver.xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchiveResolver getResolver() {
        Class<ArchiveResolverFactory> clazz = ArchiveResolverFactory.class;
        synchronized (ArchiveResolverFactory.class) {
            if (archiveConfig == null) {
                ArchiveResolverFactory.loadArchiveResolver();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return archiveConfig.getDefaultResolver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchiveResolver getResolver(String mandant) {
        Class<ArchiveResolverFactory> clazz = ArchiveResolverFactory.class;
        synchronized (ArchiveResolverFactory.class) {
            if (archiveConfig == null) {
                ArchiveResolverFactory.loadArchiveResolver();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return archiveConfig.getArchiveResolver(mandant);
        }
    }
}

