/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.saver;

import de.maas.saas.config.OrderSaverConfig;
import de.maas.saas.data.Order;
import de.maas.saas.db.DBException;
import de.maas.saas.db.SessionFactory;
import de.maas.saas.db.hibernate.HibernateDBConnection;
import de.maas.saas.saver.OrderSaverException;
import de.maas.saas.saver.OrderSaverInterface;
import de.maas.saas.saver.SavedOrder;
import de.maas.saas.saver.db.OrderPersisterConnection;
import de.maas.saas.saver.hibernate.DBOrderPersisterConnection;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchangeFactory;

public class DBOrderSaver
implements OrderSaverInterface {
    private OrderPersisterConnection orderPersister;
    private boolean compress = true;

    public DBOrderSaver(SessionFactory sf) throws DBException {
        this.setSessionFactory(sf);
    }

    public void saveOrder(String mandant, String orderId, String state, Order orderData, DeliveryChannel dc, MessageExchangeFactory mef) throws OrderSaverException {
        try {
            SavedOrder so = new SavedOrder();
            so.setMandant(mandant);
            so.setOrder(orderData);
            so.setOrderId(orderId);
            so.setState(state);
            this.orderPersister.saveOrder(so);
        }
        catch (Exception e) {
            throw new OrderSaverException("Can't save order to db", e);
        }
    }

    public void setConfig(OrderSaverConfig config) {
    }

    public void setSessionFactory(SessionFactory sessionFactory) throws DBException {
        if (sessionFactory != null) {
            this.orderPersister = new DBOrderPersisterConnection((HibernateDBConnection)sessionFactory.getNewConnection());
        }
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }
}

