/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.saver;

import de.maas.saas.config.OrderSaverConfig;
import de.maas.saas.config.OrderSaverEntry;
import de.maas.saas.data.Order;
import de.maas.saas.saver.OrderSaverException;
import de.maas.saas.saver.OrderSaverInterface;
import de.maas.saas.utils.NMRXMLSerializer;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchangeFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;

public class FileOrderSaver
implements OrderSaverInterface {
    private Map<String, String> destinations;
    private String defaultDestination;
    private FileSystemManager fsManager;
    private boolean useGZip = false;

    public void saveOrder(String mandant, String orderId, String state, Order orderData, DeliveryChannel dc, MessageExchangeFactory mef) throws OrderSaverException {
        String destURI = this.destinations.get(mandant);
        if (destURI == null) {
            destURI = this.defaultDestination;
        }
        if (destURI == null) {
            throw new OrderSaverException("Can't find folder for mandant:" + mandant);
        }
        String outName = orderId + "_" + mandant + "_" + state;
        if (this.useGZip) {
            try {
                FileObject fo = this.fsManager.resolveFile(destURI + "/" + outName + ".xml.gz");
                if (fo.exists()) {
                    int i = 1;
                    while (true) {
                        fo.close();
                        fo = this.fsManager.resolveFile(destURI + "/" + outName + "_" + i + ".xml.gz");
                        if (!fo.exists()) break;
                        ++i;
                    }
                }
                OutputStream os = fo.getContent().getOutputStream();
                GZIPOutputStream gzipOS = new GZIPOutputStream(os);
                NMRXMLSerializer.writeObject((Object)orderData, (OutputStream)gzipOS);
                gzipOS.close();
                os.close();
                fo.close();
            }
            catch (Exception e) {
                throw new OrderSaverException("Can't save order to a file", e);
            }
        }
        try {
            FileObject fo = this.fsManager.resolveFile(destURI + "/" + outName + ".xml");
            if (fo.exists()) {
                int i = 1;
                while (true) {
                    fo.close();
                    fo = this.fsManager.resolveFile(destURI + "/" + outName + "_" + i + ".xml");
                    if (!fo.exists()) break;
                    ++i;
                }
            }
            OutputStream os = fo.getContent().getOutputStream();
            NMRXMLSerializer.writeObject((Object)orderData, (OutputStream)os);
            os.close();
            fo.close();
        }
        catch (Exception e) {
            throw new OrderSaverException("Can't save order to a file", e);
        }
    }

    public void setConfig(OrderSaverConfig config) {
        this.destinations = new HashMap<String, String>();
        for (Map.Entry<String, OrderSaverEntry> e : config.getEntries().entrySet()) {
            this.destinations.put(e.getKey(), e.getValue().getSavedOrdersFolderURL());
        }
        if (config.getDefaultEntry() != null) {
            this.defaultDestination = config.getDefaultEntry().getSavedOrdersFolderURL();
        }
    }

    public FileSystemManager getFsManager() {
        return this.fsManager;
    }

    public void setFsManager(FileSystemManager fsManager) {
        this.fsManager = fsManager;
    }

    public boolean isUseGZip() {
        return this.useGZip;
    }

    public void setUseGZip(boolean useGZip) {
        this.useGZip = useGZip;
    }
}

