/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.xml.parsers.impl;

public class XPathExpressionBuilder {
    public String buildSelectElementExpression(boolean isChild, String ... nodeNames) {
        StringBuilder builder = new StringBuilder();
        boolean isFirstChild = isChild;
        for (String nodeName : nodeNames) {
            if (isFirstChild) {
                builder.append("child::");
                isFirstChild = false;
            } else {
                builder.append("/");
            }
            builder.append(nodeName);
        }
        return builder.toString();
    }

    public String buildCountElementExpression(boolean isChild, String ... nodeNames) {
        StringBuilder builder = new StringBuilder();
        builder.append("count(");
        boolean isFirstChild = isChild;
        for (String nodeName : nodeNames) {
            if (isFirstChild) {
                builder.append("child::");
                isFirstChild = false;
            } else {
                builder.append("/");
            }
            builder.append(nodeName);
        }
        builder.append(")");
        return builder.toString();
    }

    public String buildPositionElementExpression(boolean isChild, String[] nodeNames, int index, String ... afterNodeNames) {
        StringBuilder builder = new StringBuilder();
        boolean isFirstChild = isChild;
        for (String nodeName : nodeNames) {
            if (isFirstChild) {
                builder.append("child::");
                isFirstChild = false;
            } else {
                builder.append("/");
            }
            builder.append(nodeName);
        }
        builder.append("[").append(index + 1).append("]");
        if (afterNodeNames != null) {
            for (String nodeName : afterNodeNames) {
                builder.append("/").append(nodeName);
            }
        }
        return builder.toString();
    }

    public String buildSelectAttributeExpression(boolean isChild, String[] nodeNames, String attributeName) {
        StringBuilder builder = new StringBuilder();
        boolean isFirstChild = isChild;
        for (String nodeName : nodeNames) {
            if (isFirstChild) {
                builder.append("child::");
                isFirstChild = false;
            } else {
                builder.append("/");
            }
            builder.append(nodeName);
        }
        builder.append("/@").append(attributeName);
        return builder.toString();
    }

    public String buildPositionAttributeExpression(boolean isChild, String[] nodeNames, int index, String[] afterNodeNames, String attributeName) {
        StringBuilder builder = new StringBuilder();
        boolean isFirstChild = isChild;
        for (String nodeName : nodeNames) {
            if (isFirstChild) {
                builder.append("child::");
                isFirstChild = false;
            } else {
                builder.append("/");
            }
            builder.append(nodeName);
        }
        builder.append("[").append(index + 1).append("]");
        if (afterNodeNames != null) {
            for (String nodeName : afterNodeNames) {
                builder.append("/").append(nodeName);
            }
        }
        builder.append("/@").append(attributeName);
        return builder.toString();
    }
}

