// Generated by CoffeeScript 1.6.3
(function() {
  var VCache, ks, localCache, localCacheTTL, randomString, vs, _,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  _ = require("underscore");

  VCache = require("../lib/node_cache");

  localCache = new VCache({
    stdTTL: 0
  });

  localCacheTTL = new VCache({
    stdTTL: 0.3,
    checkperiod: 0
  });

  localCache._killCheckPeriod();

  randomString = function(length, withnumbers) {
    var chars, i, randomstring, rnum, string_length;
    if (withnumbers == null) {
      withnumbers = true;
    }
    chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    if (withnumbers) {
      chars += "0123456789";
    }
    string_length = length || 5;
    randomstring = "";
    i = 0;
    while (i < string_length) {
      rnum = Math.floor(Math.random() * chars.length);
      randomstring += chars.substring(rnum, rnum + 1);
      i++;
    }
    return randomstring;
  };

  vs = [];

  ks = [];

  module.exports = {
    "general": function(beforeExit, assert) {
      var key, n, start, value, value2;
      console.log("\nSTART GENERAL TEST");
      n = 0;
      start = _.clone(localCache.getStats());
      value = randomString(100);
      value2 = randomString(100);
      key = randomString(10);
      localCache.once("del", function(_key) {
        assert.equal(_key, key);
      });
      localCache.set(key, value, 0, function(err, res) {
        assert.isNull(err, err);
        n++;
        assert.equal(1, localCache.getStats().keys - start.keys);
        localCache.get(key, function(err, res) {
          var pred;
          n++;
          pred = {};
          pred[key] = value;
          assert.eql(pred, res);
        });
        localCache.keys(function(err, res) {
          var pred;
          n++;
          pred = [key];
          assert.eql(pred, res);
        });
        localCache.get("xxx", function(err, res) {
          n++;
          assert.isNull(err, err);
          assert.eql({}, res);
        });
        localCache.del("xxx", function(err, res) {
          n++;
          assert.isNull(err, err);
          assert.equal(0, res);
        });
        localCache.set(key, value2, 0, function(err, res) {
          n++;
          assert.isNull(err, err);
          assert.ok(res, err);
          localCache.get(key, function(err, res) {
            var pred;
            n++;
            pred = {};
            pred[key] = value2;
            assert.eql(pred, res);
            assert.equal(1, localCache.getStats().keys - start.keys);
          });
        });
        localCache.del(key, function(err, res) {
          localCache.removeAllListeners("del");
          n++;
          assert.isNull(err, err);
          assert.equal(1, res);
          assert.equal(0, localCache.getStats().keys - start.keys);
          localCache.get(key, function(err, res) {
            n++;
            assert.isNull(err, err);
            assert.eql({}, res);
          });
          localCache.set("zero", 0, 0, function(err, res) {
            n++;
            assert.isNull(err, err);
            assert.ok(res, err);
          });
          localCache.get("zero", function(err, res) {
            n++;
            assert.isNull(err, err);
            assert.eql({
              "zero": 0
            }, res);
          });
        });
      });
      beforeExit(function() {
        assert.equal(11, n, "not exited");
      });
    },
    "general sync": function(beforeExit, assert) {
      var key, pred, res, start, value, value2;
      console.log("\nSTART GENERAL TEST SYNC");
      localCache.flushAll();
      start = _.clone(localCache.getStats());
      value = randomString(100);
      value2 = randomString(100);
      key = randomString(10);
      localCache.once("del", function(_key) {
        assert.equal(_key, key);
      });
      assert.ok(localCache.set(key, value, 0));
      assert.equal(1, localCache.getStats().keys - start.keys);
      res = localCache.get(key);
      pred = {};
      pred[key] = value;
      assert.eql(pred, res);
      res = localCache.keys();
      pred = [key];
      assert.eql(pred, res);
      res = localCache.get("xxx");
      assert.eql({}, res);
      res = localCache.del("xxx");
      assert.equal(0, res);
      res = localCache.set(key, value2, 0);
      assert.ok(res, res);
      res = localCache.get(key);
      pred = {};
      pred[key] = value2;
      assert.eql(pred, res);
      assert.equal(1, localCache.getStats().keys - start.keys);
      res = localCache.del(key);
      localCache.removeAllListeners("del");
      assert.equal(1, res);
      assert.equal(0, localCache.getStats().keys - start.keys);
      res = localCache.get(key);
      assert.eql({}, res);
      res = localCache.set("zero", 0, 0);
      assert.ok(res, res);
      res = localCache.get("zero");
      assert.eql({
        "zero": 0
      }, res);
    },
    "flush": function(beforeExit, assert) {
      var count, i, key, n, startKeys, val, _i, _j, _len;
      console.log("\nSTART FLUSH TEST");
      n = 0;
      count = 100;
      startKeys = localCache.getStats().keys;
      ks = [];
      val = randomString(20);
      for (i = _i = 1; 1 <= count ? _i <= count : _i >= count; i = 1 <= count ? ++_i : --_i) {
        key = randomString(7);
        ks.push(key);
      }
      for (_j = 0, _len = ks.length; _j < _len; _j++) {
        key = ks[_j];
        localCache.set(key, val, 0, function(err, res) {
          n++;
          assert.isNull(err, err);
        });
      }
      assert.equal(localCache.getStats().keys, startKeys + count);
      localCache.flushAll(false);
      assert.equal(localCache.getStats().keys, 0);
      assert.eql(localCache.data, {});
      beforeExit(function() {
        assert.equal(n, count + 0);
      });
    },
    "many": function(beforeExit, assert) {
      var count, i, key, n, pred, time, val, _dur, _i, _j, _k, _len, _len1, _res;
      n = 0;
      count = 100000;
      console.log("\nSTART MANY TEST/BENCHMARK.\nSet, Get and check " + count + " elements");
      val = randomString(20);
      ks = [];
      for (i = _i = 1; 1 <= count ? _i <= count : _i >= count; i = 1 <= count ? ++_i : --_i) {
        key = randomString(7);
        ks.push(key);
      }
      time = new Date().getTime();
      for (_j = 0, _len = ks.length; _j < _len; _j++) {
        key = ks[_j];
        assert.ok(localCache.set(key, val, 0));
      }
      _dur = new Date().getTime() - time;
      console.log("BENCHMARK for SET:", "" + _dur + "ms", " ( " + (_dur / count) + "ms per item ) ");
      time = new Date().getTime();
      for (_k = 0, _len1 = ks.length; _k < _len1; _k++) {
        key = ks[_k];
        n++;
        pred = {};
        pred[key] = val;
        _res = localCache.get(key);
        assert.eql(pred, _res);
      }
      _dur = new Date().getTime() - time;
      console.log("BENCHMARK for GET:", "" + _dur + "ms", " ( " + (_dur / count) + "ms per item ) ");
      console.log("BENCHMARK STATS:", localCache.getStats());
      beforeExit(function() {
        var _keys, _stats;
        _stats = localCache.getStats();
        _keys = localCache.keys();
        assert.eql(_stats.keys, _keys.length);
        console.log(_stats);
        assert.eql(count - 10000 + 100, _keys.length);
        assert.equal(n, count);
      });
    },
    "delete": function(beforeExit, assert) {
      var count, i, n, ri, startKeys, _i, _j;
      console.log("\nSTART DELETE TEST");
      n = 0;
      count = 10000;
      startKeys = localCache.getStats().keys;
      for (i = _i = 1; 1 <= count ? _i <= count : _i >= count; i = 1 <= count ? ++_i : --_i) {
        ri = Math.floor(Math.random() * vs.length);
        localCache.del(ks[i], function(err, count) {
          n++;
          assert.isNull(err, err);
          return assert.equal(1, count);
        });
      }
      for (i = _j = 1; 1 <= count ? _j <= count : _j >= count; i = 1 <= count ? ++_j : --_j) {
        ri = Math.floor(Math.random() * vs.length);
        localCache.del(ks[i], function(err, count) {
          n++;
          assert.equal(0, count);
          return assert.isNull(err, err);
        });
      }
      assert.equal(localCache.getStats().keys, startKeys - count);
      beforeExit(function() {
        assert.equal(n, count * 2);
      });
    },
    "stats": function(beforeExit, assert) {
      var count, end, i, key, keys, n, start, val, vals, _i, _j, _k, _ref;
      console.log("\nSTART STATS TEST");
      n = 0;
      start = _.clone(localCache.getStats());
      count = 5;
      keys = [];
      vals = [];
      for (i = _i = 1, _ref = count * 2; 1 <= _ref ? _i <= _ref : _i >= _ref; i = 1 <= _ref ? ++_i : --_i) {
        key = randomString(7);
        val = randomString(50);
        keys.push(key);
        vals.push(val);
        localCache.set(key, val, 0, function(err, success) {
          n++;
          assert.isNull(err, err);
          return assert.ok(success);
        });
      }
      for (i = _j = 1; 1 <= count ? _j <= count : _j >= count; i = 1 <= count ? ++_j : --_j) {
        localCache.get(keys[i], function(err, res) {
          var pred;
          n++;
          pred = {};
          pred[keys[i]] = vals[i];
          assert.eql(pred, res);
          return assert.isNull(err, err);
        });
        localCache.del(keys[i], function(err, success) {
          n++;
          assert.isNull(err, err);
          return assert.ok(success);
        });
      }
      for (i = _k = 1; 1 <= count ? _k <= count : _k >= count; i = 1 <= count ? ++_k : --_k) {
        localCache.get("xxxx", function(err, res) {
          ++n;
          assert.isNull(err, err);
          return assert.eql({}, res);
        });
      }
      end = localCache.getStats();
      assert.equal(end.hits - start.hits, 5, "hits wrong");
      assert.equal(end.misses - start.misses, 5, "misses wrong");
      assert.equal(end.keys - start.keys, 5, "hits wrong");
      assert.equal(end.ksize - start.ksize, 5 * 7, "hits wrong");
      assert.equal(end.vsize - start.vsize, 5 * 50, "hits wrong");
      return beforeExit(function() {
        return assert.equal(n, count * 5);
      });
    },
    "multi": function(beforeExit, assert) {
      var count, getKeys, i, key, n, pred, startKeys, val, _i, _j, _k, _len, _len1;
      console.log("\nSTART MULTI TEST");
      n = 0;
      count = 100;
      startKeys = localCache.getStats().keys;
      ks = [];
      val = randomString(20);
      for (i = _i = 1; 1 <= count ? _i <= count : _i >= count; i = 1 <= count ? ++_i : --_i) {
        key = randomString(7);
        ks.push(key);
      }
      for (_j = 0, _len = ks.length; _j < _len; _j++) {
        key = ks[_j];
        localCache.set(key, val, 0, function(err, res) {
          n++;
          assert.isNull(err, err);
        });
      }
      getKeys = ks.splice(50, 5);
      pred = {};
      for (_k = 0, _len1 = getKeys.length; _k < _len1; _k++) {
        key = getKeys[_k];
        pred[key] = val;
      }
      localCache.get(getKeys, function(err, res) {
        n++;
        assert.isNull(err, err);
        return assert.eql(pred, res);
      });
      localCache.del(getKeys, function(err, res) {
        n++;
        assert.isNull(err, err);
        return assert.equal(getKeys.length, res);
      });
      localCache.get(getKeys, function(err, res) {
        n++;
        assert.isNull(err, err);
        return assert.eql({}, res);
      });
      return beforeExit(function() {
        return assert.equal(n, count + 3);
      });
    },
    "ttl": function(beforeExit, assert) {
      var key, key2, key3, key4, key5, n, val, _keys;
      console.log("\nSTART TTL TEST");
      val = randomString(20);
      key = "k1_" + randomString(7);
      key2 = "k2_" + randomString(7);
      key3 = "k3_" + randomString(7);
      key4 = "k4_" + randomString(7);
      key5 = "k5_" + randomString(7);
      _keys = [key, key2, key3, key4, key5];
      n = 0;
      localCache.set(key, val, 0.5, function(err, res) {
        assert.isNull(err, err);
        assert.ok(res);
        return localCache.get(key, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key] = val;
          return assert.eql(pred, res);
        });
      });
      localCache.set(key2, val, 0.3, function(err, res) {
        assert.isNull(err, err);
        assert.ok(res);
        return localCache.get(key2, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key2] = val;
          return assert.eql(pred, res);
        });
      });
      setTimeout(function() {
        ++n;
        return localCache.get(key, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key] = val;
          return assert.eql(pred, res);
        });
      }, 400);
      setTimeout(function() {
        ++n;
        return localCache.get(key, function(err, res) {
          assert.isNull(err, err);
          return assert.eql({}, res);
        });
      }, 600);
      setTimeout(function() {
        ++n;
        return localCache.get(key2, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key2] = val;
          assert.eql(pred, res);
          return assert.eql(pred, res);
        });
      }, 250);
      setTimeout(function() {
        return process.nextTick(function() {
          var startKeys, _testExpired, _testSet,
            _this = this;
          startKeys = localCache.getStats().keys;
          key = "autotest";
          _testExpired = function(_key, _val) {
            if (__indexOf.call(_keys, _key) < 0) {
              assert.equal(_key, key);
              assert.equal(_val, val);
            }
          };
          _testSet = function(_key) {
            assert.equal(_key, key);
          };
          localCache.once("set", _testSet);
          return localCache.set(key, val, 0.5, function(err, res) {
            assert.isNull(err, err);
            assert.ok(res);
            assert.equal(startKeys + 1, localCache.getStats().keys);
            return localCache.get(key, function(err, res) {
              var pred;
              pred = {};
              pred[key] = val;
              assert.eql(pred, res);
              localCache.on("expired", _testExpired);
              return setTimeout(function() {
                localCache._checkData(false);
                assert.isUndefined(localCache.data[key]);
                localCache.removeAllListeners("set");
                return localCache.removeAllListeners("expired");
              }, 700);
            });
          });
        });
      }, 1000);
      localCache.set(key3, val, 100, function(err, res) {
        assert.isNull(err, err);
        assert.ok(res);
        return localCache.get(key3, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key3] = val;
          assert.eql(pred, res);
          localCache.ttl(key3 + "false", 0.3, function(err, setted) {
            assert.isNull(err, err);
            return assert.equal(false, setted);
          });
          localCache.ttl(key3, 0.3, function(err, setted) {
            assert.isNull(err, err);
            return assert.ok(setted);
          });
          localCache.get(key3, function(err, res) {
            pred = {};
            pred[key3] = val;
            return assert.eql(pred, res);
          });
          return setTimeout(function() {
            assert.eql(localCache.get(key3), {});
            assert.isUndefined(localCache.data[key3]);
          }, 500);
        });
      });
      localCache.set(key4, val, 100, function(err, res) {
        assert.isNull(err, err);
        assert.ok(res);
        return localCache.get(key4, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key4] = val;
          assert.eql(pred, res);
          localCache.ttl(key4 + "false", function(err, setted) {
            assert.isNull(err, err);
            return assert.equal(false, setted);
          });
          return localCache.ttl(key4, function(err, setted) {
            assert.isNull(err, err);
            assert.ok(setted);
            return assert.isUndefined(localCache.data[key4]);
          });
        });
      });
      return localCacheTTL.set(key5, val, 100, function(err, res) {
        assert.isNull(err, err);
        assert.ok(res);
        return localCacheTTL.get(key5, function(err, res) {
          var pred;
          assert.isNull(err, err);
          pred = {};
          pred[key5] = val;
          assert.eql(pred, res);
          localCacheTTL.ttl(key5 + "false", function(err, setted) {
            assert.isNull(err, err);
            return assert.equal(false, setted);
          });
          localCacheTTL.ttl(key5, function(err, setted) {
            assert.isNull(err, err);
            return assert.ok(setted);
          });
          localCacheTTL.get(key5, function(err, res) {
            pred = {};
            pred[key5] = val;
            return assert.eql(pred, res);
          });
          return setTimeout(function() {
            assert.eql(localCache.get(key5), {});
            localCacheTTL._checkData(false);
            return assert.isUndefined(localCacheTTL.data[key5]);
          }, 500);
        });
      });
    }
  };

}).call(this);
