let path				= require('path')

module.exports = {
    "desc": 	"qpdf oxsnps plugin",
    "enable": 	"on",
	"log": {
		// Available Log Levels are DEBUG, INFO, WARN and ERROR
		"level": process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL_OXSNPS_QPDF"] ||
				process.env[process.env.OXSNPS_SERVER_PREFIX + "LOG_LEVEL"] ||
				"WARN"
	},
    "routes": [
		{
			"path":		"/services/qpdf/version",
			"method":	"get",
			"service":	"version"
		},
		{	
			"path":		"/services/qpdf/conf",
			"method":	"get",
			"service":	"conf"
		},
		{
			"path":		"/services/qpdf/conf",
			"method":	"post",
			"service":	"conf"
		},
		{
			"path":		"/services/qpdf/process",
			"method":	"post",
			"service":	"process"
		},
		{
			"path":		"/services/qpdf/process",
			"method":	"get",
			"service":	"process"
		}
    ],
    "middlewares":[
        {
            "name": "body-parser",
            "handler": "json",
            "routes":[
                {
                    "path": ["/services/qpdf/*"],
                    "parms": {"limit": "1mb"}  
                }
            ]
        },
		// V4.0.4
        {
			// Add static route for oxsnps-assert plugin
			"name": "express",
            "handler": "static",
            "routes":[
                {
                    "path": ["/oxsnps-qpdf/api"],							// define http://<host>:<port>/api to map to the physical dir defined below
                    "parms": path.join(__dirname, '..', 'swagger') 	// physical dir where the files to be served are located (i.e. oxs-xxx-server/node_modules/rest.ish/swagger)
                }
            ]
        }        
		
    ],
    // V3.0.2
    defaultArgs: process.env.OXSNPS_SERVER_PREFIX + "DEFAULT_QPDF_ARGS"
    // V3.0.2
}
