*   [Overview](#overview)
*   [Installation](#installation)
*   [Configuration](#configuration)
*   [Dependencies](#dependencies)
*   [Routes](#routes)
*   [Services](#services)
    *   [Sync.Transformation](#syncTransformation)
        *   [Request](#stReq)
        *   [Response](#stRes)
    *   [Async.Transformation](#asyncTransformation)
        *   [Request](#atReq)
        *   [Response](#atRes)
    *   [Job Status](#jobStatus)
        *   [Request](#jsReq)
        *   [Response](#jsRes)
*   [Download](#download)

<a name="overview"></a>
<h2 id="overview">Overview</h2>

  * Plugin to manage SOAP transformation requests
  * Run npm install before running any grunt tasks for the plugin
  * Run 'grunt' to get list of grunt tasks

<a name="installation"></a>
<h2 id="installation">Installation</h2>

Plugin can be installed using Node Package Manager (`npm`):
```bash
    npm install soap
```

<a name="configuration"></a>
<h2 id="configuration">Configuration</h2>

Plugin configuration is maintained in conf/soap.json. It contains the following properties.

|Property Name|Description|
|:--:|:--|
|module|Name of the plugin.|
|desc|Optional. Short description of the plugin.|
|longDesc|Optional. Long description of the plugin.|
|enable|Optional. Enable the plugin. Allowed values are 'on'\|'off'.  Default is 'on'.|
|logLevel|Optional. Logging Level. Available Log Levels are DEBUG, INFO and ERROR. Default is 'INFO'|
|routes|An array of routes.|

### soap.json

```json
{
  "module":   "Name of the plugin module",
  "module":   "soap",
  "desc":     "OXSNPS soap Plugin",
  "longDesc": "OXSEED NodeJS Server soap Plugin",
  "enable":   "on",
  "logLevel": "Available Log Levels are DEBUG, INFO and ERROR",
  "logLevel": "DEBUG",      
  "props":  null,
  "routes": [
    {
      "path":     "/services/soap/version",
      "method":   "post",
      "service":  "version"
    },  
    {
      "path":     "/services/soap/transform",
      "method":   "post",
      "service":  "syncTransform"
    },
    {
      "path":     "/services/soap/asynctransform",
      "method":   "post",
      "service":  "asyncTransform"
    },
    {
      "path":     "/services/soap/status",
      "method":   "post",
      "service":  "status"
    }
  ]
}
```
<a name="dependencies"></a>
<h2 id="dependencies">Dependencies</h2>

  * async
  * cheerio
  * fs
  * log4js
  * os
  * path
  * xml2js

<a name="routes"></a>
<h2 id="routes">Routes</h2>

|Path|Description|
|:--:|:--|
|/services/soap/version|Gets version of soap plugin|
|/services/soap/transform|Used for synchronous transformation.|
|/services/soap/asynctransform|Start an asynchronous transformation.|
|/services/soap/status|Get the status of an asynchronous transformation.|

<a name="services"></a>
<h2 id="services">Services</h2>

<a name="syncTransformation"></a>
<h3 id="syncTransformation">Sync.Transformation</h3>

 * Used for synchronous transformation

<a name="stReq"></a>
<h4 id="stReq">Request</h4>

|Name|Value|
|:--:|:--|
|Method|Post|
|URL|http://&lt;server&gt;[:&lt;port&gt;]/services/soap/transform|
|Content-Type|application/json|
|Parameters|Transform SOAP Request Object as given below|

```xml
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
  <soapenv:Header/>
  <soapenv:Body>
    <ns1:transform xmlns:ns1="http://oxseed.com/services/">
      <ns1:RequestTransformMessage>
        <input xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="ns1:InputObjectTransform">
          <type>InputType</type>
          <document>DocumentData</document>
          <ownerpw>OwnerPassword</ownerpw>
          <userpw>UserPassword</userpw>
        </input>
        <output>
          <type>OutputType</type>
          <ownerpw>OwnerPassword</ownerpw>
          <userpw>UserPassword</userpw>
          <flags>PDFPermissionFlags</flags>
        </output>
      </ns1:RequestTransformMessage>
    </ns1:transform>
  </soapenv:Body>
</soapenv:Envelope>
```
##### Request Parameter Notes

 * \<input\>\<type\> is type of input document. 
 * \<input\>\<document\> is data of the input document, encoded in base64.
 * \<input\>\<ownerpw\> is owner password of the input document. Applicable only for PDF input type.
 * \<input\>\<userpw\> is user password of the input document. Applicable only for PDF input type.
 * \<output\>\<type\> is type of output document.
 * \<output\>\<ownerpw\> is owner password of the output document. Applicable only for PDF output type.
 * \<output\>\<userpw\> is user password of the output document. Applicable only for PDF output type.
 * \<output\>\<flags\> is permission flags applied on output pdf document. Values are separated by '|'.  Refer to [Permission Flags Table](#flags).

<a name="flags"></a>

##### PDF Permission Flags

|Flag|Description|
|:--:|:--|
|0| Disables all permissions|
|1| Allow low resolution printing|
|2| Allow changing the document|
|3| Allow content copying or extraction|
|4| Allow authoring comments and form fields|
|5| Allow form field fill-in or signing|
|6| Allow content accessibility|
|7| Allow document assembly|
|8| Allow high quality printing|

<a name="stRes"></a>
<h4 id="stRes">Response</h4>

```xml
<soap:Envelope 
  xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" 
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
  xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <soap:Header/>
   <soap:Body>
      <ox:ResponseMessage xmlns:ox="http://oxseed.com/services/">
         <responseData>Output Data</responseData>
         <responseStatus>Status(Done|Error)</responseStatus>
         <responseStatusDescription/>
      </ox:ResponseMessage>
   </soap:Body>
</soap:Envelope>
```

<a name="asyncTransformation"></a>
<h3 id="asyncTransformation">Async.Transformation</h3>

 * Used for asynchronous transformation

<a name="atReq"></a>
<h4 id="atReq">Request</h4>

|Name|Value|
|:--:|:--|
|Method|Post|
|URL|http://&lt;server&gt;[:&lt;port&gt;]/services/soap/asynctransform|
|Content-Type|application/json|
|Parameters|Transform SOAP Request Object as given below|

```xml
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://oxseed.com/services/">
   <soapenv:Header/>
   <soapenv:Body>
      <ser:RequestTransformMessage>
         <input>
            <ownerpw></ownerpw>
            <userpw></userpw>
            <document>AFP Spool file name encoded as base64</document>
            <type>asyncafp</type>
         </input>
         <output>
            <type>pdf</type>
            <ownerpw></ownerpw>
            <userpw></userpw>
            <flags></flags>
         </output>
      </ser:RequestTransformMessage>
   </soapenv:Body>
</soapenv:Envelope>
```

##### Request Parameter Notes

 * \<input\>\<type\> is always 'asyncafp'
 * \<input\>\<document\> is AFP Spool file name encoded as base64
 * \<output\>\<type\> is always 'pdf'
 * \<output\>\<ownerpw\> is owner password of the output document. Applicable only for PDF output type.
 * \<output\>\<userpw\> is user password of the output document. Applicable only for PDF output type.
 * \<output\>\<flags\> is permission flags applied on output pdf document. Values are separated by '|'.  Refer to [Permission Flags Table](#flags).

<a name="atRes"></a>
<h4 id="atRes">Response</h4>

```xml
<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <soap:Header/>
   <soap:Body>
      <ox:ResponseMessage xmlns:ox="http://oxseed.com/services/">
         <responseData>Job id encoded as base64</responseData>
         <responseStatus>Job Status(Done|Error|Working)</responseStatus>
         <responseStatusDescription/>
      </ox:ResponseMessage>
   </soap:Body>
</soap:Envelope>
```

<a name="jobstatus"></a>
<h3 id="jobstatus">Job Status</h3>

 * Get the status of an asynchronous transformation.

<a name="jsReq"></a>
<h4 id="jsReq">Request</h4>

|Name|Value|
|:--:|:--|
|Method|Post|
|URL|http://&lt;server&gt;[:&lt;port&gt;]/services/soap/status|
|Content-Type|application/json|
|Parameters|Transform SOAP Request Object as given below|

```xml
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://oxseed.com/services/">
   <soapenv:Header/>
   <soapenv:Body>
      <ser:RequestTransformMessage>
         <input>
            <document>Job id encoded as base64</document>
            <type>asyncafp</type>
         </input>
         <output>
            <type>status</type>
         </output>
      </ser:RequestTransformMessage>
   </soapenv:Body>
</soapenv:Envelope>
```

##### Request Parameter Notes

 * \<input\>\<type\> is always 'asyncafp'
 * \<input\>\<document\> Job id encoded as base64
 * \<output\>\<type\> is always 'status'

<a name="jsRes"></a>
<h4 id="jsRes">Response</h4>

```xml
<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
   <soap:Header/>
   <soap:Body>
      <ox:ResponseMessage xmlns:ox="http://oxseed.com/services/">
         <responseData>Job id encoded as base64</responseData>
         <responseStatus>Job Status(Done|Error|Working)</responseStatus>
         <responseStatusDescription/>
      </ox:ResponseMessage>
   </soap:Body>
</soap:Envelope>
```
<a name="download"></a>
<h2 id="download">Download</h2>

The source is available for download from
[SVN](https://development.oxseed.net/svn/AFP2web/OXSNPS/base/plugins/soap/trunk).