/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

class Debug {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2006, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean _debug = false;
    private static String _outFilename = null;
    private static OutputStream _outputStream;
    private static PrintWriter _printWriter;

    Debug() {
    }

    public static void enableOutput(String string) {
        _debug = true;
        _outFilename = string;
        _outputStream = null;
        _printWriter = null;
    }

    public static void disableOutput() {
        _debug = false;
    }

    public static boolean outputEnabled() {
        return _debug;
    }

    public static void println() {
        if (!_debug) {
            return;
        }
        System.out.println();
        PrintWriter printWriter = Debug.getPrintWriter();
        if (printWriter != null) {
            printWriter.println();
        }
    }

    public static void println(String string) {
        if (!_debug) {
            return;
        }
        System.out.println(string);
        PrintWriter printWriter = Debug.getPrintWriter();
        if (printWriter != null) {
            printWriter.println(string);
        }
    }

    public static void printException(Throwable throwable) {
        if (!_debug) {
            return;
        }
        throwable.printStackTrace(System.out);
        PrintWriter printWriter = Debug.getPrintWriter();
        if (printWriter != null) {
            throwable.printStackTrace(printWriter);
        }
    }

    public static void printSystemProperties() {
        if (!_debug) {
            return;
        }
        System.getProperties().list(System.out);
        PrintWriter printWriter = Debug.getPrintWriter();
        if (printWriter != null) {
            System.getProperties().list(printWriter);
        }
    }

    private static PrintWriter getPrintWriter() {
        if (_outputStream == null && _outFilename != null) {
            try {
                _outputStream = new FileOutputStream(_outFilename);
                _printWriter = new PrintWriter(_outputStream, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _printWriter;
    }
}

