/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.lex.lapapp.Debug;
import com.ibm.lex.lapapp.LAP;
import com.ibm.lex.lapapp.LAPConstants;
import com.ibm.lex.lapapp.LicenseAcceptanceProcess;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class License {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String laPath;
    private Hashtable LAs = new Hashtable(3, 1.0f);
    private static final String SUMMARY_ERROR_MSG = "NOTICE: One or more of the IBM license agreement files were not created properly because the correct JRE was not used.  You may view the IBM license agreement that applies to this product in the language of your choice at http://www-3.ibm.com/software/sla/sladb.nsf.  This error will not harm the functionality of this product.";

    public License(String string) {
        this.laPath = string;
    }

    public static void copyLicense(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException {
        char[] cArray = new char[2048];
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        int n = 0;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Unicode"));
        bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string4));
        while ((n = bufferedReader.read(cArray)) != -1) {
            bufferedWriter.write(cArray, 0, n);
        }
        bufferedReader.close();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "Unicode"));
            while ((n = bufferedReader.read(cArray)) != -1) {
                bufferedWriter.write(cArray, 0, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        bufferedWriter.newLine();
        bufferedReader.close();
        bufferedWriter.close();
    }

    public String[] getLicense(Locale locale) throws MalformedURLException, FileNotFoundException, IOException {
        try {
            return this.getLicenseAgreement(locale);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (locale.equals(LAPConstants.DEFAULT_LOCALE)) {
                throw fileNotFoundException;
            }
            return this.getLicense(LAPConstants.DEFAULT_LOCALE);
        }
        catch (IOException iOException) {
            if (locale.equals(LAPConstants.DEFAULT_LOCALE)) {
                throw iOException;
            }
            return this.getLicense(LAPConstants.DEFAULT_LOCALE);
        }
    }

    String[] getLicenseAgreement(Locale locale) throws FileNotFoundException, MalformedURLException, IOException {
        if (this.LAs.containsKey(locale)) {
            return (String[])this.LAs.get(locale);
        }
        return this.retrieveLicenseAgreement(locale);
    }

    public static Locale getLocale(String string) {
        try {
            String string2 = null;
            String string3 = "";
            String string4 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            string2 = stringTokenizer.nextToken().trim();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().trim();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken().trim();
            }
            return new Locale(string2, string3, string4);
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("An error occurred with the locCode: Using default English Locale");
            return Locale.US;
        }
    }

    private static String getShortName(String string, String string2) {
        String string3 = string;
        if (!string2.equals("")) {
            string3 = string + "_" + string2;
        }
        if (string3.length() > 8) {
            string3 = string3.substring(0, 8);
        }
        return string3;
    }

    public boolean isLicenseAvailable(Locale locale) {
        boolean bl = true;
        String string = null;
        File file = null;
        String string2 = locale.toString();
        string = this.laPath + File.separator + "LA" + "_" + string2;
        file = new File(string);
        if (!file.exists()) {
            System.out.println("Missing " + string);
            bl = false;
        }
        if (!(file = new File(string = this.laPath + File.separator + "LI" + "_" + string2)).exists()) {
            System.out.println("Missing " + string);
            bl = false;
        }
        return bl;
    }

    public boolean licenseExists(Locale[] localeArray) {
        boolean bl = true;
        for (int i = 0; i < localeArray.length; ++i) {
            if (this.isLicenseAvailable(localeArray[i])) continue;
            bl = false;
        }
        if (!bl) {
            System.out.println("Error: Missing one or more required license files.");
        }
        return bl;
    }

    private String[] retrieveLicenseAgreement(Locale locale) throws FileNotFoundException, MalformedURLException, IOException {
        String string = locale.toString();
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            if (string.indexOf("_") != -1 && string.indexOf("zh_TW") == -1) {
                string = string.substring(0, string.indexOf("_"));
            }
            String string2 = this.laPath + File.separator + "LA" + "_" + string;
            fileInputStream = new FileInputStream(new File(string2));
            string2 = this.laPath + File.separator + "LI" + "_" + string;
            fileInputStream2 = new FileInputStream(new File(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Vector<String> vector = new Vector<String>(100);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream, "Unicode"));
        while (bufferedReader.ready()) {
            vector.addElement(bufferedReader.readLine());
        }
        bufferedReader.close();
        if (fileInputStream2 != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream2, "Unicode"));
            while (bufferedReader.ready()) {
                vector.addElement(bufferedReader.readLine());
            }
            bufferedReader.close();
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.LAs.put(locale, objectArray);
        return objectArray;
    }

    public static void writeLicense(LAP lAP, String string, String string2, String string3) {
        License.writeLicense(lAP, string, string2, string3, false);
    }

    public static void writeLicense(LAP lAP, String string, String string2, String string3, boolean bl) {
        Locale locale = new Locale("", "");
        ResourceBundle resourceBundle = null;
        locale = LicenseAcceptanceProcess.getOSLocale();
        try {
            resourceBundle = ResourceBundle.getBundle(string3, locale);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.out.println("Error: Missing encoding bundle. Aborted.");
        }
        Locale[] localeArray = lAP.getSupportedLanguages().getSupportedLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale2 = localeArray[i];
            String string4 = locale2.toString();
            String string5 = resourceBundle.getString(string4);
            String string6 = locale2.getDisplayLanguage(Locale.ENGLISH);
            String string7 = string + File.separator + "LA" + "_" + string4;
            String string8 = string + File.separator + "LI" + "_" + string4;
            String string9 = bl ? string2 + File.separator + "LA" + "_" + string4 + ".txt" : (locale2.getCountry().equals("") ? (string6.equalsIgnoreCase("chinese") && System.getProperty("os.name").equalsIgnoreCase("os/2") ? string2 + File.separator + "S" + string6 + ".txt" : string2 + File.separator + string6 + ".txt") : (System.getProperty("os.name").equalsIgnoreCase("os/2") ? string2 + File.separator + "T" + string6 + ".txt" : string2 + File.separator + string6 + "_" + locale2.getCountry() + ".txt"));
            try {
                License.copyLicense(string7, string8, string9, string5);
                continue;
            }
            catch (Exception exception) {
                Debug.println("error copying license 1 " + string9 + "-" + exception.getMessage());
                try {
                    License.copyLicense(string7, string8, string9, "Unicode");
                    continue;
                }
                catch (Exception exception2) {
                    Debug.println("error copying license 2 " + string9 + "-" + exception2.getMessage());
                    string9 = string2 + File.separator + License.getShortName(string6, locale2.getCountry()) + ".txt";
                    try {
                        License.copyLicense(string7, string8, string9, "Unicode");
                        continue;
                    }
                    catch (IOException iOException) {
                        Debug.println("error copying license 3 " + string9 + "-" + iOException.getMessage());
                        System.out.println(SUMMARY_ERROR_MSG);
                    }
                }
            }
        }
    }
}

