/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.lex.lapapp.LAP;
import com.ibm.lex.lapapp.License;
import com.ibm.lex.lapapp.resource.LAPResources;
import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class LicenseAcceptanceProcess {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String laPath;
    private String mPath;
    private String statusPath;
    private LAP lapMan;
    private boolean noExportLA = false;
    private LAPResources lapResources;
    private License license;
    private Locale currentLocale;
    private Locale preferredLocale;
    private Locale defaultLocale;

    public LicenseAcceptanceProcess(LAP lAP, String string, String string2, String string3, Locale locale) {
        this.lapMan = lAP;
        this.laPath = string;
        this.mPath = string2;
        this.statusPath = string3;
        this.initialize(locale);
    }

    private void accept() {
        File file;
        String string = this.getExportPathName();
        this.createExportDir();
        LAP lAP = this.lapMan;
        String string2 = System.getProperty("os.name");
        boolean bl = false;
        if (string2.equalsIgnoreCase("AIX") && lAP.getRegister() && (file = new File("/usr/sbin/inulag")).exists()) {
            bl = true;
        }
        if (!this.noExportLA) {
            License.writeLicense(this.lapMan, this.laPath, string, "com.ibm.lex.lapapp.encoding.Encoding", bl);
        }
        this.writeExtraFiles();
        try {
            LicenseAcceptanceProcess.putStatus(string, 9);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.notifyLAPManager(15);
        }
        try {
            LicenseAcceptanceProcess.putStatus(this.mPath, 9);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            this.register();
        }
        this.notifyLAPManager(9);
    }

    void changePreferredLocale() {
        if (!this.license.isLicenseAvailable(this.preferredLocale)) {
            this.currentLocale = this.preferredLocale = this.defaultLocale;
        }
    }

    public static void copyStatus(String string, String string2) throws FileNotFoundException, IOException {
        int n;
        FileReader fileReader = new FileReader(string + File.separator + "status.dat");
        FileWriter fileWriter = new FileWriter(string2 + File.separator + "status.dat");
        char[] cArray = new char[512];
        while ((n = fileReader.read(cArray)) >= 0) {
            fileWriter.write(cArray, 0, n);
        }
        fileWriter.close();
        fileReader.close();
    }

    private void createExportDir() {
        File file = new File(this.getExportPathName());
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private void decline() {
        this.notifyLAPManager(3);
    }

    public static boolean deleteStatus(String string) throws SecurityException {
        File file = new File(string + File.separator + "status.dat");
        return file.delete();
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public String getExportPathName() {
        return this.statusPath + File.separator + "license";
    }

    public LAP getLAP() {
        return this.lapMan;
    }

    public LAPResources getLAPResources() {
        if (this.lapResources == null && this.laPath != null) {
            this.lapResources = new LAPResources(this.laPath);
        }
        return this.lapResources;
    }

    public License getLicense() {
        return this.license;
    }

    public String[] getLicenseAgreement() {
        return this.getLicenseAgreement(this.currentLocale);
    }

    public String[] getLicenseAgreement(Locale locale) {
        String[] stringArray = null;
        try {
            stringArray = this.license.getLicense(locale);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.notifyLAPManager(11);
        }
        catch (IOException iOException) {
            this.notifyLAPManager(11);
        }
        if (stringArray == null) {
            this.notifyLAPManager(11);
        }
        return stringArray;
    }

    public String[] getNonIBMText() {
        Object[] objectArray = null;
        try {
            String string = new String(this.laPath + File.separator + "non_ibm_license");
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            Vector<String> vector = new Vector<String>(100);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Unicode"));
            while (bufferedReader.ready()) {
                vector.addElement(bufferedReader.readLine());
            }
            bufferedReader.close();
            vector.trimToSize();
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Exception exception) {
            objectArray = new String[]{"Could not open non-IBM terms."};
        }
        return objectArray;
    }

    public boolean hasNonIBMFile() {
        String string = new String(this.laPath + File.separator + "non_ibm_license");
        File file = new File(string);
        return file.exists();
    }

    public String[] getLicenseAgreementPrint() {
        return this.getLicenseAgreementPrint(this.currentLocale);
    }

    public String[] getLicenseAgreementPrint(Locale locale) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        try {
            objectArray = this.license.getLicense(locale);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    vector.addElement(objectArray[i]);
                }
            }
            if (this.hasNonIBMFile()) {
                vector.addElement(new String());
                String[] stringArray = this.getNonIBMText();
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement(stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Locale getNextLocale() {
        if (this.currentLocale.equals(this.defaultLocale)) {
            return this.preferredLocale;
        }
        return this.defaultLocale;
    }

    public static Locale getOSLocale() {
        String string = System.getProperty("os.name");
        if (string == null) {
            string = "";
        } else {
            string = string.replace(' ', '_').toLowerCase();
            string = string.replace('/', '_');
            string = string.replace('-', '_');
        }
        return new Locale(string, "");
    }

    public int getStatus() {
        String string = this.getExportPathName();
        int n = 1;
        if (this.mPath != null) {
            try {
                n = LicenseAcceptanceProcess.getStatus(this.mPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n == 9) {
                this.createExportDir();
                if (!this.noExportLA) {
                    License.writeLicense(this.lapMan, this.laPath, string, "com.ibm.lex.lapapp.encoding.Encoding");
                }
                this.writeExtraFiles();
                try {
                    LicenseAcceptanceProcess.copyStatus(this.mPath, string);
                    return 9;
                }
                catch (IOException iOException) {
                    System.out.println("Warning. One or more of the license agreement files may not be properly created.");
                    return 9;
                }
            }
        }
        int n2 = 1;
        try {
            n2 = LicenseAcceptanceProcess.getStatus(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n2 == 9) {
            return 9;
        }
        return Math.max(n, n2);
    }

    private void writeExtraFiles() {
        String string = ResourceBundle.getBundle("com.ibm.lex.lapapp.encoding.Encoding", LicenseAcceptanceProcess.getOSLocale()).getString(SupportedLanguages.ENGLISH.toString());
        try {
            License.copyLicense(this.laPath + File.separator + "non_ibm_license", null, this.getExportPathName() + File.separator + "non_ibm_license" + ".txt", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            License.copyLicense(this.laPath + File.separator + "notices", null, this.getExportPathName() + File.separator + "notices" + ".txt", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getStatus(String string) throws IOException {
        String string2 = LicenseAcceptanceProcess.getValue(string, "Status");
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LicenseAcceptanceProcess.deleteStatus(string);
        return 1;
    }

    public SupportedLanguages getSupportedLanguages() {
        return this.lapMan.getSupportedLanguages();
    }

    private static String getValue(String string, String string2) throws IOException {
        String string3 = null;
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string + File.separator + "status.dat");
        properties.load(fileInputStream);
        string3 = properties.getProperty(string2);
        fileInputStream.close();
        return string3;
    }

    private void initApp() {
        this.license = new License(this.laPath);
        this.setResources(new LAPResources(this.laPath));
    }

    private void initialize(Locale locale) {
        this.initApp();
        try {
            this.preferredLocale = locale == null ? this.getSupportedLanguages().getSupportedLocale(Locale.getDefault()) : this.getSupportedLanguages().getSupportedLocale(locale);
            this.defaultLocale = SupportedLanguages.DEFAULT_LANGUAGE;
            this.currentLocale = this.preferredLocale;
        }
        catch (NullPointerException nullPointerException) {
            this.defaultLocale = SupportedLanguages.DEFAULT_LANGUAGE;
            this.currentLocale = SupportedLanguages.DEFAULT_LANGUAGE;
        }
        this.changePreferredLocale();
        this.lapResources.setLocale(this.currentLocale);
    }

    public boolean isFocusTraversable() {
        Locale locale = new Locale("", "");
        Object var2_2 = null;
        String string = null;
        ResourceBundle resourceBundle = null;
        locale = LicenseAcceptanceProcess.getOSLocale();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.lex.lapapp.system.OSInfo", locale);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.out.println("Error: Missing encoding bundle. Aborted.");
        }
        string = resourceBundle.getString("focus_traversable_key");
        return !string.equals("false");
    }

    public boolean isMultiLanguage() {
        return !this.preferredLocale.equals(this.defaultLocale);
    }

    public Locale nextLocale() {
        this.currentLocale = this.currentLocale.equals(this.defaultLocale) ? this.preferredLocale : this.defaultLocale;
        return this.currentLocale;
    }

    private void notifyLAPManager(int n) {
        this.lapMan.statusChanged(n);
    }

    public static void putStatus(String string, int n) throws IOException {
        switch (n) {
            case 9: {
                LicenseAcceptanceProcess.putValue(string, "Status", Integer.toString(9));
                break;
            }
            case 3: {
                LicenseAcceptanceProcess.putValue(string, "Status", Integer.toString(3));
                break;
            }
            case 5: {
                LicenseAcceptanceProcess.putValue(string, "Status", Integer.toString(5));
                break;
            }
        }
    }

    private static void putValue(String string, String string2, String string3) throws IOException {
        Closeable closeable;
        Properties properties = new Properties();
        try {
            closeable = new FileInputStream(string + File.separator + "status.dat");
            properties.load((InputStream)closeable);
            ((FileInputStream)closeable).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        properties.put(string2, string3);
        closeable = new FileOutputStream(string + File.separator + "status.dat");
        properties.store((OutputStream)closeable, null);
        ((FileOutputStream)closeable).close();
    }

    private boolean register() {
        String string = System.getProperty("os.name");
        if (string.equalsIgnoreCase("AIX")) {
            LAP lAP = this.lapMan;
            String string2 = this.getExportPathName();
            String string3 = new String("/usr/sbin/inulag -r -n " + string2 + " -p " + lAP.getUniqueID());
            string3 = string3 + " -d " + lAP.getRegDesc();
            string3 = string3 + " -f " + string2 + File.separator + "LA" + "_" + "%l" + ".txt";
            try {
                Process process = Runtime.getRuntime().exec(string3);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public void setCurrentLocale(Locale locale) {
        if (locale != null) {
            this.currentLocale = locale;
            this.getLAPResources().setLocale(locale);
        }
    }

    public void setLicense(License license) {
        this.license = license;
        this.changePreferredLocale();
    }

    public void setNoExportLA() {
        this.noExportLA = true;
    }

    public void setResources(LAPResources lAPResources) {
        this.lapResources = lAPResources;
    }

    public void setStatus(int n) {
        switch (n) {
            case 9: {
                this.accept();
                break;
            }
            case 3: {
                this.decline();
                break;
            }
            default: {
                this.notifyLAPManager(n);
            }
        }
    }
}

