/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class PageableText
implements Pageable,
Printable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2005, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String FONTFAMILY = "sansserif";
    public static int FONTSIZE = 10;
    public static int FONTSTYLE = 0;
    public static float LINESPACEFACTOR = 1.1f;
    PageFormat format;
    PrinterJob job;
    Vector lines;
    String[] paragraphs;
    Font font;
    int linespacing;
    int linesPerPage;
    int numPages;
    int baseline = -1;
    private Locale locale;
    private double tMargin = 1.0;
    private double lMargin = 1.0;
    private double bMargin = 1.0;
    private double rMargin = 1.0;
    private double hMargin = 1.0;

    public PageableText(String[] stringArray, Locale locale) throws IOException {
        this.paragraphs = stringArray;
        this.locale = locale;
    }

    public void print() throws PrinterException {
        this.job = PrinterJob.getPrinterJob();
        this.format = this.job.defaultPage();
        this.font = new Font(FONTFAMILY, FONTSTYLE, FONTSIZE);
        this.linespacing = (int)((float)FONTSIZE * LINESPACEFACTOR);
        double d = this.format.getHeight();
        double d2 = this.format.getImageableWidth() / 8.5;
        System.out.println("dpi " + d2);
        double d3 = this.format.getImageableWidth() - this.hMargin * d2;
        System.out.println("effective width " + d3);
        this.linesPerPage = (int)Math.floor(this.format.getImageableHeight() / (double)this.linespacing);
        System.out.println("imageableWidth " + this.format.getImageableWidth());
        this.lines = this.breakText(d3, this.paragraphs, this.locale);
        this.numPages = (this.lines.size() - 1) / this.linesPerPage + 1;
        this.job.setPageable(this);
        this.job.print();
    }

    public int getNumberOfPages() {
        return this.numPages;
    }

    public PageFormat getPageFormat(int n) {
        return this.format;
    }

    public Printable getPrintable(int n) {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 | n >= this.numPages) {
            return 1;
        }
        if (this.baseline == -1) {
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            this.baseline = fontMetrics.getAscent();
        }
        graphics.setColor(Color.white);
        graphics.fillRect((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        graphics.setFont(this.font);
        graphics.setColor(Color.black);
        int n2 = n * this.linesPerPage;
        int n3 = n2 + this.linesPerPage - 1;
        if (n3 >= this.lines.size()) {
            n3 = this.lines.size() - 1;
        }
        int n4 = (int)pageFormat.getImageableX();
        int n5 = (int)pageFormat.getImageableY() + this.baseline;
        for (int i = n2; i <= n3; ++i) {
            String string = (String)this.lines.elementAt(i);
            if (string.length() > 0) {
                graphics.drawString(string, n4, n5);
            }
            n5 += this.linespacing;
        }
        return 0;
    }

    public Vector breakText(double d, String[] stringArray, Locale locale) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            if (string == null) {
                string = " ";
            }
            breakIterator.setText(string);
            int n2 = breakIterator.first();
            int n3 = breakIterator.next();
            int n4 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n5 = 0;
            while (n3 != -1) {
                String string2 = string.substring(n2, n3);
                n5 = fontMetrics.stringWidth(string2);
                if ((double)(n4 + n5) > d) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string2);
                    n4 = n5;
                } else {
                    stringBuffer.append(string2);
                    n4 += n5;
                }
                n2 = n3;
                n3 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return vector;
    }
}

